/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.charts;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.charts.VarSeries2D;
import de.elpro.ewms.core.charts.viewprefs.Series2DViewPrefs;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.time.TimelinePhase;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import de.elpro.ewms.server.http.rest.model.AbstractRestService;
import java.io.Serializable;
import javax.persistence.EntityManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="charts/chart2d/var_series_view_prefs")
public class Series2DViewPrefsRestService
extends AbstractRestService<Series2DViewPrefs> {
    private static Logger logger = Activator.getLoggerFactory().createLogger(Series2DViewPrefsRestService.class.getName());

    public Series2DViewPrefsRestService() {
        super(Series2DViewPrefs.class, (Comparable[])new Series2DViewPrefs[0]);
    }

    @GET
    @Path(value="/get/trx={trx}&cvp_id={cvp_id}&var_series_id={var_series_id}&var_inst_id={var_inst_id}&phase_id={phase_id: [^/]*}")
    @Produces(value={"application/json"})
    public Series2DViewPrefs get(@PathParam(value="trx") int trx, @PathParam(value="cvp_id") int cvpId, @PathParam(value="var_series_id") int varSeriesId, @PathParam(value="var_inst_id") int variableInstanceId, @PathParam(value="phase_id") Integer phaseId) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            if (phaseId != null) {
                return (Series2DViewPrefs)em.createQuery("SELECT o FROM Series2DViewPrefs o, Chart2DViewPrefs c WHERE o.chartViewPrefs = c AND o.series = :series AND o.variableInstance = :vi AND c.user = :user AND c.id = :cid AND o.timelinePhase = :tp", Series2DViewPrefs.class).setParameter("series", (Object)new VarSeries2D(varSeriesId)).setParameter("vi", (Object)new VariableInstance(variableInstanceId)).setParameter("user", (Object)this.getUser()).setParameter("cid", (Object)cvpId).setParameter("tp", (Object)new TimelinePhase(phaseId.intValue())).getSingleResultOrNull();
            }
            return (Series2DViewPrefs)em.createQuery("SELECT o FROM Series2DViewPrefs o, Chart2DViewPrefs c WHERE o.chartViewPrefs = c AND o.series = :series AND o.variableInstance = :vi AND c.user = :user AND c.id = :cid AND o.timelinePhase IS NULL", Series2DViewPrefs.class).setParameter("series", (Object)new VarSeries2D(varSeriesId)).setParameter("vi", (Object)new VariableInstance(variableInstanceId)).setParameter("user", (Object)this.getUser()).setParameter("cid", (Object)cvpId).getSingleResultOrNull();
        }
        catch (Exception exc) {
            logger.error("Error reading SeriesViewPrefs", (Throwable)exc);
            return null;
        }
    }

    @POST
    @Path(value="/save_or_update/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult saveOrUpdate(@PathParam(value="trx") int trx, Series2DViewPrefs seriesViewPrefs) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            Series2DViewPrefs prevPrefs = this.get(trx, seriesViewPrefs.getChartViewPrefs().getId(), seriesViewPrefs.getSeries().getId(), seriesViewPrefs.getVariableInstance().getId(), seriesViewPrefs.getTimelinePhase() != null ? seriesViewPrefs.getTimelinePhase().getId() : null);
            if (prevPrefs != null) {
                em.merge((Object)seriesViewPrefs);
            } else {
                em.persist((Object)seriesViewPrefs);
            }
            return new OperationResult((Serializable)seriesViewPrefs.getId(), ResultType.Success);
        }
        catch (Exception exc) {
            logger.error("Error deleting prev preferences", (Throwable)exc);
            return new OperationResult((Serializable)seriesViewPrefs.getId(), ResultType.UnexprectedDbError, String.format("Cannot save %s object with id=%s", this.clazz.getSimpleName(), seriesViewPrefs.getId()), exc.toString());
        }
    }

    @GET
    @Path(value="/delete/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public OperationResult delete(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        return this.deleteGeneric(trx, Integer.valueOf(id));
    }

    @Override
    protected Serializable getId(Series2DViewPrefs object) {
        return object.getId();
    }
}

