/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.charts;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.charts.SeriesGroup;
import de.elpro.ewms.core.charts.VarSeries2D;
import de.elpro.ewms.core.charts.YAxis;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import de.elpro.ewms.server.http.rest.model.AbstractRestService;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.persistence.EntityManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="charts/chart2d/var_series")
public class VarSeries2DRestService
extends AbstractRestService<VarSeries2D> {
    private static Logger logger = Activator.getLoggerFactory().createLogger(VarSeries2DRestService.class.getName());

    public VarSeries2DRestService() {
        super(VarSeries2D.class, (Comparable[])new VarSeries2D[0]);
    }

    @GET
    @Path(value="/get/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public VarSeries2D get(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        return (VarSeries2D)this.getGeneric(trx, Integer.valueOf(id));
    }

    @GET
    @Path(value="/get_by_seriesgroup/trx={trx}&group_id={group_id}")
    @Produces(value={"application/json"})
    public VarSeries2D[] getByGroup(@PathParam(value="trx") int trx, @PathParam(value="group_id") int seriesGroupId) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            List values = em.createQuery("SELECT o FROM VarSeries2D o WHERE o.seriesGroup = :sg", VarSeries2D.class).setParameter("sg", (Object)new SeriesGroup(seriesGroupId)).getResultList();
            Collections.sort(values);
            return values.toArray((VarSeries2D[])this.emptyArray);
        }
        catch (Exception exc) {
            logger.error(String.format("Error at 'get by SeriesGroup %s'", this.clazz.getSimpleName()), (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/get_ungrouped_by_yaxis/trx={trx}&yaxis_id={yaxis_id}")
    @Produces(value={"application/json"})
    public VarSeries2D[] getByYAxis(@PathParam(value="trx") int trx, @PathParam(value="yaxis_id") int yAxisId) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            List values = em.createQuery("SELECT o FROM VarSeries2D o WHERE o.YAxis = :yaxis AND o.seriesGroup IS NULL", VarSeries2D.class).setParameter("yaxis", (Object)new YAxis(yAxisId)).getResultList();
            Collections.sort(values);
            return values.toArray((VarSeries2D[])this.emptyArray);
        }
        catch (Exception exc) {
            logger.error(String.format("Error at 'get by YAxis %s'", this.clazz.getSimpleName()), (Throwable)exc);
            return null;
        }
    }

    @POST
    @Path(value="/save_or_update/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult saveOrUpdate(@PathParam(value="trx") int trx, VarSeries2D varSeries) {
        return this.saveOrUpdateGeneric(trx, varSeries);
    }

    @GET
    @Path(value="/delete/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public OperationResult delete(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        return this.deleteGeneric(trx, Integer.valueOf(id));
    }

    @Override
    protected Serializable getId(VarSeries2D object) {
        return object.getId();
    }
}

