/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.charts;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.charts.Chart2D;
import de.elpro.ewms.core.charts.YAxis;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import de.elpro.ewms.server.http.rest.model.AbstractRestService;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.persistence.EntityManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="charts/chart2d/yaxis")
public class YAxisRestService
extends AbstractRestService<YAxis> {
    private static Logger logger = Activator.getLoggerFactory().createLogger(YAxisRestService.class.getName());

    public YAxisRestService() {
        super(YAxis.class, (Comparable[])new YAxis[0]);
    }

    @GET
    @Path(value="/get/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public YAxis get(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        return (YAxis)this.getGeneric(trx, Integer.valueOf(id));
    }

    @GET
    @Path(value="/get_by_chart/trx={trx}&chart_id={chart_id}")
    @Produces(value={"application/json"})
    public YAxis[] getAll(@PathParam(value="trx") int trx, @PathParam(value="chart_id") int chartId) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            List values = em.createQuery("SELECT o FROM YAxis o WHERE o.chart = :chart", YAxis.class).setParameter("chart", (Object)new Chart2D(chartId)).getResultList();
            Collections.sort(values);
            return values.toArray((YAxis[])this.emptyArray);
        }
        catch (Exception exc) {
            logger.error(String.format("Error at 'get by chart %s'", this.clazz.getSimpleName()), (Throwable)exc);
            return null;
        }
    }

    @POST
    @Path(value="/save_or_update/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult saveOrUpdate(@PathParam(value="trx") int trx, YAxis yAxis) {
        return this.saveOrUpdateGeneric(trx, yAxis);
    }

    @GET
    @Path(value="/delete/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public OperationResult delete(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        return this.deleteGeneric(trx, Integer.valueOf(id));
    }

    @Override
    protected Serializable getId(YAxis object) {
        return object.getId();
    }
}

