/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.datasource;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.datasource.DataGroup;
import de.elpro.ewms.core.datasource.DataSource;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.VariableInstanceType;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import de.elpro.ewms.server.http.rest.model.AbstractRestService;
import de.elpro.ewms.server.transactions.TransactionChangeset;
import java.io.Serializable;
import java.util.List;
import javax.persistence.EntityManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="datasource/source/datasource/datagroup")
public class DataGroupRestService
extends AbstractRestService<DataGroup> {
    private final Logger logger = Activator.getLoggerFactory().createLogger(DataGroupRestService.class.getName());

    public DataGroupRestService() {
        super(DataGroup.class, (Comparable[])new DataGroup[0]);
    }

    @GET
    @Path(value="/get/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public DataGroup get(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        return (DataGroup)this.getGeneric(trx, Integer.valueOf(id));
    }

    @GET
    @Path(value="/get_all/trx={trx}")
    @Produces(value={"application/json"})
    public DataGroup[] getAll(@PathParam(value="trx") int trx) {
        return (DataGroup[])this.getAllGeneric(trx);
    }

    @GET
    @Path(value="/get_by_datasource/trx={trx}&ds_id={ds_id}")
    @Produces(value={"application/json"})
    public DataGroup[] getByDataSource(@PathParam(value="trx") int trx, @PathParam(value="ds_id") int dsId) {
        EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
        try {
            List list = em.createQuery("SELECT o FROM DataGroup o WHERE o.dataSource = :ds", DataGroup.class).setParameter("ds", (Object)new DataSource(dsId)).getResultList();
            DataGroup[] result = new DataGroup[list.size()];
            int i = 0;
            for (Object o : list) {
                result[i++] = (DataGroup)o;
            }
            return result;
        }
        catch (Exception exc) {
            this.logger.error("Error loading datagroups", (Throwable)exc);
            return null;
        }
    }

    @POST
    @Path(value="/save_or_update/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult saveOrUpdate(@PathParam(value="trx") int trx, DataGroup dataGroup) {
        OperationResult result = this.saveOrUpdateGeneric(trx, dataGroup);
        TransactionChangeset.changedOrNew((int)trx, (Object)dataGroup);
        return result;
    }

    @GET
    @Path(value="/delete/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public OperationResult delete(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
        List readVars = em.createQuery("SELECT o FROM Variable o WHERE o.plcDefaultDataGroup = :group", Variable.class).setParameter("group", (Object)new DataGroup(id)).getResultList();
        for (Variable var : readVars) {
            var.setPlcDefaultDataGroup(null);
            em.merge((Object)var);
        }
        List readInstances = em.createQuery("SELECT o FROM VariableInstance o WHERE o.type = :type AND o.plcDataGroup = :group", VariableInstance.class).setParameter("type", (Object)VariableInstanceType.PLC).setParameter("group", (Object)new DataGroup(id)).getResultList();
        for (VariableInstance instance : readInstances) {
            instance.setPlcDataGroup(null);
            em.merge((Object)instance);
        }
        OperationResult result = this.deleteGeneric(trx, Integer.valueOf(id));
        if (result.getType() == ResultType.Success) {
            TransactionChangeset.removed((int)trx, (Object)new DataGroup(id));
        }
        return result;
    }

    @GET
    @Path(value="/get_all_varinstances/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public VariableInstance[] getAllVarInstances(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
        try {
            List readInstances = em.createQuery("SELECT o FROM VariableInstance o WHERE o.type = :type AND o.plcDataGroup = :group", VariableInstance.class).setParameter("type", (Object)VariableInstanceType.PLC).setParameter("group", (Object)new DataGroup(id)).getResultList();
            return readInstances.toArray(new VariableInstance[0]);
        }
        catch (Exception exc) {
            this.logger.error(String.format("Error searching vor Variable Instances for DataGroup with id %d", id), (Throwable)exc);
            return null;
        }
    }

    @Override
    protected Serializable getId(DataGroup object) {
        return object.getId();
    }
}

