/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.datasource;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.datasource.DataSource;
import de.elpro.ewms.core.datasource.DataSourceAlt;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import de.elpro.ewms.server.http.rest.model.AbstractRestService;
import de.elpro.ewms.server.transactions.TransactionChangeset;
import java.io.Serializable;
import javax.persistence.EntityManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="datasource/source_alt")
public class DataSourceAltRestService
extends AbstractRestService<DataSourceAlt> {
    private final Logger logger = Activator.getLoggerFactory().createLogger(DataSourceAltRestService.class.getName());

    public DataSourceAltRestService() {
        super(DataSourceAlt.class, (Comparable[])new DataSourceAlt[0]);
    }

    @GET
    @Path(value="/get/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public DataSourceAlt get(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        return (DataSourceAlt)this.getGeneric(trx, Integer.valueOf(id));
    }

    @GET
    @Path(value="/get_all/trx={trx}")
    @Produces(value={"application/json"})
    public DataSourceAlt[] getAll(@PathParam(value="trx") int trx) {
        return (DataSourceAlt[])this.getAllGeneric(trx);
    }

    @GET
    @Path(value="/get_all/trx={trx}&datasource_id={datasource_id}")
    @Produces(value={"application/json"})
    public DataSourceAlt[] getAll(@PathParam(value="trx") int trx, @PathParam(value="datasource_id") int dataSourceId) {
        DataSource dataSource;
        block3: {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            try {
                dataSource = (DataSource)em.find(DataSource.class, (Object)dataSourceId);
                if (dataSource != null) break block3;
                return null;
            }
            catch (Exception exc) {
                this.logger.error("Error fetching alternative datasources", (Throwable)exc);
                return null;
            }
        }
        return dataSource.getAlternativeDataSources().toArray((DataSourceAlt[])this.emptyArray);
    }

    @POST
    @Path(value="/save_or_update/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult saveOrUpdate(@PathParam(value="trx") int trx, DataSourceAlt dataSourceAlt) {
        OperationResult result = this.saveOrUpdateGeneric(trx, dataSourceAlt);
        TransactionChangeset.changedOrNew((int)trx, (Object)dataSourceAlt);
        TransactionChangeset.changedOrNew((int)trx, (Object)dataSourceAlt.getMaster());
        return result;
    }

    @GET
    @Path(value="/delete/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public OperationResult delete(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        OperationResult result = this.deleteGeneric(trx, Integer.valueOf(id));
        if (result.getType() == ResultType.Success) {
            TransactionChangeset.removed((int)trx, (Object)new DataSource(id));
        }
        return result;
    }

    @Override
    protected Serializable getId(DataSourceAlt object) {
        return object.getId();
    }
}

