/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.datasource;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.datasource.DataSource;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.server.http.rest.model.AbstractRestService;
import de.elpro.ewms.server.transactions.TransactionChangeset;
import java.io.Serializable;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Secured
@Path(value="datasource/source")
public class DataSourceRestService
extends AbstractRestService<DataSource> {
    public DataSourceRestService() {
        super(DataSource.class, (Comparable[])new DataSource[0]);
    }

    @GET
    @Path(value="/get/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public DataSource get(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        return (DataSource)this.getGeneric(trx, Integer.valueOf(id));
    }

    @GET
    @Path(value="/get_all/trx={trx}")
    @Produces(value={"application/json"})
    public DataSource[] getAll(@PathParam(value="trx") int trx) {
        return (DataSource[])this.getAllGeneric(trx);
    }

    @POST
    @Path(value="/save_or_update/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult saveOrUpdate(@PathParam(value="trx") int trx, DataSource dataSource) {
        OperationResult result = this.saveOrUpdateGeneric(trx, dataSource);
        TransactionChangeset.changedOrNew((int)trx, (Object)dataSource);
        return result;
    }

    @GET
    @Path(value="/delete/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public OperationResult delete(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        OperationResult result = this.deleteGeneric(trx, Integer.valueOf(id));
        if (result.getType() == ResultType.Success) {
            TransactionChangeset.removed((int)trx, (Object)new DataSource(id));
        }
        return result;
    }

    @Override
    protected Serializable getId(DataSource object) {
        return object.getId();
    }
}

