/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.dataview;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.dataview.ViewNode;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import de.elpro.ewms.server.http.rest.model.AbstractRestService;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.persistence.EntityManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="dataview/node")
public class ViewNodeRestService
extends AbstractRestService<ViewNode> {
    private final Logger logger = Activator.getLoggerFactory().createLogger(ViewNodeRestService.class.getName());

    public ViewNodeRestService() {
        super(ViewNode.class, (Comparable[])new ViewNode[0]);
    }

    @GET
    @Path(value="/get/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public ViewNode get(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        return (ViewNode)this.getGeneric(trx, Integer.valueOf(id));
    }

    @GET
    @Path(value="/get_all/trx={trx}")
    @Produces(value={"application/json"})
    public ViewNode[] getAll(@PathParam(value="trx") int trx) {
        return (ViewNode[])this.getAllGeneric(trx);
    }

    @POST
    @Path(value="/save_or_update/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult saveOrUpdate(@PathParam(value="trx") int trx, ViewNode node) {
        return this.saveOrUpdateGeneric(trx, node);
    }

    @GET
    @Path(value="/delete/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public OperationResult delete(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        return this.deleteGeneric(trx, Integer.valueOf(id));
    }

    @GET
    @Path(value="/get_children/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public ViewNode[] getRootNodes(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
        try {
            List nodes = em.createQuery("SELECT o FROM ViewNode o WHERE o.parent = :parent", ViewNode.class).setParameter("parent", (Object)new ViewNode(id)).getResultList();
            Collections.sort(nodes);
            return nodes.toArray(new ViewNode[0]);
        }
        catch (Exception exc) {
            this.logger.error(String.format("Error searching for children for ViewNode with id %d", id), (Throwable)exc);
            return null;
        }
    }

    @Override
    protected Serializable getId(ViewNode object) {
        return object.getId();
    }
}

