/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.events;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.events.Event;
import de.elpro.ewms.core.events.EventAction;
import de.elpro.ewms.core.events.EventActionJobDescriptor;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.events.EventActionJobs;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import de.elpro.ewms.server.http.rest.model.AbstractRestService;
import de.elpro.ewms.server.transactions.TransactionChangeset;
import java.io.Serializable;
import javax.persistence.EntityManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="events/event_action")
public class EventActionRestService
extends AbstractRestService<EventAction> {
    private final Logger logger = Activator.getLoggerFactory().createLogger(EventActionRestService.class.getName());

    public EventActionRestService() {
        super(EventAction.class, (Comparable[])new EventAction[0]);
    }

    @GET
    @Path(value="/get/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public EventAction get(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        return (EventAction)this.getGeneric(trx, Integer.valueOf(id));
    }

    @GET
    @Path(value="/get_by_event/trx={trx}&event_id={event_id}")
    @Produces(value={"application/json"})
    public EventAction[] getByEvent(@PathParam(value="trx") int trx, @PathParam(value="event_id") int eventId) {
        EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
        Event event = (Event)em.find(Event.class, (Object)eventId);
        if (event == null) {
            return null;
        }
        return event.getEventActions().toArray(new EventAction[0]);
    }

    @GET
    @Path(value="/get_job_descriptors")
    @Produces(value={"application/json"})
    public EventActionJobDescriptor[] getJobDescriptors() {
        return EventActionJobs.getDescriptors().toArray(new EventActionJobDescriptor[0]);
    }

    @POST
    @Path(value="/save_or_update/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult saveOrUpdate(@PathParam(value="trx") int trx, EventAction eventAction) {
        if (!this.getUser().isAdmin()) {
            return OperationResult.ACCESS_DENIED;
        }
        OperationResult result = this.saveOrUpdateGeneric(trx, eventAction);
        TransactionChangeset.changedOrNew((int)trx, (Object)eventAction);
        return result;
    }

    @GET
    @Path(value="/delete/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public OperationResult delete(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        OperationResult result = this.deleteGeneric(trx, Integer.valueOf(id));
        if (result.getType() == ResultType.Success) {
            TransactionChangeset.removed((int)trx, (Object)new EventAction(id));
        }
        return result;
    }

    @Override
    protected Serializable getId(EventAction object) {
        return object.getId();
    }
}

