/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.events;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.events.Event;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import de.elpro.ewms.server.http.rest.model.AbstractRestService;
import de.elpro.ewms.server.transactions.TransactionChangeset;
import java.io.Serializable;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="events/event")
public class EventRestService
extends AbstractRestService<Event> {
    private final Logger logger = Activator.getLoggerFactory().createLogger(EventRestService.class.getName());

    public EventRestService() {
        super(Event.class, (Comparable[])new Event[0]);
    }

    @GET
    @Path(value="/get/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public Event get(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        return (Event)this.getGeneric(trx, Integer.valueOf(id));
    }

    @GET
    @Path(value="/get_all/trx={trx}")
    @Produces(value={"application/json"})
    public Event[] getAll(@PathParam(value="trx") int trx) {
        return (Event[])this.getAllGeneric(trx);
    }

    @POST
    @Path(value="/save_or_update/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult saveOrUpdate(@PathParam(value="trx") int trx, Event event) {
        if (!this.getUser().isAdmin()) {
            return OperationResult.ACCESS_DENIED;
        }
        OperationResult result = this.saveOrUpdateGeneric(trx, event);
        TransactionChangeset.changedOrNew((int)trx, (Object)event);
        return result;
    }

    @GET
    @Path(value="/delete/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public OperationResult delete(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        OperationResult result = this.deleteGeneric(trx, Integer.valueOf(id));
        if (result.getType() == ResultType.Success) {
            TransactionChangeset.removed((int)trx, (Object)new Event(id));
        }
        return result;
    }

    @Override
    protected Serializable getId(Event object) {
        return object.getId();
    }
}

