/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.export;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.export.ExportDataProfile;
import de.elpro.ewms.core.export.ExportDataRequest;
import de.elpro.ewms.core.export.ExportDataWriterDescriptor;
import de.elpro.ewms.core.time.TimeRange;
import de.elpro.ewms.core.time.TsIntervals;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.server.Server;
import de.elpro.ewms.server.cache.ORMCache;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.export.ExportDataSchedule;
import de.elpro.ewms.server.export.ExportDataWriters;
import de.elpro.ewms.server.export.VarValuesInvalidatedTracker;
import de.elpro.ewms.server.export.component.ExportDataServerComponent;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import de.elpro.ewms.server.http.rest.model.AbstractRestService;
import de.elpro.ewms.server.rasterizedvalues.RasterizedValues;
import de.elpro.ewms.server.transactions.TransactionChangeset;
import java.io.Serializable;
import java.time.Instant;
import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="export/data_profile")
public class ExportDataProfileRestService
extends AbstractRestService<ExportDataProfile> {
    private final Logger logger = Activator.getLoggerFactory().createLogger(ExportDataProfileRestService.class.getName());

    public ExportDataProfileRestService() {
        super(ExportDataProfile.class, (Comparable[])new ExportDataProfile[0]);
    }

    @GET
    @Path(value="/get/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public ExportDataProfile get(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        return (ExportDataProfile)this.getGeneric(trx, Integer.valueOf(id));
    }

    @GET
    @Path(value="/get_all/trx={trx}")
    @Produces(value={"application/json"})
    public ExportDataProfile[] getAll(@PathParam(value="trx") int trx) {
        return (ExportDataProfile[])this.getAllGeneric(trx);
    }

    @GET
    @Path(value="/get_available_data_writers")
    @Produces(value={"application/json"})
    public ExportDataWriterDescriptor[] getAvailableExportDataWriters() {
        return ExportDataWriters.getDescriptors();
    }

    @POST
    @Path(value="/export_data")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult exportData(ExportDataRequest request) {
        if (!this.getUser().isAdmin()) {
            return OperationResult.ACCESS_DENIED;
        }
        try {
            ExportDataServerComponent serverComponent = (ExportDataServerComponent)Server.getServerComponent((String)"com.eos.server.export");
            ExportDataSchedule schedule = serverComponent.getSchedule(request.getProfile());
            ExportDataProfile exportJob = schedule.getExportJob();
            VarValuesInvalidatedTracker invalidatedTracker = schedule.getInvalidationTracker();
            RasterizedValues rasterizedValues = Server.getRawValuesViews().getValuesView(exportJob.getDataSourceValuesViewType(), exportJob.getDataSourceValuesViewIndex());
            TimeRange availableTimeRange = rasterizedValues.getComputationTimeRange();
            Instant from = request.getFrom() != null && request.getFrom().isAfter(availableTimeRange.getFrom()) ? request.getFrom() : availableTimeRange.getFrom();
            Instant to = request.getTo() != null && request.getTo().isBefore(availableTimeRange.getTo()) ? request.getTo() : availableTimeRange.getTo();
            HashMap<VariableInstance, TsIntervals> invalidatedIntervals = new HashMap<VariableInstance, TsIntervals>();
            for (VariableInstance instance : ORMCache.getVariableInstances()) {
                if (!exportJob.applyInvalidationListener(instance)) continue;
                TsIntervals intervals = new TsIntervals();
                intervals.addInterval(from, to);
                invalidatedIntervals.put(instance, intervals);
            }
            invalidatedTracker.addInvalidatedIntervals(invalidatedIntervals);
            schedule.wake();
            return OperationResult.SUCCESS;
        }
        catch (Exception exc) {
            this.logger.errorf("Error exporting data", (Throwable)exc, new Object[0]);
            return new OperationResult(ResultType.UnexprectedError, exc.getMessage());
        }
    }

    @POST
    @Path(value="/save_or_update/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult saveOrUpdate(@PathParam(value="trx") int trx, ExportDataProfile exportDataProfile) {
        if (!this.getUser().isAdmin()) {
            return OperationResult.ACCESS_DENIED;
        }
        OperationResult result = this.saveOrUpdateGeneric(trx, exportDataProfile);
        TransactionChangeset.changedOrNew((int)trx, (Object)exportDataProfile);
        return result;
    }

    @GET
    @Path(value="/delete/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public OperationResult delete(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        if (!this.getUser().isAdmin()) {
            return OperationResult.ACCESS_DENIED;
        }
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            ExportDataProfile exportDataProfile = (ExportDataProfile)em.find(ExportDataProfile.class, (Object)id);
            em.remove((Object)exportDataProfile);
            TransactionChangeset.removed((int)trx, (Object)exportDataProfile);
            return new OperationResult((Serializable)Integer.valueOf(id), ResultType.Success);
        }
        catch (Exception exc) {
            this.logger.error(String.format("Error deleting ExportDataProfile with id %d", id), (Throwable)exc);
            return new OperationResult((Serializable)Integer.valueOf(id), ResultType.UnexprectedDbError, String.format("Cannot delete %s object with id=%s", this.clazz.getSimpleName(), id), exc.toString());
        }
    }

    @Override
    protected Serializable getId(ExportDataProfile object) {
        return object.getId();
    }
}

