/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.locale;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.locale.LocaleDefinition;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.http.rest.model.AbstractRestService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Secured
@Path(value="locale/localedefinition")
public class LocaleDefinitionRestService
extends AbstractRestService<LocaleDefinition> {
    public LocaleDefinitionRestService() {
        super(LocaleDefinition.class, (Comparable[])new LocaleDefinition[0]);
    }

    @GET
    @Path(value="/get/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public LocaleDefinition get(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        return (LocaleDefinition)this.getGeneric(trx, Integer.valueOf(id));
    }

    @GET
    @Path(value="/get_all/trx={trx}")
    @Produces(value={"application/json"})
    public LocaleDefinition[] getAll(@PathParam(value="trx") int trx) {
        return (LocaleDefinition[])this.getAllGeneric(trx);
    }

    @GET
    @Path(value="/get_fallback_locales/trx={trx}")
    @Produces(value={"application/json"})
    public LocaleDefinition[] getFallbackLocales(@PathParam(value="trx") int trx) {
        EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
        List fallbackLocales = em.createQuery("SELECT l FROM LocaleDefinition l WHERE l.fallbackLocale is true", LocaleDefinition.class).getResultList();
        return (LocaleDefinition[])fallbackLocales.toArray(LocaleDefinition[]::new);
    }

    @GET
    @Path(value="/get_all_visible/trx={trx}")
    @Produces(value={"application/json"})
    public LocaleDefinition[] getAllVisible(@PathParam(value="trx") int trx) {
        User user = this.getUser();
        ArrayList<LocaleDefinition> visibleDefs = new ArrayList<LocaleDefinition>();
        LocaleDefinition[] localeDefinitionArray = (LocaleDefinition[])this.getAllGeneric(trx);
        int n = localeDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            LocaleDefinition ld = localeDefinitionArray[n2];
            if (!ld.isEngineeringLocale() || user.isAdmin()) {
                visibleDefs.add(ld);
            }
            ++n2;
        }
        return visibleDefs.toArray((LocaleDefinition[])this.emptyArray);
    }

    @POST
    @Path(value="/save_or_update/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult saveOrUpdate(@PathParam(value="trx") int trx, LocaleDefinition node) {
        return this.saveOrUpdateGeneric(trx, node);
    }

    @GET
    @Path(value="/delete/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public OperationResult delete(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        return this.deleteGeneric(trx, Integer.valueOf(id));
    }

    @Override
    protected Serializable getId(LocaleDefinition object) {
        return object.getId();
    }
}

