/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.log;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.log.LogLevel;
import de.elpro.ewms.core.log.LogMessage;
import de.elpro.ewms.core.log.LogType;
import de.elpro.ewms.server.http.rest.model.AbstractRestService;
import de.elpro.ewms.server.logger.LogDB;
import java.io.Serializable;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Secured
@Path(value="log/message")
public class LogMessageRestService
extends AbstractRestService<LogMessage> {
    public LogMessageRestService() {
        super(LogMessage.class, (Comparable[])new LogMessage[0]);
    }

    @GET
    @Path(value="/get/last/type={type}&count={count}&level={level}")
    @Produces(value={"application/json"})
    public LogMessage[] getLastMessages(@PathParam(value="type") String typeStr, @PathParam(value="count") int count, @PathParam(value="level") String levelStr) {
        User user = this.getUser();
        if (user == null || !user.isActive()) {
            return null;
        }
        LogType type = LogType.valueOf((String)typeStr);
        LogLevel level = LogLevel.valueOf((String)levelStr);
        return LogDB.getLastMessages((LogType)type, (int)count, (LogLevel)level);
    }

    @GET
    @Path(value="/get/last/type={type}&level={level}")
    @Produces(value={"application/json"})
    public LogMessage getLastMessage(@PathParam(value="type") String typeStr, @PathParam(value="level") String levelStr) {
        User user = this.getUser();
        if (user == null || !user.isActive()) {
            return null;
        }
        LogType type = LogType.valueOf((String)typeStr);
        LogLevel level = LogLevel.valueOf((String)levelStr);
        LogMessage lm = LogDB.getLastMessage((LogType)type, (LogLevel)level);
        return lm;
    }

    @GET
    @Path(value="/get/count/type={type}&level={level}")
    @Produces(value={"application/json"})
    public Integer getMessageCount(@PathParam(value="type") String typeStr, @PathParam(value="level") String levelStr) {
        User user = this.getUser();
        if (user == null || !user.isActive()) {
            return -1;
        }
        LogType type = LogType.valueOf((String)typeStr);
        LogLevel level = LogLevel.valueOf((String)levelStr);
        return LogDB.getMessageCount((LogType)type, (LogLevel)level);
    }

    @Override
    protected Serializable getId(LogMessage object) {
        return null;
    }
}

