/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.measurements;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.VariableInstanceType;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.IVarValuesCollection;
import de.elpro.ewms.core.variable.value.MeasuredValue;
import de.elpro.ewms.core.variable.value.VarInstanceMeasuredValuesMap;
import de.elpro.ewms.core.variable.value.VarInstanceValuesCollectionMap;
import de.elpro.ewms.server.Server;
import de.elpro.ewms.server.cache.ORMCache;
import de.elpro.ewms.server.db.rawmeasurements.MeasurementsStorageUtils;
import de.elpro.ewms.server.http.rest.auth.AuthenticatedRestService;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import de.elpro.ewms.server.storage.MeasurementsStorage;
import de.elpro.ewms.server.valueswriter.MeasurementsPool;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="measurements")
public class MeasurementsRestService
extends AuthenticatedRestService {
    private final Logger logger = Activator.getLoggerFactory().createLogger(MeasurementsRestService.class.getName());
    private static final long TS_1990 = ZonedDateTime.of(1990, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC).toInstant().toEpochMilli();

    @POST
    @Path(value="/append/measured_values_map/sync_exec={sync_exec}")
    @Consumes(value={"application/json"})
    public OperationResult appendMeasuredValues(@PathParam(value="sync_exec") boolean syncExec, VarInstanceMeasuredValuesMap valuesMap) {
        try {
            OperationResult result = OperationResult.SUCCESS;
            long maxEndTs = Instant.now().toEpochMilli() + Raster.Second_15.toMilli();
            Map appendValues = valuesMap.getBackingMap();
            HashMap<VariableInstance, List<MeasuredValue>> r = new HashMap<VariableInstance, List<MeasuredValue>>();
            for (Map.Entry entry : appendValues.entrySet()) {
                MeasuredValue[] values;
                VariableInstance instance;
                int instanceId = ((VariableInstance)entry.getKey()).getId();
                result = MeasurementsRestService.checkPLCVariableInstance(instanceId, instance = ORMCache.getVariableInstance((int)instanceId));
                if (result.getType() != ResultType.Success) {
                    return result;
                }
                MeasuredValue prevMV = null;
                MeasuredValue[] measuredValueArray = values = (MeasuredValue[])entry.getValue();
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    MeasuredValue mv = measuredValueArray[n2];
                    result = MeasurementsRestService.checkMeasuredValue(maxEndTs, prevMV, (IVarValue)mv);
                    if (result.getType() != ResultType.Success) {
                        return result;
                    }
                    prevMV = mv;
                    ++n2;
                }
                r.put(instance, Arrays.asList((MeasuredValue[])entry.getValue()));
            }
            appendValues.clear();
            MeasurementsRestService.appendMeasuredValues(r, syncExec);
            return OperationResult.SUCCESS;
        }
        catch (Exception exc) {
            return new OperationResult(ResultType.UnexprectedError, exc.getMessage());
        }
    }

    @POST
    @Path(value="/append/values_collection_map/sync_exec={sync_exec}")
    @Consumes(value={"application/json"})
    public OperationResult appendMeasuredValues(@PathParam(value="sync_exec") boolean syncExec, VarInstanceValuesCollectionMap valuesMap) {
        try {
            OperationResult result = OperationResult.SUCCESS;
            long maxEndTs = Instant.now().toEpochMilli() + Raster.Second_15.toMilli();
            Map appendValues = valuesMap.getBackingMap();
            HashMap<VariableInstance, List<MeasuredValue>> r = new HashMap<VariableInstance, List<MeasuredValue>>();
            for (Map.Entry entry : appendValues.entrySet()) {
                VariableInstance instance;
                int instanceId = ((VariableInstance)entry.getKey()).getId();
                result = MeasurementsRestService.checkPLCVariableInstance(instanceId, instance = ORMCache.getVariableInstance((int)instanceId));
                if (result.getType() != ResultType.Success) {
                    return result;
                }
                MeasuredValue prevMV = null;
                IVarValuesCollection values = (IVarValuesCollection)entry.getValue();
                ArrayList<MeasuredValue> mvArray = new ArrayList<MeasuredValue>(values.size());
                for (IVarValue v : values) {
                    result = MeasurementsRestService.checkMeasuredValue(maxEndTs, prevMV, v);
                    if (result.getType() != ResultType.Success) {
                        return result;
                    }
                    prevMV = (MeasuredValue)v;
                    mvArray.add(prevMV);
                }
                r.put(instance, mvArray);
            }
            appendValues.clear();
            MeasurementsRestService.appendMeasuredValues(r, syncExec);
            return OperationResult.SUCCESS;
        }
        catch (Exception exc) {
            return new OperationResult(ResultType.UnexprectedError, exc.getMessage());
        }
    }

    private static void appendMeasuredValues(Map<VariableInstance, List<MeasuredValue>> values, boolean syncExec) throws Exception {
        MeasurementsPool.appendValues(values);
        MeasurementsPool.applyChanges((boolean)syncExec);
    }

    @POST
    @Path(value="/import/measured_values_map")
    @Consumes(value={"application/json"})
    public OperationResult importMeasuredValues(VarInstanceMeasuredValuesMap request) {
        if (!this.getUser().isAdmin()) {
            return OperationResult.ACCESS_DENIED;
        }
        OperationResult result = OperationResult.SUCCESS;
        long maxEndTs = Instant.now().toEpochMilli() + Raster.Second_15.toMilli();
        Map insertValues = request.getBackingMap();
        HashMap<VariableInstance, IVarValuesCollection> r = new HashMap<VariableInstance, IVarValuesCollection>();
        for (Map.Entry entry : insertValues.entrySet()) {
            MeasuredValue[] values;
            VariableInstance instance;
            int instanceId = ((VariableInstance)entry.getKey()).getId();
            result = MeasurementsRestService.checkPLCVariableInstance(instanceId, instance = ORMCache.getVariableInstance((int)instanceId));
            if (result.getType() != ResultType.Success) {
                return result;
            }
            MeasuredValue prevMV = null;
            MeasuredValue[] measuredValueArray = values = (MeasuredValue[])entry.getValue();
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                MeasuredValue mv = measuredValueArray[n2];
                result = MeasurementsRestService.checkMeasuredValue(maxEndTs, prevMV, (IVarValue)mv);
                if (result.getType() != ResultType.Success) {
                    return result;
                }
                prevMV = mv;
                ++n2;
            }
            r.put(instance, IVarValuesCollection.create((IVarValue[])values));
        }
        insertValues.clear();
        try {
            MeasurementsStorageUtils.importMeasurements((long)maxEndTs, r, (boolean)true);
        }
        catch (Exception exc) {
            return new OperationResult(ResultType.UnexprectedError, exc.getMessage());
        }
        return result;
    }

    @POST
    @Path(value="/import/values_collection_map")
    @Consumes(value={"application/json"})
    public OperationResult importMeasuredValues(VarInstanceValuesCollectionMap request) {
        if (!this.getUser().isAdmin()) {
            return OperationResult.ACCESS_DENIED;
        }
        try {
            MeasurementsStorageUtils.importMeasurements((VarInstanceValuesCollectionMap)request, (boolean)true);
        }
        catch (IllegalArgumentException exc) {
            return new OperationResult(ResultType.ExpectedError, exc.getMessage());
        }
        catch (Exception exc) {
            return new OperationResult(ResultType.UnexprectedError, exc.getMessage());
        }
        return OperationResult.SUCCESS;
    }

    @POST
    @Path(value="/import/predicted_measured_values_map")
    @Consumes(value={"application/json"})
    public OperationResult importPredictedValues(VarInstanceMeasuredValuesMap request) {
        if (!this.getUser().isAdmin()) {
            return OperationResult.ACCESS_DENIED;
        }
        OperationResult result = OperationResult.SUCCESS;
        Map insertValues = request.getBackingMap();
        HashMap<VariableInstance, IVarValuesCollection> r = new HashMap<VariableInstance, IVarValuesCollection>();
        for (Map.Entry entry : insertValues.entrySet()) {
            MeasuredValue[] values;
            VariableInstance instance;
            int instanceId = ((VariableInstance)entry.getKey()).getId();
            result = MeasurementsRestService.checkPLCVariableInstance(instanceId, instance = ORMCache.getVariableInstance((int)instanceId));
            if (result.getType() != ResultType.Success) {
                return result;
            }
            MeasuredValue prevMV = null;
            MeasuredValue[] measuredValueArray = values = (MeasuredValue[])entry.getValue();
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                MeasuredValue mv = measuredValueArray[n2];
                result = MeasurementsRestService.checkMeasuredValue(Long.MAX_VALUE, prevMV, (IVarValue)mv);
                if (result.getType() != ResultType.Success) {
                    return result;
                }
                prevMV = mv;
                ++n2;
            }
            r.put(instance, IVarValuesCollection.create((IVarValue[])values));
        }
        insertValues.clear();
        try {
            MeasurementsStorageUtils.importPredictedValues(r, (boolean)true);
        }
        catch (Exception exc) {
            return new OperationResult(ResultType.UnexprectedError, exc.getMessage());
        }
        return result;
    }

    @POST
    @Path(value="/import/predicted_values_collection_map")
    @Consumes(value={"application/json"})
    public OperationResult importPredictedValues(VarInstanceValuesCollectionMap request) {
        if (!this.getUser().isAdmin()) {
            return OperationResult.ACCESS_DENIED;
        }
        try {
            MeasurementsStorageUtils.importPredictedValues((Map)request.getBackingMap(), (boolean)true);
        }
        catch (IllegalArgumentException exc) {
            return new OperationResult(ResultType.ExpectedError, exc.getMessage());
        }
        catch (Exception exc) {
            return new OperationResult(ResultType.UnexprectedError, exc.getMessage());
        }
        return OperationResult.SUCCESS;
    }

    @GET
    @Path(value="/copy_measured_values/src_object_id={src_object_id}&dst_object_id={dst_object_id}&from={from: [^/]*}&to={to: [^/]*}")
    @Produces(value={"application/json"})
    public OperationResult copyMeasuredValues(@PathParam(value="src_object_id") int srcObjectId, @PathParam(value="dst_object_id") int dstObjectId, @PathParam(value="from") Long fromTs, @PathParam(value="to") Long toTs) {
        if (!this.getUser().isAdmin()) {
            return OperationResult.ACCESS_DENIED;
        }
        try (EntityManager em = Server.getEntityManagerFactory().createEntityManager();){
            StructureObject srcObject = (StructureObject)em.find(StructureObject.class, (Object)srcObjectId);
            StructureObject dstObject = (StructureObject)em.find(StructureObject.class, (Object)dstObjectId);
            if (srcObject == null) {
                OperationResult operationResult = new OperationResult(ResultType.ExpectedError, "Could not find src object");
                return operationResult;
            }
            if (dstObject == null) {
                OperationResult operationResult = new OperationResult(ResultType.ExpectedError, "Could not find dst object");
                return operationResult;
            }
            if (!srcObject.getStructureClass().equals((Object)dstObject.getStructureClass())) {
                OperationResult operationResult = new OperationResult(ResultType.ExpectedError, "Structure Classes are not the same");
                return operationResult;
            }
            HashMap<Variable, VariableInstance> srcInstances = new HashMap<Variable, VariableInstance>();
            for (VariableInstance instance : srcObject.getVariableInstances()) {
                if (instance.getType() != VariableInstanceType.PLC) continue;
                srcInstances.put(instance.getVariable(), instance);
            }
            HashMap<Variable, VariableInstance> dstInstances = new HashMap<Variable, VariableInstance>();
            for (VariableInstance instance : dstObject.getVariableInstances()) {
                if (instance.getType() != VariableInstanceType.PLC) continue;
                dstInstances.put(instance.getVariable(), instance);
            }
            Map values = MeasurementsStorage.getInstance().readMeasurements(fromTs, toTs, new LinkedHashSet(srcInstances.values()));
            VarInstanceValuesCollectionMap importValues = new VarInstanceValuesCollectionMap();
            for (VariableInstance srcInstance : srcObject.getVariableInstances()) {
                IVarValuesCollection srcValues;
                VariableInstance dstInstance = (VariableInstance)dstInstances.get(srcInstance.getVariable());
                if (dstInstance == null || srcInstance.getType() != VariableInstanceType.PLC || dstInstance.getType() != VariableInstanceType.PLC || (srcValues = (IVarValuesCollection)values.get(srcInstance)) == null) continue;
                importValues.put(dstInstance, srcValues);
            }
            MeasurementsStorageUtils.importMeasurements((VarInstanceValuesCollectionMap)importValues, (boolean)true);
            OperationResult operationResult = OperationResult.SUCCESS;
            return operationResult;
        }
    }

    private static OperationResult checkPLCVariableInstance(int id, VariableInstance instance) {
        if (instance == null) {
            return new OperationResult(ResultType.ExpectedError, String.format("Variable instance with id=%d not found", id));
        }
        if (instance.getType() != VariableInstanceType.PLC) {
            return new OperationResult(ResultType.ExpectedError, String.format("Variable instance %s is not of PLC type", instance));
        }
        return OperationResult.SUCCESS;
    }

    private static OperationResult checkMeasuredValue(long maxEndTs, MeasuredValue prevMV, IVarValue val) {
        if (!(val instanceof MeasuredValue)) {
            return new OperationResult(ResultType.ExpectedError, String.format("Values %s is not of MeasuredValue type", val));
        }
        MeasuredValue mv = (MeasuredValue)val;
        if (mv.getEndTimestamp() - mv.getStartTimestamp() <= 0L) {
            return new OperationResult(ResultType.ExpectedError, String.format("Value %s timespan check error", mv));
        }
        if (mv.getEndTimestamp() > maxEndTs) {
            return new OperationResult(ResultType.ExpectedError, String.format("Value %s to far in future", mv));
        }
        if (mv.getStartTimestamp() < TS_1990) {
            return new OperationResult(ResultType.ExpectedError, String.format("Value %s is before 1990", mv));
        }
        if (prevMV != null && prevMV.getEndTimestamp() > mv.getStartTimestamp()) {
            return new OperationResult(ResultType.ExpectedError, String.format("Timesequence error at %s - %s", prevMV, mv));
        }
        return OperationResult.SUCCESS;
    }
}

