/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.model;

import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.http.rest.auth.AuthenticatedRestService;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import org.eclipse.fx.core.log.Logger;

public abstract class AbstractRestService<T extends Comparable<Object>>
extends AuthenticatedRestService {
    private static Logger logger = Activator.getLoggerFactory().createLogger(AbstractRestService.class.getName());
    protected static final String ACCESS_FORBIDDEN_ERROR_TEXT = "Current user have not enough rights to perform this operation";
    private static final Comparator<Object> COMPATATOR = (o1, o2) -> {
        if (o1 instanceof Comparable && o2 instanceof Comparable) {
            return ((Comparable)o1).compareTo(o2);
        }
        if (o1 instanceof Comparable) {
            return -1;
        }
        if (o2 instanceof Comparable) {
            return 1;
        }
        return o1.toString().compareTo(o2.toString());
    };
    protected final Class<T> clazz;
    protected final T[] emptyArray;

    public AbstractRestService(Class<T> clazz, T[] emptyArray) {
        this.clazz = clazz;
        this.emptyArray = emptyArray;
    }

    protected T getGeneric(int trx, Serializable id) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            return (T)((Comparable)em.find(this.clazz, (Object)id));
        }
        catch (Exception exc) {
            logger.error(String.format("Error at 'get %s'", this.clazz.getSimpleName()), (Throwable)exc);
            return null;
        }
    }

    protected T[] getAllGeneric(int trx) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            LinkedList values = new LinkedList();
            CriteriaBuilder cb = em.getCriteriaBuilder();
            CriteriaQuery query = cb.createQuery(this.clazz);
            query.from(this.clazz);
            values.addAll(em.createQuery(query).getResultList());
            Comparable[] array = (Comparable[])values.toArray(this.emptyArray);
            Arrays.sort(array, COMPATATOR);
            return array;
        }
        catch (Exception exc) {
            logger.error(String.format("Error at 'get all %s'", this.clazz.getSimpleName()), (Throwable)exc);
            return null;
        }
    }

    protected OperationResult saveOrUpdateGeneric(int trx, T object) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            Serializable id = this.getId(object);
            if (id == object) {
                throw new IllegalArgumentException("Id cannot be equal object. You must return copy of serialized object, not an object itself!");
            }
            if (id == null) {
                em.persist(object);
            } else if (!(id instanceof Integer) && em.find(this.clazz, (Object)id) == null) {
                em.persist(object);
            } else {
                object = (Comparable)em.merge(object);
            }
            Serializable newId = this.getId(object);
            if (newId == null) {
                return OperationResult.SUCCESS;
            }
            return new OperationResult(newId, ResultType.Success);
        }
        catch (Exception exc) {
            Serializable id = this.getId(object);
            if (id == null) {
                return new OperationResult(ResultType.UnexprectedDbError, String.format("Cannot save %s object", this.clazz.getSimpleName()), exc.toString());
            }
            return new OperationResult(id, ResultType.UnexprectedDbError, String.format("Cannot save %s object with id=%s", this.clazz.getSimpleName(), id.toString()), exc.toString());
        }
    }

    protected OperationResult deleteGeneric(int trx, Serializable id) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            Comparable persistedObject = (Comparable)em.find(this.clazz, (Object)id);
            em.remove((Object)persistedObject);
            if (id == null) {
                return OperationResult.SUCCESS;
            }
            return new OperationResult(id, ResultType.Success);
        }
        catch (Exception exc) {
            if (id == null) {
                return new OperationResult(ResultType.UnexprectedDbError, String.format("Cannot delete %s object", this.clazz.getSimpleName()), exc.toString());
            }
            return new OperationResult(id, ResultType.UnexprectedDbError, String.format("Cannot delete %s object with id=%s", this.clazz.getSimpleName(), id.toString()), exc.toString());
        }
    }

    protected abstract Serializable getId(T var1);
}

