/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.notes;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.notes.Note;
import de.elpro.ewms.core.notes.NoteType;
import de.elpro.ewms.core.rawvalues.RawValuesViewType;
import de.elpro.ewms.core.structure.SearchPolicy;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.time.TimeRange;
import de.elpro.ewms.server.Server;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import de.elpro.ewms.server.http.rest.model.AbstractRestService;
import de.elpro.ewms.server.rasterizedvalues.RasterizedValues;
import java.io.Serializable;
import java.time.Instant;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="notes/note")
public class NoteRestService
extends AbstractRestService<Note> {
    private static Logger logger = Activator.getLoggerFactory().createLogger(NoteRestService.class.getName());

    public NoteRestService() {
        super(Note.class, (Comparable[])new Note[0]);
    }

    @GET
    @Path(value="/get/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public Note get(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        return (Note)this.getGeneric(trx, Integer.valueOf(id));
    }

    @GET
    @Path(value="/find_by_object/trx={trx}&view_type={view_type}&view_index={view_index: [^/]*}&object_id={object_id}&from_ts={from_ts: [^/]*}&to_ts={to_ts: [^/]*}&search_policy={search_policy}&filter={filter: [^/]*}")
    @Produces(value={"application/json"})
    public Note[] findByObject(@PathParam(value="trx") int trx, @PathParam(value="view_type") RawValuesViewType viewType, @PathParam(value="view_index") Integer viewIndex, @PathParam(value="object_id") int structureObjectId, @PathParam(value="from_ts") Long fromTs, @PathParam(value="to_ts") Long toTs, @PathParam(value="search_policy") String searchPolicyName, @PathParam(value="filter") String filterName) {
        try {
            Set allChildren;
            NoteType filter;
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            SearchPolicy searchPolicy = searchPolicyName != null && !searchPolicyName.isEmpty() ? SearchPolicy.valueOf((String)searchPolicyName) : null;
            NoteType noteType = filter = filterName != null && !filterName.isEmpty() ? NoteType.valueOf((String)filterName) : null;
            if (searchPolicy == null) {
                return new Note[0];
            }
            RasterizedValues view = Server.getRawValuesViews().getValuesView(viewType, viewIndex);
            TimeRange timeRange = view.getComputationTimeRange();
            if (fromTs == null || fromTs < timeRange.getFrom().toEpochMilli()) {
                fromTs = timeRange.getFrom().toEpochMilli();
            }
            if (toTs == null || toTs > timeRange.getTo().toEpochMilli()) {
                toTs = timeRange.getTo().toEpochMilli();
            }
            StructureObject structureObject = (StructureObject)em.find(StructureObject.class, (Object)structureObjectId);
            LinkedHashSet<StructureObject> objects = new LinkedHashSet<StructureObject>();
            if (searchPolicy.canSearchAtSameLevel()) {
                objects.add(structureObject);
            }
            if (searchPolicy.canSearchAtParentLevel()) {
                Set allParents = structureObject.getAllParents();
                allParents.remove(structureObject);
                objects.addAll(allParents);
            }
            if (searchPolicy.canSearchAtSubLevel()) {
                allChildren = structureObject.getAllChildren();
                allChildren.remove(structureObject);
                objects.addAll(allChildren);
            }
            if (searchPolicy == SearchPolicy.DirectChildren) {
                allChildren = structureObject.getChildren();
                objects.addAll(allChildren);
            }
            List values = em.createQuery("SELECT o FROM Note o WHERE o.structureObject IN :objects AND o.from <= :to_ts AND ( o.to IS NULL OR o.to > :from_ts ) AND o.type >= :type", Note.class).setParameter("objects", objects).setParameter("from_ts", (Object)Instant.ofEpochMilli(fromTs)).setParameter("to_ts", (Object)Instant.ofEpochMilli(toTs)).setParameter("type", (Object)(filter != null ? filter : NoteType.Internal)).getResultList();
            Collections.sort(values, (n1, n2) -> n2.getFrom().compareTo(n1.getFrom()));
            return values.toArray((Note[])this.emptyArray);
        }
        catch (Exception exc) {
            logger.error(String.format("Error at 'find by object %s'", this.clazz.getSimpleName()), (Throwable)exc);
            return null;
        }
    }

    @POST
    @Path(value="/save_or_update/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult saveOrUpdate(@PathParam(value="trx") int trx, Note note) {
        return this.saveOrUpdateGeneric(trx, note);
    }

    @GET
    @Path(value="/delete/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public OperationResult delete(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        return this.deleteGeneric(trx, Integer.valueOf(id));
    }

    @Override
    protected Serializable getId(Note object) {
        return object.getId();
    }
}

