/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.preferences;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.preferences.Preference;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.virtualtime.VirtualZone;
import de.elpro.ewms.server.Server;
import de.elpro.ewms.server.http.rest.auth.AuthenticatedRestService;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import javax.persistence.EntityManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="preferences")
public class PreferencesRestService
extends AuthenticatedRestService {
    private static Logger logger = Activator.getLoggerFactory().createLogger(PreferencesRestService.class.getName());

    @GET
    @Path(value="/virtualzone/get")
    @Produces(value={"application/json"})
    public VirtualZone getVirtualZone() {
        try {
            return VirtualZone.INSTANCE;
        }
        catch (Exception exc) {
            logger.error("Error at 'get_instance'", (Throwable)exc);
            return null;
        }
    }

    @POST
    @Path(value="/virtualzone/set")
    @Consumes(value={"application/json"})
    public Response setVirtualZone(VirtualZone virtualZone) {
        User user = this.getUser();
        if (!user.isAdmin()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        try {
            VirtualZone.INSTANCE.setZoneOffsets(virtualZone.getZoneOffsets());
        }
        catch (Exception exc) {
            logger.error("Error at 'set_instance'", (Throwable)exc);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        try (EntityManager em = Server.getEntityManagerFactory().createEntityManager();){
            em.getTransaction().begin();
            Preference virtualZonePreference = (Preference)em.find(Preference.class, (Object)"virtual-zone");
            if (virtualZonePreference == null) {
                virtualZonePreference = new Preference("virtual-zone", virtualZone.toString());
                em.persist((Object)virtualZonePreference);
            } else {
                virtualZonePreference = new Preference("virtual-zone", virtualZone.toString());
                em.merge((Object)virtualZonePreference);
            }
            em.getTransaction().commit();
            Response response = Response.ok().build();
            return response;
        }
    }

    @GET
    @Path(value="/globalviewraster/get")
    @Produces(value={"application/json"})
    public Raster getGlobalViewRaster() {
        return Server.getConfig().getGlobalViewRaster();
    }

    @GET
    @Path(value="/realtimeviewraster/get")
    @Produces(value={"application/json"})
    public Raster getRealtimeViewRaster() {
        return Server.getConfig().getRealtimeViewRaster();
    }
}

