/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.preferences;

import com.google.common.base.Charsets;
import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.changelog.ChangeLogUtils;
import de.elpro.ewms.core.component.ComponentBase;
import de.elpro.ewms.core.component.ServerInfo;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.rawvalues.RawValuesViewType;
import de.elpro.ewms.core.server.ServerState;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.time.TimeRange;
import de.elpro.ewms.server.Server;
import de.elpro.ewms.server.db.randomaccess.RADbTransaction;
import de.elpro.ewms.server.http.rest.auth.AuthenticatedRestService;
import de.elpro.ewms.server.rasterizedvalues.RasterizedValues;
import de.elpro.ewms.server.storage.ArchiveStorages;
import de.elpro.ewms.server.storage.TimeRangeMetadata;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.time.Instant;
import javafx.application.Platform;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.commons.io.IOUtils;
import org.eclipse.fx.ui.services.restart.RestartService;

@Path(value="server")
public class ServerRestService
extends AuthenticatedRestService {
    @Secured
    @GET
    @Path(value="/get_values_view_timerange/view_type={view_type}&view_index={view_index: [^/]*}")
    @Produces(value={"application/json"})
    public TimeRange getValuesViewTimeRange(@PathParam(value="view_type") RawValuesViewType viewType, @PathParam(value="view_index") Integer viewIndex) {
        RasterizedValues view = Server.getRawValuesViews().getValuesView(viewType, viewIndex);
        view.readLock();
        try {
            RasterizedValues.ComputationBounds bounds = view.getComputationBounds();
            if (bounds != null) {
                TimeRange timeRange = new TimeRange(Instant.ofEpochMilli(bounds.getValuesStartTs()), Instant.ofEpochMilli(bounds.getValuesEndTs()));
                return timeRange;
            }
            return null;
        }
        finally {
            view.readUnlock();
        }
    }

    @Secured
    @GET
    @Path(value="/get_values_view_archive_timerange/view_type={view_type}&view_index={view_index: [^/]*}")
    @Produces(value={"application/json"})
    public TimeRange getValuesViewArchiveTimeRange(@PathParam(value="view_type") RawValuesViewType viewType, @PathParam(value="view_index") Integer viewIndex) {
        RasterizedValues view = Server.getRawValuesViews().getValuesView(viewType, viewIndex);
        view.readLock();
        try {
            long to;
            RasterizedValues.ComputationBounds bounds = view.getComputationBounds();
            if (bounds == null) {
                return null;
            }
            Long plcNow = view.getPlcNow();
            long from = bounds.getValuesStartTs();
            long l = to = plcNow != null ? Math.min(plcNow, bounds.getValuesEndTs()) : bounds.getValuesEndTs();
            if (to < from) {
                return null;
            }
            TimeRange timeRange = new TimeRange(Instant.ofEpochMilli(from), Instant.ofEpochMilli(to));
            return timeRange;
        }
        finally {
            view.readUnlock();
        }
    }

    @Secured
    @GET
    @Path(value="/set_globalview_core_data_start/ts={new_start}")
    @Produces(value={"application/json"})
    public OperationResult setGlobalViewCoreDataStart(@PathParam(value="new_start") long newStart) {
        if (!this.getUser().isAdmin()) {
            return OperationResult.ACCESS_DENIED;
        }
        Server.getRawValuesViews().getGlobalView().writeLock();
        RADbTransaction trx = ArchiveStorages.getGlobalViewInstance().beginTransaction();
        try {
            long to = ((TimeRangeMetadata)trx.getMetadata()).getTimeRangeEnd();
            if (newStart > to - Server.getRawValuesViews().getGlobalView().getRaster().toMilli()) {
                OperationResult operationResult = new OperationResult(ResultType.UnexprectedError, "New Core Data Start cannot be to close or after Core Data End");
                return operationResult;
            }
            ((TimeRangeMetadata)trx.getMetadata()).setTimeRangeBegin(Server.getRawValuesViews().getGlobalView().getRaster().getRasterBegin(newStart));
            ArchiveStorages.getGlobalViewInstance().commitTransaction(trx);
            OperationResult operationResult = OperationResult.SUCCESS;
            return operationResult;
        }
        catch (Exception exc) {
            ArchiveStorages.getGlobalViewInstance().abortTransaction(trx);
            OperationResult operationResult = new OperationResult(ResultType.UnexprectedDbError, exc.getMessage());
            return operationResult;
        }
        finally {
            Server.getRawValuesViews().getGlobalView().writeUnlock();
        }
    }

    @Secured
    @GET
    @Path(value="/get_raw_values_view_raster/view_type={view_type}&view_index={view_index: [^/]*}")
    @Produces(value={"application/json"})
    public Raster getRawValuesViewRaster(@PathParam(value="view_type") RawValuesViewType viewType, @PathParam(value="view_index") Integer viewIndex) {
        return Server.getRawValuesViews().getValuesView(viewType, viewIndex).getRaster();
    }

    @Secured
    @GET
    @Path(value="/restart_server")
    @Produces(value={"application/json"})
    public OperationResult restartServer() {
        if (!this.getUser().isAdmin()) {
            return OperationResult.ACCESS_DENIED;
        }
        try {
            RestartService s = Server.getRestartService();
            new Thread(() -> {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                try {
                    Platform.runLater(() -> s.restart(false));
                }
                catch (IllegalStateException illegalStateException) {
                    s.restart(false);
                }
            }).start();
            return OperationResult.SUCCESS;
        }
        catch (Exception exc) {
            return new OperationResult(ResultType.UnexprectedDbError, exc.getMessage());
        }
    }

    @Secured
    @GET
    @Path(value="/shutdown_server")
    @Produces(value={"application/json"})
    public OperationResult shutdownServer() {
        if (!this.getUser().isAdmin()) {
            return OperationResult.ACCESS_DENIED;
        }
        try {
            RestartService s = Server.getRestartService();
            new Thread(() -> {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                try {
                    Platform.runLater(() -> s.shutdown());
                }
                catch (IllegalStateException illegalStateException) {
                    s.shutdown();
                }
            }).start();
            return OperationResult.SUCCESS;
        }
        catch (Exception exc) {
            return new OperationResult(ResultType.UnexprectedDbError, exc.getMessage());
        }
    }

    @GET
    @Path(value="/server_state")
    @Produces(value={"application/json"})
    public ServerState getServerState() {
        try {
            return Server.getServerState();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @GET
    @Path(value="/info")
    @Produces(value={"application/json"})
    public ServerInfo getServerInfo() {
        try {
            return Server.getInfo();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @GET
    @Path(value="/get_eos_core_changelog")
    @Produces(value={"application/json"})
    public String getEOSCoreChangeLog() {
        URL changelogURL = ChangeLogUtils.getCoreChangeLogURL();
        if (changelogURL == null) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (InputStream is = changelogURL.openStream();){
                return IOUtils.toString((Reader)new InputStreamReader(is, Charsets.UTF_8));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            return null;
        }
    }

    @GET
    @Path(value="/get_component_changelog/component_id={id}")
    @Produces(value={"application/json"})
    public String getComponentChangeLog(@PathParam(value="id") String componentId) {
        ComponentBase component = Server.getInfo().getComponent(componentId);
        if (component == null) {
            return null;
        }
        URL changelogURL = component.getChangeLogUrl();
        if (changelogURL == null) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (InputStream is = changelogURL.openStream();){
                return IOUtils.toString((Reader)new InputStreamReader(is, Charsets.UTF_8));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            return null;
        }
    }
}

