/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.preferences;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.preferences.UserContentViewPreference;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.http.rest.model.AbstractRestService;
import java.io.Serializable;
import javax.persistence.EntityManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Secured
@Path(value="preferences/user_content_view_prefs")
public class UserContentViewPreferenceRestService
extends AbstractRestService<UserContentViewPreference> {
    public UserContentViewPreferenceRestService() {
        super(UserContentViewPreference.class, (Comparable[])new UserContentViewPreference[0]);
    }

    @GET
    @Path(value="/get/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public UserContentViewPreference get(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        return (UserContentViewPreference)this.getGeneric(trx, Integer.valueOf(id));
    }

    @GET
    @Path(value="/get/trx={trx}&content_view_key={cvk}&structure_object_id={s_id}")
    @Produces(value={"application/json"})
    public UserContentViewPreference get(@PathParam(value="trx") int trx, @PathParam(value="cvk") String contentViewKey, @PathParam(value="s_id") Integer structureObjectId) {
        User user = this.getUser();
        StructureObject structureObject = structureObjectId != null ? new StructureObject(structureObjectId.intValue()) : new StructureObject();
        EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)user);
        return (UserContentViewPreference)em.createQuery("SELECT o FROM UserContentViewPreference o WHERE o.contentViewKey = :view_key AND o.structureObject = :object AND o.user = :user", UserContentViewPreference.class).setParameter("view_key", (Object)contentViewKey).setParameter("object", (Object)structureObject).setParameter("user", (Object)user).getSingleResultOrNull();
    }

    @POST
    @Path(value="/save_or_update/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult saveOrUpdate(@PathParam(value="trx") int trx, UserContentViewPreference object) {
        if (object.getUser() == null) {
            object.setUser(this.getUser());
        }
        if (!this.getUser().equals((Object)object.getUser())) {
            return OperationResult.ACCESS_DENIED;
        }
        return this.saveOrUpdateGeneric(trx, object);
    }

    @GET
    @Path(value="/delete/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public OperationResult delete(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        return this.deleteGeneric(trx, Integer.valueOf(id));
    }

    @Override
    protected Serializable getId(UserContentViewPreference object) {
        return object.getId();
    }
}

