/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.rawvalues;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.rawvalues.GetRawValuesRequest;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.value.IVarValuesCollection;
import de.elpro.ewms.core.variable.value.MeasuredValue;
import de.elpro.ewms.core.variable.value.VarInstanceMeasuredValuesMap;
import de.elpro.ewms.core.variable.value.VarInstanceValuesCollectionMap;
import de.elpro.ewms.server.http.rest.auth.AuthenticatedRestService;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import de.elpro.ewms.server.http.rest.rawvalues.RawValuesViewRestService;
import de.elpro.ewms.server.storage.MeasurementsStorage;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="rawvalues/db")
public class RawValuesDBRestService
extends AuthenticatedRestService {
    private final Logger logger = Activator.getLoggerFactory().createLogger(RawValuesViewRestService.class.getName());

    @POST
    @Path(value="/varvalues/get")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public VarInstanceValuesCollectionMap getRawVarValues(GetRawValuesRequest request) {
        try {
            Long fromTs = request.getFrom() != null ? Long.valueOf(request.getFrom().toEpochMilli()) : null;
            Long toTs = request.getTo() != null ? Long.valueOf(request.getTo().toEpochMilli()) : null;
            Map values = MeasurementsStorage.getInstance().readMeasurements(fromTs, toTs, new LinkedHashSet(request.getInstances()));
            VarInstanceValuesCollectionMap result = new VarInstanceValuesCollectionMap();
            for (Map.Entry entry : values.entrySet()) {
                result.put((VariableInstance)entry.getKey(), (IVarValuesCollection)entry.getValue());
            }
            return result;
        }
        catch (Exception e) {
            this.logger.error("Error reading raw measurmenets", (Throwable)e);
            return null;
        }
    }

    @POST
    @Path(value="/measured_values/get")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public VarInstanceMeasuredValuesMap getRawMeasuredValues(GetRawValuesRequest request) {
        try {
            Long fromTs = request.getFrom() != null ? Long.valueOf(request.getFrom().toEpochMilli()) : null;
            Long toTs = request.getTo() != null ? Long.valueOf(request.getTo().toEpochMilli()) : null;
            Map values = MeasurementsStorage.getInstance().readMeasurements(fromTs, toTs, new LinkedHashSet(request.getInstances()));
            VarInstanceMeasuredValuesMap result = new VarInstanceMeasuredValuesMap();
            for (Map.Entry entry : values.entrySet()) {
                VariableInstance instance = (VariableInstance)entry.getKey();
                IVarValuesCollection varValues = (IVarValuesCollection)entry.getValue();
                MeasuredValue[] measuredValues = (MeasuredValue[])varValues.toArray(MeasuredValue[]::new);
                result.put(instance, measuredValues);
            }
            return result;
        }
        catch (Exception e) {
            this.logger.error("Error reading raw measurmenets", (Throwable)e);
            return null;
        }
    }
}

