/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.rawvalues;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.rawvalues.RawValuesViewFutureTimeRange;
import de.elpro.ewms.core.rawvalues.RawValuesViewType;
import de.elpro.ewms.core.time.IFutureTimeRange;
import de.elpro.ewms.server.Server;
import de.elpro.ewms.server.http.rest.auth.AuthenticatedRestService;
import de.elpro.ewms.server.rasterizedvalues.RasterizedValues;
import javax.persistence.EntityManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Secured
@Path(value="rawvalues/future_time_range")
public class RawValuesViewFutureTimeRangeRestService
extends AuthenticatedRestService {
    @GET
    @Path(value="/get/view_type={view_type}")
    @Produces(value={"application/json"})
    public RawValuesViewFutureTimeRange get(@PathParam(value="view_type") RawValuesViewType type) {
        RasterizedValues rasterizedValues = Server.getRawValuesViews().getValuesView(type, null);
        if (rasterizedValues == null) {
            return null;
        }
        IFutureTimeRange future = rasterizedValues.getFutureTimeRange();
        if (!(future instanceof RawValuesViewFutureTimeRange)) {
            return null;
        }
        return (RawValuesViewFutureTimeRange)future;
    }

    @POST
    @Path(value="/set/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult setViewFutureTimeRange(RawValuesViewFutureTimeRange future) {
        RasterizedValues rasterizedValues = Server.getRawValuesViews().getValuesView(future.getViewType(), null);
        if (rasterizedValues == null) {
            return new OperationResult(ResultType.ExpectedError, "RasterizedView do not support Future values");
        }
        rasterizedValues.setFutureTimeRange((IFutureTimeRange)future);
        try (EntityManager em = Server.getEntityManagerFactory().createEntityManager();){
            em.getTransaction().begin();
            if (em.find(RawValuesViewFutureTimeRange.class, (Object)future.getViewType()) != null) {
                em.merge((Object)future);
            } else {
                em.persist((Object)future);
            }
            em.getTransaction().commit();
            OperationResult operationResult = OperationResult.SUCCESS;
            return operationResult;
        }
    }
}

