/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.rawvalues;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.rawvalues.RawValuesViewCreateRequest;
import de.elpro.ewms.core.rawvalues.RawValuesViewDescriptor;
import de.elpro.ewms.core.rawvalues.RawValuesViewPrepareCreateResponse;
import de.elpro.ewms.core.rawvalues.RawValuesViewPrepareCreateResponseType;
import de.elpro.ewms.core.rawvalues.RawValuesViewState;
import de.elpro.ewms.core.rawvalues.RawValuesViewStateResponse;
import de.elpro.ewms.core.rawvalues.RawValuesViewType;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.units.Aggregation;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.value.ArchiveValue;
import de.elpro.ewms.core.variable.value.IStoredVarValue;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.IVarValuesCollection;
import de.elpro.ewms.core.variable.value.MeasuredValue;
import de.elpro.ewms.server.Server;
import de.elpro.ewms.server.cache.ORMCache;
import de.elpro.ewms.server.db.randomaccess.RADbTransaction;
import de.elpro.ewms.server.http.rest.auth.AuthenticatedRestService;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import de.elpro.ewms.server.rasterizedvalues.RasterizedValues;
import de.elpro.ewms.server.rasterizedvalues.RasterizedValuesState;
import de.elpro.ewms.server.rasterizedvalues.StoredValuesConverter;
import de.elpro.ewms.server.storage.ArchiveStorage;
import de.elpro.ewms.server.storage.MeasurementsStorage;
import de.elpro.ewms.server.storage.RawValuesCustomViewStorages;
import de.elpro.ewms.server.storage.TimeRangeMetadata;
import de.elpro.ui.concurrent.CallableTask;
import de.elpro.ui.fx.utils.TaskUtils;
import de.elpro.ui.text.LocaleText;
import java.io.IOException;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javafx.concurrent.Worker;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="rawvalues/view")
public class RawValuesViewRestService
extends AuthenticatedRestService {
    private final Logger logger = Activator.getLoggerFactory().createLogger(RawValuesViewRestService.class.getName());
    private static final Map<Integer, Double> extractStorageProgress = new ConcurrentHashMap<Integer, Double>();

    @POST
    @Path(value="/prepare")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public RawValuesViewPrepareCreateResponse prepare(RawValuesViewCreateRequest request) {
        long globalViewArchValues;
        long globalViewTotalValues;
        Raster raster = request.getRaster();
        long millis = raster.getRasterEnd(request.getTo().toEpochMilli()) - raster.getRasterBegin(request.getFrom().toEpochMilli());
        if (millis <= 0L) {
            return new RawValuesViewPrepareCreateResponse(RawValuesViewPrepareCreateResponseType.Error, 0L, 0L);
        }
        long values = millis / raster.toMilli();
        RasterizedValues globalView = Server.getRawValuesViews().getGlobalView();
        globalView.readLock();
        try {
            TimeRangeMetadata globalViewMetadata = globalView.getArchiveStorage().getCachedMetadata();
            globalViewTotalValues = (globalView.getComputationBounds().getValuesEndTs() - globalView.getComputationBounds().getValuesStartTs()) / globalView.getRaster().toMilli();
            globalViewArchValues = (globalViewMetadata.getTimeRangeEnd() - globalViewMetadata.getTimeRangeBegin()) / globalView.getRaster().toMilli();
        }
        finally {
            globalView.readUnlock();
        }
        RawValuesViewDescriptor globalViewDescriptor = globalView.getDescriptor();
        long expectedRamSize = (long)((double)globalViewDescriptor.getRamSize() / (double)globalViewTotalValues * (double)values);
        long expectedHddSize = (long)((double)globalViewDescriptor.getHddSize() / (double)globalViewArchValues * (double)values);
        Runtime.getRuntime().gc();
        if ((double)expectedRamSize > 2.88E10) {
            return new RawValuesViewPrepareCreateResponse(RawValuesViewPrepareCreateResponseType.Reject, expectedRamSize, expectedHddSize);
        }
        if (expectedRamSize > 1000000000L) {
            return new RawValuesViewPrepareCreateResponse(RawValuesViewPrepareCreateResponseType.Warning, expectedRamSize, expectedHddSize);
        }
        return new RawValuesViewPrepareCreateResponse(RawValuesViewPrepareCreateResponseType.Ok, expectedRamSize, expectedHddSize);
    }

    @POST
    @Path(value="/create")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult create(RawValuesViewCreateRequest request) {
        int index;
        RawValuesViewPrepareCreateResponse prepare = this.prepare(request);
        if (prepare.getType() != RawValuesViewPrepareCreateResponseType.Ok && prepare.getType() != RawValuesViewPrepareCreateResponseType.Warning) {
            return new OperationResult(ResultType.UnexprectedError, "");
        }
        try {
            index = RawValuesCustomViewStorages.createNew((LocaleText)request.getName(), (Raster)request.getRaster());
        }
        catch (IOException e) {
            return new OperationResult(ResultType.UnexprectedError, e.getMessage());
        }
        final Raster raster = request.getRaster();
        final long from = raster.getRasterBegin(request.getFrom().toEpochMilli());
        final long to = raster.getRasterEnd(request.getTo().toEpochMilli());
        final ArchiveStorage storage = RawValuesCustomViewStorages.getStorage((int)index);
        extractStorageProgress.put(index, 0.0);
        CallableTask<Void> task = new CallableTask<Void>(request){
            {
                this.updateTitle(String.format("Extract RAW Values to Random Access Database with %s Raster", rawValuesViewCreateRequest.getRaster().name()));
            }

            public Void call() throws Exception {
                try {
                    this.updateProgress(0.0, 1.0);
                    if (!storage.open()) {
                        String errMsg = String.format("Cannot open database at %s", storage.getDbPath());
                        RawValuesViewRestService.this.logger.error(errMsg);
                        throw new Exception(errMsg);
                    }
                    this.updateMessage("Extracting RAW Values to Random Access Database");
                    MeasurementsStorage.getInstance().readMeasurements(from, to, (progress, values) -> {
                        long maxClusterValuesTo = Long.MIN_VALUE;
                        RADbTransaction trx = storage.beginTransaction();
                        try {
                            for (Map.Entry entry : values.entrySet()) {
                                VariableInstance instance = ORMCache.getVariableInstance((int)((VariableInstance)entry.getKey()).getId());
                                List<MeasuredValue> instanceValues = Arrays.asList((MeasuredValue[])((IVarValuesCollection)entry.getValue()).toArray(MeasuredValue[]::new));
                                if (instance == null || instanceValues.isEmpty()) continue;
                                long clusterValuesFrom = raster.getRasterBegin(instanceValues.get(0).getStartTimestamp());
                                long clusterValuesTo = raster.getRasterEnd(instanceValues.get(instanceValues.size() - 1).getEndTimestamp());
                                maxClusterValuesTo = Math.max(clusterValuesTo, maxClusterValuesTo);
                                IVarValue[] aggregatedValues = StoredValuesConverter.convertStoredNoParameterValues(instanceValues, (long)clusterValuesFrom, (long)clusterValuesTo, (Raster)raster, (Aggregation)instance.getResultPlcRawValueAggregation(), (boolean)false);
                                ArrayList<ArchiveValue> archValues = new ArrayList<ArchiveValue>(aggregatedValues.length);
                                IVarValue[] iVarValueArray = aggregatedValues;
                                int n2 = aggregatedValues.length;
                                int n3 = 0;
                                while (n3 < n2) {
                                    IVarValue val = iVarValueArray[n3];
                                    if (val instanceof IStoredVarValue) {
                                        IStoredVarValue mv = (IStoredVarValue)val;
                                        archValues.add(new ArchiveValue(mv.getStartTimestamp(), mv.getEndTimestamp(), mv.getValue(), mv.getQuality()));
                                    } else if (val.isValid()) {
                                        long startTimestamp = raster.getRasterBegin(val.getEndTimestamp());
                                        if (startTimestamp == val.getEndTimestamp()) {
                                            startTimestamp -= raster.toMilli();
                                        }
                                        archValues.add(new ArchiveValue(startTimestamp, val.getEndTimestamp(), val.getValue(), val.getQuality()));
                                    }
                                    ++n3;
                                }
                                long prevEnd = 0L;
                                for (ArchiveValue val : archValues) {
                                    if (val.getStartTimestamp() < clusterValuesFrom || val.getEndTimestamp() > clusterValuesTo) {
                                        throw new IllegalArgumentException();
                                    }
                                    if (prevEnd > 0L && prevEnd > val.getStartTimestamp()) {
                                        throw new IllegalArgumentException();
                                    }
                                    prevEnd = val.getEndTimestamp();
                                }
                                storage.saveValues(trx, (Object)instance, archValues);
                            }
                            ((TimeRangeMetadata)trx.getMetadata()).setTimeRangeBegin(raster.getRasterBegin(from));
                            ((TimeRangeMetadata)trx.getMetadata()).setTimeRangeEnd(raster.getRasterEnd(to));
                            storage.commitTransaction(trx);
                        }
                        catch (Exception exc) {
                            storage.abortTransaction(trx);
                            RawValuesViewRestService.this.logger.error("Error creating new raw values view", (Throwable)exc);
                        }
                        extractStorageProgress.put(index, progress);
                        this.updateProgress(progress * 0.5, 1.0);
                    });
                    extractStorageProgress.put(index, 1.0);
                    this.updateProgress(0.5, 1.0);
                    this.updateMessage("Compress DB");
                    storage.compressDb();
                    storage.close();
                    this.updateProgress(0.6, 1.0);
                    extractStorageProgress.put(index, 1.0);
                    this.updateMessage("Initialize RawValuesView as Rasterized Values");
                    Server.getRawValuesViews().createCustomView(index, raster, storage);
                    extractStorageProgress.remove(index);
                    RasterizedValues valuesView = Server.getRawValuesViews().getValuesView(RawValuesViewType.CustomView, Integer.valueOf(index));
                    valuesView.init();
                    valuesView.getComputationWorker().startAsync();
                    while (valuesView.getState().compareTo((Enum)RasterizedValuesState.Idle) < 0) {
                        this.updateProgress(0.6 + 0.4 * valuesView.getStateProgress(), 1.0);
                        Thread.sleep(100L);
                    }
                    this.updateProgress(1.0, 1.0);
                    this.updateMessage("Done.");
                    return null;
                }
                finally {
                    extractStorageProgress.remove(index);
                }
            }
        };
        TaskUtils.executeUITask((CallableTask)task).consumeResult((arg_0, arg_1) -> RawValuesViewRestService.lambda$0((CallableTask)task, arg_0, arg_1));
        return new OperationResult((Serializable)Integer.valueOf(index), ResultType.Success, "Raw-Values View Created Successfully");
    }

    @GET
    @Path(value="/get_state/view_type={view_type}&view_index={view_index: [^/]*}")
    @Produces(value={"application/json"})
    public RawValuesViewStateResponse getViewState(@PathParam(value="view_type") RawValuesViewType type, @PathParam(value="view_index") Integer index) {
        Double storageProgress;
        if (type == RawValuesViewType.CustomView && (storageProgress = extractStorageProgress.get(index)) != null) {
            if (storageProgress < 1.0) {
                return new RawValuesViewStateResponse(RawValuesViewState.ExtractingDatabase, storageProgress * 0.5);
            }
            return new RawValuesViewStateResponse(RawValuesViewState.CompressDatabase, 0.5);
        }
        RasterizedValues valuesView = Server.getRawValuesViews().getValuesView(type, index);
        if (valuesView == null) {
            return null;
        }
        RasterizedValuesState rvState = valuesView.getState();
        double rvProgress = valuesView.getStateProgress();
        switch (rvState) {
            case New: {
                return new RawValuesViewStateResponse(RawValuesViewState.Initialization, 0.6);
            }
            case Initialization: {
                return new RawValuesViewStateResponse(RawValuesViewState.Initialization, 0.6 + rvProgress * 0.4);
            }
            case Idle: {
                return new RawValuesViewStateResponse(RawValuesViewState.Idle, 1.0);
            }
            case InProgress: {
                return new RawValuesViewStateResponse(RawValuesViewState.UpdateView, rvProgress);
            }
        }
        return null;
    }

    @GET
    @Path(value="/get/view_type={view_type}&view_index={view_index: [^/]*}")
    @Produces(value={"application/json"})
    public RawValuesViewDescriptor getView(@PathParam(value="view_type") RawValuesViewType type, @PathParam(value="view_index") Integer index) {
        RasterizedValues valuesView = Server.getRawValuesViews().getValuesView(type, index);
        if (valuesView == null) {
            return null;
        }
        return valuesView.getDescriptor();
    }

    @GET
    @Path(value="/remove/custom_view_index={view_index: [^/]*}")
    @Produces(value={"application/json"})
    public OperationResult removeView(@PathParam(value="view_index") Integer index) {
        RasterizedValues valuesView = Server.getRawValuesViews().getValuesView(RawValuesViewType.CustomView, index);
        if (valuesView == null) {
            return new OperationResult(ResultType.UnexprectedError, "View not found");
        }
        try {
            valuesView.shutdown();
            valuesView.getComputationWorker().terminate();
            Server.getRawValuesViews().removeCustomView(index.intValue());
            RawValuesCustomViewStorages.delete((int)index);
            return OperationResult.SUCCESS;
        }
        catch (Exception exc) {
            this.logger.error("Error deleting Custom View " + index, (Throwable)exc);
            return new OperationResult(ResultType.UnexprectedError, exc.getMessage());
        }
    }

    @GET
    @Path(value="/get/view_type={view_type}")
    @Produces(value={"application/json"})
    public RawValuesViewDescriptor[] getViews(@PathParam(value="view_type") RawValuesViewType type) {
        return (RawValuesViewDescriptor[])Server.getRawValuesViews().getValuesViews(type).stream().map(rv -> rv.getDescriptor()).toArray(RawValuesViewDescriptor[]::new);
    }

    @GET
    @Path(value="/synchronize_archives_with_raw_db/from={from}&to={to}")
    public OperationResult synchronizeArchivesWithRAWDB(@PathParam(value="from") long fromTs, @PathParam(value="to") long toTs) {
        if (!this.getUser().isAdmin()) {
            return OperationResult.ACCESS_DENIED;
        }
        try {
            Instant from = Instant.ofEpochMilli(fromTs);
            Instant to = Instant.ofEpochMilli(toTs);
            Server.getGlobalValuesWriter().synchronizeWithRAWDB(from, to);
            Server.getRealtimeValuesWriter().synchronizeWithRAWDB(from, to);
            return OperationResult.SUCCESS;
        }
        catch (Exception exc) {
            this.logger.error("Error synchronizing archives with RAW DB", (Throwable)exc);
            return new OperationResult(ResultType.UnexprectedError, exc.getMessage());
        }
    }

    private static /* synthetic */ void lambda$0(CallableTask callableTask, Worker.State r, Void s) {
        TaskUtils.removeTaskFromView((CallableTask)callableTask);
    }
}

