/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.report;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.report.ReportProfile;
import de.elpro.ewms.core.report.TableReport;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import de.elpro.ewms.server.http.rest.model.AbstractRestService;
import de.elpro.ewms.server.http.rest.report.TableReportRestService;
import java.io.Serializable;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="report/profile")
public class ReportProfileRestService
extends AbstractRestService<ReportProfile> {
    private static Logger logger = Activator.getLoggerFactory().createLogger(ReportProfileRestService.class.getName());

    public ReportProfileRestService() {
        super(ReportProfile.class, (Comparable[])new ReportProfile[0]);
    }

    @GET
    @Path(value="/get/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public ReportProfile get(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        return (ReportProfile)this.getGeneric(trx, Integer.valueOf(id));
    }

    @GET
    @Path(value="/get_all/trx={trx}")
    @Produces(value={"application/json"})
    public ReportProfile[] getAll(@PathParam(value="trx") int trx) {
        return (ReportProfile[])this.getAllGeneric(trx);
    }

    @POST
    @Path(value="/save_or_update/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult saveOrUpdate(@PathParam(value="trx") int trx, ReportProfile profile) {
        OperationResult result = this.saveOrUpdateGeneric(trx, profile);
        if (result.getType() == ResultType.Success) {
            try {
                ReportProfile reportProfile = (ReportProfile)this.getGeneric(trx, result.getObjectId());
                for (TableReport tableReport : reportProfile.getTableReports()) {
                    TableReportRestService.updateConfigs(EntityManagerPool.getEntityManager((int)trx, (User)this.getUser()), tableReport);
                }
                return result;
            }
            catch (Exception exc) {
                logger.error("Error updating configs", (Throwable)exc);
                return new OperationResult(ResultType.UnexprectedDbError, "Error updating configs");
            }
        }
        return result;
    }

    @GET
    @Path(value="/delete/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public OperationResult delete(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        return this.deleteGeneric(trx, Integer.valueOf(id));
    }

    @Override
    protected Serializable getId(ReportProfile object) {
        return object.getId();
    }
}

