/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.report;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.report.TableReport;
import de.elpro.ewms.core.report.TableReportConfig;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import de.elpro.ewms.server.http.rest.model.AbstractRestService;
import java.io.Serializable;
import java.util.List;
import javax.persistence.EntityManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="report/table_config")
public class TableReportConfigRestService
extends AbstractRestService<TableReportConfig> {
    private static Logger logger = Activator.getLoggerFactory().createLogger(TableReportConfigRestService.class.getName());

    public TableReportConfigRestService() {
        super(TableReportConfig.class, (Comparable[])new TableReportConfig[0]);
    }

    @GET
    @Path(value="/get/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public TableReportConfig get(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        return (TableReportConfig)this.getGeneric(trx, Integer.valueOf(id));
    }

    @GET
    @Path(value="/get_by_table_report/trx={trx}&table_report_id={table_report_id}")
    @Produces(value={"application/json"})
    public TableReportConfig[] getAll(@PathParam(value="trx") int trx, @PathParam(value="table_report_id") int tableReportId) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            List values = em.createQuery("SELECT o FROM TableReportConfig o WHERE o.tableReport = :table_report", TableReportConfig.class).setParameter("table_report", (Object)new TableReport(tableReportId)).getResultList();
            return values.toArray((TableReportConfig[])this.emptyArray);
        }
        catch (Exception exc) {
            logger.error(String.format("Error at %s 'get by table report'", this.clazz.getSimpleName()), (Throwable)exc);
            return null;
        }
    }

    @POST
    @Path(value="/save_or_update/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult saveOrUpdate(@PathParam(value="trx") int trx, TableReportConfig tableReportConfig) {
        return this.saveOrUpdateGeneric(trx, tableReportConfig);
    }

    @GET
    @Path(value="/delete/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public OperationResult delete(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        return this.deleteGeneric(trx, Integer.valueOf(id));
    }

    @Override
    protected Serializable getId(TableReportConfig object) {
        return object.getId();
    }
}

