/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.report;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.report.ReportProfile;
import de.elpro.ewms.core.report.TableReport;
import de.elpro.ewms.core.report.TableReportConfig;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.tables.Table;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import de.elpro.ewms.server.http.rest.model.AbstractRestService;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import javax.persistence.EntityManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="report/table")
public class TableReportRestService
extends AbstractRestService<TableReport> {
    private static Logger logger = Activator.getLoggerFactory().createLogger(TableReportRestService.class.getName());

    public TableReportRestService() {
        super(TableReport.class, (Comparable[])new TableReport[0]);
    }

    @GET
    @Path(value="/get/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public TableReport get(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        return (TableReport)this.getGeneric(trx, Integer.valueOf(id));
    }

    @GET
    @Path(value="/get_by_profile/trx={trx}&profile_id={profile_id}")
    @Produces(value={"application/json"})
    public TableReport[] getAll(@PathParam(value="trx") int trx, @PathParam(value="profile_id") int profileId) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            List values = em.createQuery("SELECT o FROM TableReport o WHERE o.profile = :profile", TableReport.class).setParameter("profile", (Object)new ReportProfile(profileId)).getResultList();
            Collections.sort(values);
            return values.toArray((TableReport[])this.emptyArray);
        }
        catch (Exception exc) {
            logger.error(String.format("Error at 'get by profile %s'", this.clazz.getSimpleName()), (Throwable)exc);
            return null;
        }
    }

    static void updateConfigs(EntityManager em, TableReport tableReport) throws Exception {
        ReportProfile profile = (ReportProfile)em.find(ReportProfile.class, (Object)tableReport.getProfile().getId());
        StructureClass structureClass = (StructureClass)em.find(StructureClass.class, (Object)profile.getStructureClass().getId());
        TreeSet<StructureObject> objects = new TreeSet<StructureObject>();
        if (profile.getStructureObject() != null) {
            objects.add((StructureObject)em.find(StructureObject.class, (Object)profile.getStructureObject().getId()));
        } else {
            objects.addAll(structureClass.getAllObjects());
        }
        Table table = (Table)em.find(Table.class, (Object)tableReport.getTable().getId());
        for (StructureObject object : objects) {
            if (!object.getStructureClass().isSubclass(table.getStructureClass()) || (Long)em.createQuery("SELECT COUNT(o) FROM TableReportConfig o WHERE o.tableReport = :table_report AND o.structureObject = :object", Long.class).setParameter("table_report", (Object)tableReport).setParameter("object", (Object)object).getSingleResult() > 0L) continue;
            TableReportConfig tableReportConfig = new TableReportConfig();
            tableReportConfig.setTableReport(tableReport);
            tableReportConfig.setStructureObject(object);
            em.persist((Object)tableReportConfig);
        }
        for (TableReportConfig config : tableReport.getConfigs()) {
            if (objects.contains(config.getStructureObject())) continue;
            em.remove((Object)config);
        }
    }

    @POST
    @Path(value="/save_or_update/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult saveOrUpdate(@PathParam(value="trx") int trx, TableReport tableReport) {
        OperationResult result = this.saveOrUpdateGeneric(trx, tableReport);
        if (result.getType() == ResultType.Success) {
            try {
                EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
                em.flush();
                TableReportRestService.updateConfigs(em, (TableReport)this.getGeneric(trx, result.getObjectId()));
                return result;
            }
            catch (Exception exc) {
                logger.error("Error updating configs", (Throwable)exc);
                return new OperationResult(ResultType.UnexprectedDbError, "Error updating configs");
            }
        }
        return result;
    }

    @GET
    @Path(value="/delete/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public OperationResult delete(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        return this.deleteGeneric(trx, Integer.valueOf(id));
    }

    @Override
    protected Serializable getId(TableReport object) {
        return object.getId();
    }
}

