/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.resources;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.resources.RDFolder;
import de.elpro.ewms.core.resources.RDItem;
import de.elpro.ewms.core.resources.ResourceDirectory;
import de.elpro.ewms.core.schedules.Schedule;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import de.elpro.ewms.server.http.rest.model.AbstractRestService;
import de.elpro.ewms.server.transactions.TransactionChangeset;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Properties;
import javax.net.ssl.TrustManager;
import javax.persistence.EntityManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPSClient;
import org.apache.commons.net.util.TrustManagerUtils;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="resources/resource_directory")
public class ResourceDirectoryRestService
extends AbstractRestService<ResourceDirectory> {
    private static Logger logger = Activator.getLoggerFactory().createLogger(ResourceDirectoryRestService.class.getName());

    public ResourceDirectoryRestService() {
        super(ResourceDirectory.class, (Comparable[])new ResourceDirectory[0]);
    }

    @GET
    @Path(value="/get/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public ResourceDirectory get(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        return (ResourceDirectory)this.getGeneric(trx, Integer.valueOf(id));
    }

    @GET
    @Path(value="/get_all/trx={trx}")
    @Produces(value={"application/json"})
    public ResourceDirectory[] getAll(@PathParam(value="trx") int trx) {
        return (ResourceDirectory[])this.getAllGeneric(trx);
    }

    @POST
    @Path(value="/save_or_update/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult saveOrUpdate(@PathParam(value="trx") int trx, ResourceDirectory rd) {
        OperationResult result = this.saveOrUpdateGeneric(trx, rd);
        if (result.getType() == ResultType.Success) {
            TransactionChangeset.changedOrNew((int)trx, (Object)rd);
        }
        return result;
    }

    @GET
    @Path(value="/delete/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public OperationResult delete(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        OperationResult result = this.deleteGeneric(trx, Integer.valueOf(id));
        if (result.getType() == ResultType.Success) {
            TransactionChangeset.removed((int)trx, (Object)new Schedule(id));
        }
        return result;
    }

    @Override
    protected Serializable getId(ResourceDirectory rd) {
        return rd.getId();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="/get_folders/trx={trx}&id={id}&path={path: .*}")
    @Produces(value={"application/json"})
    public RDFolder[] getFolders(@PathParam(value="trx") int trx, @PathParam(value="id") int rdId, @PathParam(value="path") String path) {
        EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
        try {
            ResourceDirectory rd = (ResourceDirectory)em.find(ResourceDirectory.class, (Object)rdId);
            String browsePath = rd.getBrowsePath(path);
            switch (rd.getType()) {
                case SERVER_FS: {
                    ArrayList<RDFolder> folders = new ArrayList<RDFolder>();
                    File dir = new File(browsePath);
                    File[] fileArray = dir.listFiles(file -> file.isDirectory());
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File subDir = fileArray[n2];
                        RDFolder folder = new RDFolder();
                        folder.setName(subDir.getName());
                        folder.setPath((path.isEmpty() ? subDir.getName() : String.valueOf(path) + "/" + subDir.getName()).split("/"));
                        folder.setLastModified(Instant.ofEpochMilli(subDir.lastModified()));
                        folders.add(folder);
                        ++n2;
                    }
                    return folders.toArray(new RDFolder[0]);
                }
                case FTPS: {
                    RDFolder[] rDFolderArray;
                    FTPSClient client = ResourceDirectoryRestService.getFTPClient(rd);
                    if (client == null) {
                        return null;
                    }
                    try {
                        ArrayList<RDFolder> folders = new ArrayList<RDFolder>();
                        FTPFile[] fTPFileArray = client.listDirectories(browsePath);
                        int n = fTPFileArray.length;
                        int n3 = 0;
                        while (n3 < n) {
                            FTPFile dir = fTPFileArray[n3];
                            RDFolder folder = new RDFolder();
                            folder.setName(dir.getName());
                            folder.setPath((path.isEmpty() ? dir.getName() : String.valueOf(path) + "/" + dir.getName()).split("/"));
                            folder.setLastModified(dir.getTimestamp().toInstant());
                            folders.add(folder);
                            ++n3;
                        }
                        rDFolderArray = folders.toArray(new RDFolder[0]);
                    }
                    catch (Throwable throwable) {
                        try {
                            client.disconnect();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        client.disconnect();
                    }
                    catch (IOException iOException) {}
                    return rDFolderArray;
                }
                case SFTP: {
                    ChannelSftp sftp = null;
                    try {
                        sftp = this.getSftpChannel(rd);
                        if (sftp == null) {
                            return null;
                        }
                        ArrayList<RDFolder> folders = new ArrayList<RDFolder>();
                        for (Object o : sftp.ls(browsePath)) {
                            String fileName;
                            ChannelSftp.LsEntry entry = (ChannelSftp.LsEntry)o;
                            if (!entry.getAttrs().isDir() || ".".equals(fileName = entry.getFilename()) || "..".equals(fileName)) continue;
                            RDFolder folder = new RDFolder();
                            folder.setName(fileName);
                            folder.setPath((path.isEmpty() ? fileName : String.valueOf(path) + "/" + fileName).split("/"));
                            folder.setLastModified(Instant.ofEpochSecond(entry.getAttrs().getMTime()));
                            folders.add(folder);
                        }
                        RDFolder[] rDFolderArray = folders.toArray(new RDFolder[0]);
                        return rDFolderArray;
                    }
                    finally {
                        if (sftp != null) {
                            this.closeSftpChannel(sftp);
                        }
                    }
                }
            }
            return null;
        }
        catch (Exception exc) {
            logger.error("Error browsing RDFolders", (Throwable)exc);
            return null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="/get_items/trx={trx}&id={id}&path={path: .*}")
    @Produces(value={"application/json"})
    public RDItem[] getItems(@PathParam(value="trx") int trx, @PathParam(value="id") int rdId, @PathParam(value="path") String path) {
        EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
        try {
            ResourceDirectory rd = (ResourceDirectory)em.find(ResourceDirectory.class, (Object)rdId);
            String browsePath = rd.getBrowsePath(path);
            switch (rd.getType()) {
                case SERVER_FS: {
                    ArrayList<RDItem> items = new ArrayList<RDItem>();
                    File dir = new File(browsePath);
                    File[] fileArray = dir.listFiles(file -> !file.isDirectory());
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file2 = fileArray[n2];
                        RDItem item = new RDItem();
                        item.setName(file2.getName());
                        item.setPath((path.isEmpty() ? file2.getName() : String.valueOf(path) + "/" + file2.getName()).split("/"));
                        item.setLastModified(Instant.ofEpochMilli(file2.lastModified()));
                        item.setBytes(Long.valueOf(file2.length()));
                        items.add(item);
                        ++n2;
                    }
                    return items.toArray(new RDItem[0]);
                }
                case FTPS: {
                    RDItem[] rDItemArray;
                    FTPSClient client = ResourceDirectoryRestService.getFTPClient(rd);
                    if (client == null) {
                        return null;
                    }
                    try {
                        ArrayList<RDItem> items = new ArrayList<RDItem>();
                        FTPFile[] fTPFileArray = client.listFiles(browsePath, file -> file.isFile() && !file.isDirectory());
                        int n = fTPFileArray.length;
                        int n3 = 0;
                        while (n3 < n) {
                            FTPFile file3 = fTPFileArray[n3];
                            RDItem item = new RDItem();
                            item.setName(file3.getName());
                            item.setPath((path.isEmpty() ? file3.getName() : String.valueOf(path) + "/" + file3.getName()).split("/"));
                            item.setLastModified(file3.getTimestamp().toInstant());
                            item.setBytes(Long.valueOf(file3.getSize()));
                            items.add(item);
                            ++n3;
                        }
                        rDItemArray = items.toArray(new RDItem[0]);
                    }
                    catch (Throwable throwable) {
                        try {
                            client.disconnect();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        client.disconnect();
                    }
                    catch (IOException iOException) {}
                    return rDItemArray;
                }
                case SFTP: {
                    ChannelSftp sftp = null;
                    try {
                        sftp = this.getSftpChannel(rd);
                        if (sftp == null) {
                            return null;
                        }
                        ArrayList<RDItem> items = new ArrayList<RDItem>();
                        for (Object o : sftp.ls(browsePath)) {
                            ChannelSftp.LsEntry entry = (ChannelSftp.LsEntry)o;
                            if (entry.getAttrs().isDir()) continue;
                            RDItem item = new RDItem();
                            item.setName(entry.getFilename());
                            item.setPath((path.isEmpty() ? entry.getFilename() : String.valueOf(path) + "/" + entry.getFilename()).split("/"));
                            item.setLastModified(Instant.ofEpochSecond(entry.getAttrs().getMTime()));
                            item.setBytes(Long.valueOf(entry.getAttrs().getSize()));
                            items.add(item);
                        }
                        RDItem[] rDItemArray = items.toArray(new RDItem[0]);
                        return rDItemArray;
                    }
                    finally {
                        if (sftp != null) {
                            this.closeSftpChannel(sftp);
                        }
                    }
                }
            }
            return null;
        }
        catch (Exception exc) {
            logger.error("Error browsing RDFolders", (Throwable)exc);
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    @GET
    @Path(value="/check_file_exists/trx={trx}&id={id}&file_name={file_name}&path={path: .*}")
    @Produces(value={"application/json"})
    public Boolean checkFileExists(@PathParam(value="trx") int trx, @PathParam(value="id") int rdId, @PathParam(value="file_name") String fileName, @PathParam(value="path") String path) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 25[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @POST
    @Path(value="/store_file/trx={trx}&id={id}&file_name={file_name}&path={path: .*}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult storeFile(byte[] data, @PathParam(value="trx") int trx, @PathParam(value="id") int rdId, @PathParam(value="file_name") String fileName, @PathParam(value="path") String path) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 18[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static FTPSClient getFTPClient(ResourceDirectory rd) {
        boolean loggedIn;
        boolean connected;
        String[] hostParts;
        String host;
        FTPSClient client;
        block12: {
            client = new FTPSClient("TLS", false);
            client.setTrustManager((TrustManager)TrustManagerUtils.getAcceptAllTrustManager());
            host = rd.getRemoteAddr();
            if (host == null) {
                return null;
            }
            hostParts = host.split(":");
            connected = false;
            loggedIn = false;
            if (hostParts.length == 1) {
                client.connect(hostParts[0]);
                break block12;
            }
            try {
                Integer port = Integer.parseInt(hostParts[1]);
                client.connect(hostParts[0], port.intValue());
            }
            catch (Exception exc) {
                logger.error(String.format("Cannot connect host %s", host), (Throwable)exc);
                return null;
            }
        }
        try {
            connected = true;
            String login = rd.getLogin();
            String password = rd.getPassword();
            loggedIn = client.login(login, password);
            client.execPBSZ(0L);
            client.execPROT("P");
            client.enterLocalPassiveMode();
            if (loggedIn) {
                return client;
            }
            logger.error(String.format("Login credentials for user %s and host %s are wrong", login, hostParts[0]));
        }
        catch (IOException exc) {
            logger.error(String.format("Error at host %s", host), (Throwable)exc);
        }
        if (loggedIn) {
            return client;
        }
        if (connected) {
            try {
                client.disconnect();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public ChannelSftp getSftpChannel(ResourceDirectory rd) {
        Session session = null;
        Channel channel = null;
        ChannelSftp channelSftp = null;
        String host = rd.getRemoteAddr();
        if (host == null) {
            return null;
        }
        String[] hostParts = host.split(":");
        String hostName = hostParts[0];
        Integer port = hostParts.length > 1 ? Integer.valueOf(hostParts[1]) : 22;
        try {
            JSch jsch = new JSch();
            session = jsch.getSession(rd.getLogin(), hostName, port.intValue());
            session.setPassword(rd.getPassword());
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            session.setConfig(config);
            session.connect();
            channel = session.openChannel("sftp");
            channel.connect();
            channelSftp = (ChannelSftp)channel;
            return channelSftp;
        }
        catch (Exception exception) {
            logger.error("Failed to open SFTP Channel.", (Throwable)exception);
            if (channelSftp != null) {
                channelSftp.exit();
            }
            if (channel != null) {
                channel.disconnect();
            }
            if (session != null) {
                session.disconnect();
            }
            return null;
        }
    }

    private void closeSftpChannel(ChannelSftp sftpChannel) {
        if (sftpChannel != null) {
            sftpChannel.exit();
            sftpChannel.disconnect();
            try {
                if (sftpChannel.getSession() != null) {
                    sftpChannel.getSession().disconnect();
                }
            }
            catch (JSchException jSchException) {}
        }
    }

    private static /* synthetic */ boolean lambda$3(FTPFile file) {
        return file.isFile() && !file.isDirectory();
    }
}

