/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.resources;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.LinkedList;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.eclipse.core.runtime.IPath;
import org.eclipse.fx.core.log.Logger;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;

@Secured
@Path(value="resources")
public class ResourcesRestService {
    private static Logger logger = Activator.getLoggerFactory().createLogger(ResourcesRestService.class.getName());
    private static final IPath LOCATION = Activator.getWorkspaceLocation().append("resources");

    @GET
    @Path(value="/get_image/{path: .*}")
    @Produces(value={"image/png"})
    public Response getImage(@PathParam(value="path") String path) throws URISyntaxException {
        File file = new File(LOCATION.append(path).toString());
        if (file.exists()) {
            return ResourcesRestService.returnFile(file);
        }
        throw new WebApplicationException(404);
    }

    @GET
    @Path(value="/get_svg/{path: .*}")
    @Produces(value={"application/svg+xml"})
    public Response getSvg(@PathParam(value="path") String path) throws URISyntaxException {
        try {
            File file = new File(LOCATION.append(path).toString());
            if (file.exists()) {
                return ResourcesRestService.returnFile(file);
            }
            return null;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    @GET
    @Path(value="/get_all/path={path: .*}")
    @Produces(value={"application/json"})
    public String[] getAll(@PathParam(value="path") String pathPrefix) {
        String path = String.valueOf(LOCATION.append(pathPrefix).toString()) + '/';
        LinkedList keys = new LinkedList();
        try {
            Files.walk(Paths.get(path, new String[0]), new FileVisitOption[0]).forEach(filePath -> {
                if (Files.isRegularFile(filePath, new LinkOption[0]) && !filePath.toString().contains("@2x")) {
                    keys.add(filePath.toString().replace('\\', '/').replaceAll(path, ""));
                }
            });
        }
        catch (IOException iOException) {}
        return keys.toArray(new String[0]);
    }

    @POST
    @Path(value="/upload/path={path: .*}")
    @Consumes(value={"multipart/form-data"})
    public void uploadFile(@PathParam(value="path") String pathPrefix, FormDataMultiPart fdmp) {
        OutputStream os = null;
        try {
            try {
                int length;
                File fileToUpload = new File(LOCATION.append(pathPrefix).toString());
                File directory = fileToUpload.getParentFile();
                if (!directory.exists()) {
                    directory.mkdirs();
                }
                FormDataBodyPart body = fdmp.getField("file");
                InputStream fileInputStream = (InputStream)body.getValueAs(InputStream.class);
                os = new FileOutputStream(fileToUpload);
                byte[] b = new byte[2048];
                while ((length = fileInputStream.read(b)) != -1) {
                    os.write(b, 0, length);
                }
            }
            catch (IOException ex) {
                logger.error("Error saving resource file", (Throwable)ex);
                try {
                    os.close();
                }
                catch (IOException ex2) {
                    logger.error("Error saving resource file", (Throwable)ex2);
                }
            }
        }
        finally {
            try {
                os.close();
            }
            catch (IOException ex) {
                logger.error("Error saving resource file", (Throwable)ex);
            }
        }
    }

    public static Response returnFile(File file) {
        try {
            return Response.ok((Object)new FileInputStream(file)).build();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }
}

