/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.schedules;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.schedules.JobDescriptor;
import de.elpro.ewms.core.schedules.Schedule;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import de.elpro.ewms.server.http.rest.model.AbstractRestService;
import de.elpro.ewms.server.schedules.Jobs;
import de.elpro.ewms.server.transactions.TransactionChangeset;
import java.io.Serializable;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="schedules/schedule")
public class ScheduleRestService
extends AbstractRestService<Schedule> {
    private static final Logger logger = Activator.getLoggerFactory().createLogger(ScheduleRestService.class.getCanonicalName());
    public static final ScheduleRestService INSTANCE = new ScheduleRestService();

    public ScheduleRestService() {
        super(Schedule.class, (Comparable[])new Schedule[0]);
    }

    @GET
    @Path(value="/get/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public Schedule get(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        return (Schedule)this.getGeneric(trx, Integer.valueOf(id));
    }

    @GET
    @Path(value="/get_all/trx={trx}")
    @Produces(value={"application/json"})
    public Schedule[] getAll(@PathParam(value="trx") int trx) {
        return (Schedule[])this.getAllGeneric(trx);
    }

    @GET
    @Path(value="/get_job_descriptors")
    @Produces(value={"application/json"})
    public JobDescriptor[] getJobDescriptors() {
        return Jobs.getDescriptors().toArray(new JobDescriptor[0]);
    }

    @GET
    @Path(value="/execute_sync/id={id}")
    @Produces(value={"application/json"})
    public OperationResult executeSync(@PathParam(value="id") int scheduleId) {
        if (!this.getUser().isAdmin()) {
            return new OperationResult(ResultType.AccessForbidden, "Access Forbidden");
        }
        try {
            Jobs.executeSync((int)scheduleId);
            return OperationResult.SUCCESS;
        }
        catch (Exception exc) {
            logger.error("Error executing job " + scheduleId, (Throwable)exc);
            return new OperationResult(ResultType.UnexprectedError, exc.getMessage());
        }
    }

    @POST
    @Path(value="/save_or_update/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult saveOrUpdate(@PathParam(value="trx") int trx, Schedule schedule) {
        OperationResult result = this.saveOrUpdateGeneric(trx, schedule);
        if (result.getType() == ResultType.Success) {
            TransactionChangeset.changedOrNew((int)trx, (Object)schedule);
        }
        return result;
    }

    @GET
    @Path(value="/delete/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public OperationResult delete(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        OperationResult result = this.deleteGeneric(trx, Integer.valueOf(id));
        if (result.getType() == ResultType.Success) {
            TransactionChangeset.removed((int)trx, (Object)new Schedule(id));
        }
        return result;
    }

    @Override
    protected Serializable getId(Schedule schedule) {
        return schedule.getId();
    }
}

