/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.structure;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.structure.PropertyGroup;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import de.elpro.ewms.server.http.rest.model.AbstractRestService;
import de.elpro.ewms.server.transactions.TransactionChangeset;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import javax.persistence.EntityManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="structure/propertygroup")
public class PropertyGroupRestService
extends AbstractRestService<PropertyGroup> {
    private static Logger logger = Activator.getLoggerFactory().createLogger(PropertyGroupRestService.class.getName());

    public PropertyGroupRestService() {
        super(PropertyGroup.class, (Comparable[])new PropertyGroup[0]);
    }

    @GET
    @Path(value="/get/trx={trx}&key={key}")
    @Produces(value={"application/json"})
    public PropertyGroup getStructureClass(@PathParam(value="trx") int trx, @PathParam(value="key") String key) {
        return (PropertyGroup)this.getGeneric(trx, (Serializable)((Object)key));
    }

    @GET
    @Path(value="/get_by_class/trx={trx}&class_id={class_id}")
    @Produces(value={"application/json"})
    public PropertyGroup[] getByClass(@PathParam(value="trx") int trx, @PathParam(value="class_id") int classId) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            StructureClass structureClass = (StructureClass)em.find(StructureClass.class, (Object)classId);
            LinkedList classPropertyGroups = new LinkedList(structureClass.getPropertyGroups());
            Collections.sort(classPropertyGroups);
            return classPropertyGroups.toArray((PropertyGroup[])this.emptyArray);
        }
        catch (Exception exc) {
            logger.error("Error at 'get structure class property groups'", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/get_all_by_class/trx={trx}&class_id={class_id}")
    @Produces(value={"application/json"})
    public PropertyGroup[] getAllByClass(@PathParam(value="trx") int trx, @PathParam(value="class_id") int classId) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            StructureClass structureClass = (StructureClass)em.find(StructureClass.class, (Object)classId);
            LinkedList classPropertyGroups = new LinkedList(structureClass.getAllPropertyGroups());
            Collections.sort(classPropertyGroups);
            return classPropertyGroups.toArray((PropertyGroup[])this.emptyArray);
        }
        catch (Exception exc) {
            logger.error("Error at 'get all structure class property groups'", (Throwable)exc);
            return null;
        }
    }

    @POST
    @Path(value="/save_or_update/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult saveOrUpdate(@PathParam(value="trx") int trx, PropertyGroup propertyGroup) {
        OperationResult result = this.saveOrUpdateGeneric(trx, propertyGroup);
        TransactionChangeset.changedOrNew((int)trx, (Object)result);
        return result;
    }

    @GET
    @Path(value="/delete/trx={trx}&key={key}")
    @Produces(value={"application/json"})
    public OperationResult delete(@PathParam(value="trx") int trx, @PathParam(value="key") String key) {
        OperationResult result = this.deleteGeneric(trx, (Serializable)((Object)key));
        TransactionChangeset.removed((int)trx, (Object)new PropertyGroup(null, key));
        return result;
    }

    @Override
    protected Serializable getId(PropertyGroup object) {
        return object.getKey();
    }
}

