/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.structure;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.structure.Property;
import de.elpro.ewms.core.structure.PropertyGroup;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import de.elpro.ewms.server.http.rest.model.AbstractRestService;
import de.elpro.ewms.server.transactions.TransactionChangeset;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="structure/property")
public class PropertyRestService
extends AbstractRestService<Property> {
    private static Logger logger = Activator.getLoggerFactory().createLogger(PropertyRestService.class.getName());

    public PropertyRestService() {
        super(Property.class, (Comparable[])new Property[0]);
    }

    @GET
    @Path(value="/get/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public Property get(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        return (Property)this.getGeneric(trx, Integer.valueOf(id));
    }

    @GET
    @Path(value="/get/trx={trx}&group_key={group_key}&property_key={property_key}")
    @Produces(value={"application/json"})
    public Property get(@PathParam(value="trx") int trx, @PathParam(value="group_key") String groupKey, @PathParam(value="property_key") String propertyKey) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            Property property = (Property)em.createQuery("SELECT o FROM Property o WHERE o.group = :group AND o.key = :key", Property.class).setParameter("group", (Object)new PropertyGroup(null, groupKey)).setParameter("key", (Object)propertyKey).getSingleResultOrNull();
            return property;
        }
        catch (Exception exc) {
            logger.error("Error at 'get property by group key and property key'", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/get/trx={trx}&structure_class_id={class_id}&property_type_id={type_id}")
    @Produces(value={"application/json"})
    public Property[] get(@PathParam(value="trx") int trx, @PathParam(value="class_id") int classId, @PathParam(value="type_id") String typeId) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            StructureClass structureClass = (StructureClass)em.find(StructureClass.class, (Object)classId);
            List props = em.createQuery("SELECT o FROM Property o, PropertyGroup g WHERE o.group = g AND g.structureClass IN :parent_classes AND o.typeId = :type_id", Property.class).setParameter("parent_classes", (Object)structureClass.getAllParentClasses()).setParameter("type_id", (Object)typeId).getResultList();
            Object[] result = props.toArray(new Property[0]);
            Arrays.sort(result);
            return result;
        }
        catch (Exception exc) {
            logger.error("Error at 'get properties by class and type'", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/get/trx={trx}&group_key={key}")
    @Produces(value={"application/json"})
    public Property[] getByPropertyGroup(@PathParam(value="trx") int trx, @PathParam(value="key") String propertyGroupKey) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            PropertyGroup propertyGroup = (PropertyGroup)em.find(PropertyGroup.class, (Object)propertyGroupKey);
            LinkedList properties = new LinkedList(propertyGroup.getProperties());
            Collections.sort(properties);
            return properties.toArray((Property[])this.emptyArray);
        }
        catch (Exception exc) {
            logger.error("Error at 'get all properties by property groups'", (Throwable)exc);
            return null;
        }
    }

    @POST
    @Path(value="/save_or_update/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult saveOrUpdate(@PathParam(value="trx") int trx, Property property) {
        OperationResult result = this.saveOrUpdateGeneric(trx, property);
        TransactionChangeset.changedOrNew((int)trx, (Object)property);
        return result;
    }

    @GET
    @Path(value="/delete/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public OperationResult delete(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        Property property = this.get(trx, id);
        property.getGroup().getKey();
        OperationResult result = this.deleteGeneric(trx, Integer.valueOf(id));
        TransactionChangeset.removed((int)trx, (Object)property);
        return result;
    }

    @Override
    protected Serializable getId(Property object) {
        return object.getId();
    }
}

