/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.structure;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.structure.Property;
import de.elpro.ewms.core.structure.PropertyValue;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.http.rest.auth.AuthenticatedRestService;
import de.elpro.ewms.server.transactions.TransactionChangeset;
import java.io.Serializable;
import java.time.Instant;
import javax.persistence.EntityManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Secured
@Path(value="structure/property_value")
public class PropertyValueRestService
extends AuthenticatedRestService {
    @POST
    @Path(value="/save_or_update/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult saveOrUpdate(@PathParam(value="trx") int trx, PropertyValue[] propertyValues) {
        Instant timestamp = Instant.now();
        User user = this.getUser();
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            em.flush();
            em.clear();
            PropertyValue[] propertyValueArray = propertyValues;
            int n = propertyValues.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyValue pv = propertyValueArray[n2];
                pv.setUser(user);
                pv.setTimestamp(timestamp);
                if (pv.getValue() == null || pv.getValue().isEmpty()) {
                    PropertyValue oldValue = (PropertyValue)em.find(PropertyValue.class, (Object)this.getId(pv));
                    if (oldValue != null) {
                        em.remove((Object)oldValue);
                        TransactionChangeset.removed((int)trx, (Object)pv);
                    }
                } else {
                    Property property = (Property)em.find(Property.class, (Object)pv.getProperty().getId());
                    pv.getProperty().setKey(property.getKey());
                    pv.getProperty().setGroup(property.getGroup());
                    pv.getProperty().setTypeId(property.getTypeId());
                    if (em.find(PropertyValue.class, (Object)this.getId(pv)) != null) {
                        em.merge((Object)pv);
                    } else {
                        em.persist((Object)pv);
                    }
                    TransactionChangeset.changedOrNew((int)trx, (Object)pv);
                }
                ++n2;
            }
            return OperationResult.SUCCESS;
        }
        catch (Exception exception) {
            return new OperationResult(ResultType.UnexprectedDbError, String.format("Cannot save property values", new Object[0]));
        }
    }

    protected Serializable getId(PropertyValue object) {
        return new PropertyValue(object.getStructureObject(), object.getProperty());
    }
}

