/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.structure;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.characteristic.Characteristic2D;
import de.elpro.ewms.core.characteristic.Characteristic2DInstance;
import de.elpro.ewms.core.charts.Chart2D;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.variable.SupplementValueStrategy;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.VariableInstanceType;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import de.elpro.ewms.server.http.rest.model.AbstractRestService;
import de.elpro.ewms.server.http.rest.structure.StructureObjectRestService;
import de.elpro.ewms.server.http.rest.variable.VariableInstancesRestService;
import de.elpro.ewms.server.http.rest.variable.VariableRestService;
import de.elpro.ewms.server.transactions.Modification;
import de.elpro.ewms.server.transactions.TransactionChangeset;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.persistence.EntityManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="structure/class")
public class StructureClassRestService
extends AbstractRestService<StructureClass> {
    private static Logger logger = Activator.getLoggerFactory().createLogger(StructureClassRestService.class.getName());

    public StructureClassRestService() {
        super(StructureClass.class, (Comparable[])new StructureClass[0]);
    }

    @GET
    @Path(value="/get/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public StructureClass getStructureClass(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        return (StructureClass)this.getGeneric(trx, Integer.valueOf(id));
    }

    @GET
    @Path(value="/get_roots/trx={trx}")
    @Produces(value={"application/json"})
    public StructureClass[] getRootClasses(@PathParam(value="trx") int trx) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            List classes = em.createQuery("SELECT o FROM StructureClass o WHERE o.parentClasses IS EMPTY", StructureClass.class).getResultList();
            Collections.sort(classes);
            return classes.toArray(new StructureClass[0]);
        }
        catch (Exception exc) {
            logger.error("Error at 'get structure root classes'", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/get_all/trx={trx}")
    @Produces(value={"application/json"})
    public StructureClass[] getAllClasses(@PathParam(value="trx") int trx) {
        return (StructureClass[])this.getAllGeneric(trx);
    }

    @GET
    @Path(value="/get_all_extenders/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public StructureClass[] getAllExtendClasses(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        try {
            StructureClass clazz = (StructureClass)this.getGeneric(trx, Integer.valueOf(id));
            return clazz.getAllExtendClasses().toArray((StructureClass[])this.emptyArray);
        }
        catch (Exception exc) {
            logger.error("Error at 'get all structure extend classes'", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/get_all_parents/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public StructureClass[] getAllParentClasses(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        try {
            StructureClass clazz = (StructureClass)this.getGeneric(trx, Integer.valueOf(id));
            return clazz.getAllParentClasses().toArray((StructureClass[])this.emptyArray);
        }
        catch (Exception exc) {
            logger.error("Error at 'get all structure parent classes'", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/get_all_variables/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public Variable[] getAllVariables(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        try {
            StructureClass clazz = (StructureClass)this.getGeneric(trx, Integer.valueOf(id));
            TreeSet vars = new TreeSet(clazz.getAllVariables());
            return vars.toArray(new Variable[0]);
        }
        catch (Exception exc) {
            logger.error("Error at 'get all class variables'", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/is_subclass/trx={trx}&parent_id={parent_id}&child_id={child_id}")
    @Produces(value={"application/json"})
    public Boolean isSubclass(@PathParam(value="trx") int trx, @PathParam(value="parent_id") int parentId, @PathParam(value="child_id") int childId) {
        if (parentId == childId) {
            return true;
        }
        StructureClass childClass = (StructureClass)this.getGeneric(trx, Integer.valueOf(childId));
        StructureClass parentClass = (StructureClass)this.getGeneric(trx, Integer.valueOf(parentId));
        return parentClass.getAllExtendClasses().contains(childClass);
    }

    @GET
    @Path(value="/get_all_objects/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public StructureObject[] getAllObjects(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        try {
            StructureClass clazz = (StructureClass)this.getGeneric(trx, Integer.valueOf(id));
            Object[] allObjects = clazz.getAllObjects().toArray(new StructureObject[0]);
            Arrays.sort(allObjects);
            return allObjects;
        }
        catch (Exception exc) {
            logger.error("Error at 'get structure root classes'", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/get_all_connection_parents/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public StructureClass[] getAllConnectionParents(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        try {
            StructureClass clazz = (StructureClass)this.getGeneric(trx, Integer.valueOf(id));
            LinkedList allowedParents = new LinkedList();
            Set parentClasses = clazz.getAllParentClasses();
            TreeSet connectionParentClasses = new TreeSet();
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            block2: for (StructureClass candidate : em.createQuery("SELECT o FROM StructureClass o", StructureClass.class).getResultList()) {
                for (StructureClass connection : candidate.getConnectedClasses()) {
                    if (!parentClasses.contains(connection) || connectionParentClasses.contains(candidate)) continue;
                    connectionParentClasses.addAll(connection.getAllExtendClasses());
                    continue block2;
                }
            }
            return allowedParents.toArray(new StructureClass[0]);
        }
        catch (Exception exc) {
            logger.error("Error at 'get all connection parents'", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/get_all_allowed_parent_objects/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public StructureObject[] getAllAllowedParentObjects(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        try {
            StructureClass clazz = (StructureClass)this.getGeneric(trx, Integer.valueOf(id));
            LinkedList<StructureObject> allowedParents = new LinkedList<StructureObject>();
            Set parentClasses = clazz.getAllParentClasses();
            HashSet<StructureClass> connectionParentClasses = new HashSet<StructureClass>();
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            block2: for (StructureClass candidate : em.createQuery("SELECT o FROM StructureClass o", StructureClass.class).getResultList()) {
                for (StructureClass connection : candidate.getConnectedClasses()) {
                    if (!parentClasses.contains(connection) || connectionParentClasses.contains(candidate)) continue;
                    connectionParentClasses.add(candidate);
                    continue block2;
                }
            }
            for (StructureClass connectionParentClass : connectionParentClasses) {
                for (StructureObject obj : connectionParentClass.getAllObjects()) {
                    if (allowedParents.contains(obj)) continue;
                    allowedParents.add(obj);
                }
            }
            Collections.sort(allowedParents);
            return allowedParents.toArray(new StructureObject[0]);
        }
        catch (Exception exc) {
            logger.error("Error at 'get structure root classes'", (Throwable)exc);
            return null;
        }
    }

    @POST
    @Path(value="/save_or_update/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult saveOrUpdate(@PathParam(value="trx") int trx, StructureClass structureClass) {
        if (!this.getUser().isAdmin()) {
            return OperationResult.ACCESS_DENIED;
        }
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            Serializable id = this.getId(structureClass);
            boolean isNew = id == null;
            boolean tokenChanged = false;
            if (!isNew) {
                StructureClass oldClass = (StructureClass)em.find(StructureClass.class, (Object)id);
                String oldKey = oldClass.getToken() != null ? oldClass.getToken() : "";
                String newKey = structureClass.getToken() != null ? structureClass.getToken() : "";
                tokenChanged = !oldKey.equals(newKey);
                em.flush();
                em.clear();
            }
            if (isNew) {
                em.persist((Object)structureClass);
            } else {
                em.merge((Object)structureClass);
            }
            em.flush();
            em.clear();
            structureClass = (StructureClass)em.find(StructureClass.class, (Object)structureClass.getId());
            for (StructureObject structureObject : structureClass.getAllObjects()) {
                HashSet children = new HashSet(structureObject.getChildren());
                for (StructureObject connectedObject : children) {
                    if (structureObject.getConnectionIsAllowed(connectedObject)) continue;
                    connectedObject.getParents().remove(structureObject);
                    em.merge((Object)connectedObject);
                    TransactionChangeset.changedOrNew((int)trx, (Object)connectedObject);
                }
                Set allVariables = structureObject.getStructureClass().getAllVariables();
                for (Variable variable2 : allVariables) {
                    VariableInstance insatance = structureObject.findVariableInstance(variable2);
                    if (insatance != null) continue;
                    VariableInstanceType defaultType = VariableInstanceType.None;
                    if (variable2.getSource().getDefaultType() != null) {
                        defaultType = variable2.getSource().getDefaultType();
                    }
                    SupplementValueStrategy defaultSupplementValueStrategy = variable2.getSource().getDefaultSupplementValueStrategy();
                    VariableInstance newInstance = new VariableInstance(defaultType, defaultSupplementValueStrategy, variable2, structureObject);
                    em.persist((Object)newInstance);
                    TransactionChangeset.changedOrNew((int)trx, (Object)newInstance);
                }
                for (VariableInstance instance : structureObject.getVariableInstances()) {
                    if (allVariables.contains(instance.getVariable())) continue;
                    VariableInstancesRestService.deleteVariableInstances(trx, this.getUser(), instance.getId());
                }
                Set allCharacteristics = structureObject.getStructureClass().getAllCharacteristics2D();
                for (Characteristic2D c2d2 : allCharacteristics) {
                    Characteristic2DInstance instance = c2d2.findInstance(structureObject);
                    if (instance != null) continue;
                    instance = new Characteristic2DInstance(c2d2, structureObject);
                    em.persist((Object)instance);
                    TransactionChangeset.changedOrNew((int)trx, (Object)instance);
                }
                for (Characteristic2DInstance instance : structureObject.getCharacteristic2DInstances()) {
                    if (allCharacteristics.contains(instance.getCharacteristic())) continue;
                    em.remove((Object)instance);
                    TransactionChangeset.removed((int)trx, (Object)instance);
                }
            }
            if (tokenChanged) {
                structureClass.getTokenizedVariables().forEach(variable -> TransactionChangeset.changedOrNew((int)trx, (Object)variable));
                structureClass.getTokenizedCharacteristic2D().forEach(c2d -> TransactionChangeset.changedOrNew((int)trx, (Object)c2d));
            }
            TransactionChangeset.changedOrNew((int)trx, (Object)structureClass);
            Integer newId = structureClass.getId();
            if (newId == null) {
                return OperationResult.SUCCESS;
            }
            return new OperationResult((Serializable)newId, ResultType.Success);
        }
        catch (Exception exc) {
            Integer id = structureClass.getId();
            if (id == null) {
                return new OperationResult(ResultType.UnexprectedDbError, String.format("Cannot save %s object", this.clazz.getSimpleName()), exc.toString());
            }
            return new OperationResult((Serializable)id, ResultType.UnexprectedDbError, String.format("Cannot save %s object with id=%s", this.clazz.getSimpleName(), id.toString()), exc.toString());
        }
    }

    @GET
    @Path(value="/delete/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public OperationResult delete(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        if (!this.getUser().isAdmin()) {
            return OperationResult.ACCESS_DENIED;
        }
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            StructureClass persistedClass = (StructureClass)em.find(StructureClass.class, (Object)id);
            for (StructureClass refClass : em.createQuery("SELECT o FROM StructureClass o WHERE :sc MEMBER OF o.connectedClasses", StructureClass.class).setParameter("sc", (Object)new StructureClass(id)).getResultList()) {
                refClass.getConnectedClasses().remove(new StructureClass(id));
                em.merge((Object)refClass);
            }
            for (Chart2D chart2d : em.createQuery("SELECT o FROM Chart2D o WHERE :sc MEMBER OF o.structureClasses", Chart2D.class).setParameter("sc", (Object)new StructureClass(id)).getResultList()) {
                chart2d.getStructureClasses().remove(new StructureClass(id));
                em.merge((Object)chart2d);
            }
            for (Variable var : persistedClass.getVariables()) {
                VariableRestService.deleteVariable(trx, this.getUser(), var.getId());
            }
            StructureObjectRestService.deleteStructureObjects(trx, this.getUser(), persistedClass.getObjects().stream().mapToInt(o -> o.getId()).toArray());
            em.createQuery("DELETE FROM ViewNode o WHERE o.dataClass = :sc").setParameter("sc", (Object)persistedClass).executeUpdate();
            em.remove((Object)persistedClass);
            TransactionChangeset.changedOrRemoved((int)trx, (Modification)new Modification((Object)persistedClass));
            return new OperationResult((Serializable)Integer.valueOf(id), ResultType.Success);
        }
        catch (Exception exc) {
            return new OperationResult((Serializable)Integer.valueOf(id), ResultType.UnexprectedDbError, String.format("Cannot delete %s object with id=%d", this.clazz.getSimpleName(), id), exc.toString());
        }
    }

    @Override
    protected Serializable getId(StructureClass object) {
        return object.getId();
    }
}

