/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.structure;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.structure.IStructureClassRole;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureClassRole;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.helpers.StructureClassRoleHelper;
import de.elpro.ewms.server.http.rest.auth.AuthenticatedRestService;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import de.elpro.ewms.server.http.rest.structure.StructureClassRestService;
import de.elpro.ewms.server.roles.Roles;
import java.util.Arrays;
import javax.persistence.EntityManager;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="structure/class/role")
public class StructureClassRoleRestService
extends AuthenticatedRestService {
    private static final Logger logger = Activator.getLoggerFactory().createLogger(StructureClassRestService.class.getName());

    @GET
    @Path(value="/get_all")
    @Produces(value={"application/json"})
    public StructureClassRole[] getStructureClassRoles() {
        return (StructureClassRole[])Arrays.stream(Roles.getClassRoles()).map(r -> StructureClassRole.of((IStructureClassRole)r)).toArray(StructureClassRole[]::new);
    }

    @GET
    @Path(value="/get/id={id}")
    @Produces(value={"application/json"})
    public StructureClassRole getStructureClassRole(@PathParam(value="id") String id) {
        return StructureClassRole.of((IStructureClassRole)Roles.getClassRole((String)id));
    }

    @GET
    @Path(value="/get_all_classes/trx={trx}&role_id={role_id}")
    @Produces(value={"application/json"})
    public StructureClass[] getClassesByRole(@PathParam(value="trx") int trx, @PathParam(value="role_id") String roleId) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            return StructureClassRoleHelper.getClassesByRole((EntityManager)em, (String)roleId);
        }
        catch (Exception exc) {
            logger.error("Error at get_classes_by_role", (Throwable)exc);
            return new StructureClass[0];
        }
    }

    @GET
    @Path(value="/get_all_objects/trx={trx}&role_id={role_id}")
    @Produces(value={"application/json"})
    public StructureObject[] getObjectsByRole(@PathParam(value="trx") int trx, @PathParam(value="role_id") String roleId) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            return StructureClassRoleHelper.getObjectsByRole((EntityManager)em, (String)roleId);
        }
        catch (Exception exc) {
            logger.error("Error at get_objects_by_role", (Throwable)exc);
            return new StructureObject[0];
        }
    }

    @GET
    @Path(value="/get_child_objects/trx={trx}&role_id={role_id}&obj_id={obj_id}")
    @Produces(value={"application/json"})
    public StructureObject[] getChildObjectsByRole(@PathParam(value="trx") int trx, @PathParam(value="role_id") String roleId, @PathParam(value="obj_id") int objectId) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            return StructureClassRoleHelper.getChildObjectsByRole((EntityManager)em, (String)roleId, (StructureObject)new StructureObject(objectId));
        }
        catch (Exception exc) {
            logger.error("Error at get_child_objects_by_role", (Throwable)exc);
            return new StructureObject[0];
        }
    }

    @GET
    @Path(value="/get_parent_objects/trx={trx}&role_id={role_id}&obj_id={obj_id}")
    @Produces(value={"application/json"})
    public StructureObject[] getParentObjectsByRole(@PathParam(value="trx") int trx, @PathParam(value="role_id") String roleId, @PathParam(value="obj_id") int objectId) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            return StructureClassRoleHelper.getParentObjectsByRole((EntityManager)em, (String)roleId, (StructureObject)new StructureObject(objectId));
        }
        catch (Exception exc) {
            logger.error("Error at get_parent_objects_by_role", (Throwable)exc);
            return new StructureObject[0];
        }
    }
}

