/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.structure;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.characteristic.Characteristic2D;
import de.elpro.ewms.core.characteristic.Characteristic2DInstance;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.structure.PropertyValue;
import de.elpro.ewms.core.structure.SearchPolicy;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.structure.StructureObjectCopyOptions;
import de.elpro.ewms.core.variable.SupplementValueStrategy;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.VariableInstanceType;
import de.elpro.ewms.server.cache.ORMCache;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.helpers.ObjectTreeHelper;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import de.elpro.ewms.server.http.rest.model.AbstractRestService;
import de.elpro.ewms.server.http.rest.variable.VariableInstancesRestService;
import de.elpro.ewms.server.transactions.TransactionChangeset;
import de.elpro.ewms.server.transactions.TransactionProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="structure/object")
public class StructureObjectRestService
extends AbstractRestService<StructureObject> {
    private final Logger logger = Activator.getLoggerFactory().createLogger(StructureObjectRestService.class.getName());

    public StructureObjectRestService() {
        super(StructureObject.class, (Comparable[])new StructureObject[0]);
    }

    @GET
    @Path(value="/get/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public StructureObject get(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        return (StructureObject)this.getGeneric(trx, Integer.valueOf(id));
    }

    @POST
    @Path(value="/get/trx={trx}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public StructureObject[] get(@PathParam(value="trx") int trx, Integer[] ids) {
        EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
        List objects = em.createQuery("SELECT o FROM StructureObject o WHERE o.id IN :ids", StructureObject.class).setParameter("ids", Arrays.asList(ids)).getResultList();
        HashMap map = new HashMap();
        objects.forEach(o -> {
            StructureObject structureObject = map.put(o.getId(), o);
        });
        StructureObject[] result = new StructureObject[ids.length];
        int i = 0;
        while (i < ids.length) {
            result[i] = (StructureObject)map.get(ids[i]);
            ++i;
        }
        return result;
    }

    @GET
    @Path(value="/get_all/trx={trx}")
    @Produces(value={"application/json"})
    public StructureObject[] getAll(@PathParam(value="trx") int trx) {
        return (StructureObject[])this.getAllGeneric(trx);
    }

    @GET
    @Path(value="/get/trx={trx}&key={key}")
    @Produces(value={"application/json"})
    public StructureObject get(@PathParam(value="trx") int trx, @PathParam(value="key") String key) {
        StructureObject cachedObject = ORMCache.getStructureObject((String)key);
        if (cachedObject == null) {
            return null;
        }
        return (StructureObject)this.getGeneric(trx, cachedObject.getId());
    }

    @GET
    @Path(value="/get_roots/trx={trx}")
    @Produces(value={"application/json"})
    public StructureObject[] getRoots(@PathParam(value="trx") int trx) {
        EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
        List objects = em.createQuery("SELECT o FROM StructureObject o WHERE o.parents IS EMPTY", StructureObject.class).getResultList();
        Collections.sort(objects);
        return objects.toArray((StructureObject[])this.emptyArray);
    }

    @GET
    @Path(value="/get_root_parents/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public StructureObject[] getRootParents(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
        StructureObject object = (StructureObject)em.find(StructureObject.class, (Object)id);
        if (object == null) {
            return (StructureObject[])this.emptyArray;
        }
        Object[] result = (StructureObject[])object.getRootParents().toArray(StructureObject[]::new);
        Arrays.sort(result);
        return result;
    }

    @GET
    @Path(value="/get_children/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public StructureObject[] getConnectedObjects(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        StructureObject object = (StructureObject)this.getGeneric(trx, Integer.valueOf(id));
        Object[] children = object.getChildren().toArray((StructureObject[])this.emptyArray);
        Arrays.sort(children);
        return children;
    }

    @GET
    @Path(value="/get_all_children/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public StructureObject[] getAllConnectedObjects(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        StructureObject object = (StructureObject)this.getGeneric(trx, Integer.valueOf(id));
        Object[] children = object.getAllChildren().toArray((StructureObject[])this.emptyArray);
        Arrays.sort(children);
        return children;
    }

    @GET
    @Path(value="/get_top_children/trx={trx}&id={id}&class_id={class_id}")
    @Produces(value={"application/json"})
    public StructureObject[] getTopConnectedObjectsOfClass(@PathParam(value="trx") int trx, @PathParam(value="id") int id, @PathParam(value="class_id") int classId) {
        StructureObject object = (StructureObject)this.getGeneric(trx, Integer.valueOf(id));
        LinkedList<StructureObject> searchObjects = new LinkedList<StructureObject>();
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            StructureClass searchClass = (StructureClass)em.find(StructureClass.class, (Object)classId);
            Set subClasses = searchClass.getAllExtendClasses();
            HashSet candidates = new HashSet(object.getChildren());
            HashSet nextLvl = new HashSet();
            while (!candidates.isEmpty()) {
                for (StructureObject candidate : candidates) {
                    if (subClasses.contains(candidate.getStructureClass())) {
                        searchObjects.add(candidate);
                        continue;
                    }
                    nextLvl.addAll(candidate.getChildren());
                }
                candidates.clear();
                candidates.addAll(nextLvl);
                nextLvl.clear();
            }
        }
        catch (Exception exception) {
            return null;
        }
        Collections.sort(searchObjects);
        return searchObjects.toArray((StructureObject[])this.emptyArray);
    }

    @GET
    @Path(value="/find_objects/trx={trx}&id={id}&class_id={class_id}&policy={policy: [^/]*}")
    @Produces(value={"application/json"})
    public StructureObject[] findOverObjectTree(@PathParam(value="trx") int trx, @PathParam(value="id") int objectId, @PathParam(value="class_id") int classId, @PathParam(value="policy") String policyName) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            SearchPolicy searchPolicy = policyName != null && !policyName.isEmpty() ? SearchPolicy.valueOf((String)policyName) : SearchPolicy.Auto;
            StructureObject structureObject = (StructureObject)this.getGeneric(trx, Integer.valueOf(objectId));
            StructureClass structureClass = (StructureClass)em.find(StructureClass.class, (Object)classId);
            return ObjectTreeHelper.findOverObjectTree((EntityManager)em, (StructureObject)structureObject, (StructureClass)structureClass, (SearchPolicy)searchPolicy).toArray(new StructureObject[0]);
        }
        catch (Exception exc) {
            this.logger.error("Error at 'find_objects'", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/is_subchild/trx={trx}&parent_id={parent_id}&child_id={child_id}")
    @Produces(value={"application/json"})
    public Boolean isSubchild(@PathParam(value="trx") int trx, @PathParam(value="parent_id") int parentId, @PathParam(value="child_id") int childId) {
        if (parentId == childId) {
            return true;
        }
        StructureObject child = (StructureObject)this.getGeneric(trx, Integer.valueOf(childId));
        StructureObject parent = (StructureObject)this.getGeneric(trx, Integer.valueOf(parentId));
        return parent.getAllChildren().contains(child);
    }

    @POST
    @Path(value="/save_or_update/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult saveOrUpdate(@PathParam(value="trx") int trx, StructureObject structureObject) {
        if (!this.getUser().isAdmin()) {
            return OperationResult.ACCESS_DENIED;
        }
        return StructureObjectRestService.saveStructureObject(trx, this.getUser(), structureObject);
    }

    @POST
    @Path(value="/create_copy/trx={trx}&src_id={src_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult createCopy(@PathParam(value="trx") int trx, @PathParam(value="src_id") int srcObjectId, StructureObjectCopyOptions copyOptions) {
        if (!this.getUser().isAdmin()) {
            return OperationResult.ACCESS_DENIED;
        }
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            StructureObject srcObject = (StructureObject)em.find(StructureObject.class, (Object)srcObjectId);
            StructureObject copy = new StructureObject();
            copy.setName(copyOptions.getName());
            copy.setKey(copyOptions.getKey());
            copy.setDefaultColor(srcObject.getDefaultColor());
            copy.setPlcAliasMapText(copyOptions.getPlcAliasMapText());
            copy.setStructureClass(srcObject.getStructureClass());
            copy.getParents().addAll(copyOptions.getParents());
            OperationResult saveResult = StructureObjectRestService.saveStructureObject(trx, this.getUser(), copy);
            if (saveResult.getType() != ResultType.Success) {
                return saveResult;
            }
            em.flush();
            em.clear();
            srcObject = (StructureObject)em.find(StructureObject.class, (Object)srcObjectId);
            copy = (StructureObject)em.find(StructureObject.class, (Object)saveResult.getObjectId());
            HashMap<Variable, VariableInstance> copyInstances = new HashMap<Variable, VariableInstance>();
            for (VariableInstance copyInstance : copy.getVariableInstances()) {
                copyInstances.put(copyInstance.getVariable(), copyInstance);
            }
            for (VariableInstance srcInstance : srcObject.getVariableInstances()) {
                VariableInstance copyInstance = (VariableInstance)copyInstances.get(srcInstance.getVariable());
                copyInstance.setType(srcInstance.getType());
                copyInstance.setSupplementValueStrategy(srcInstance.getSupplementValueStrategy());
                if (copyOptions.isCopyPLCInstanceProperties()) {
                    copyInstance.setPlcDataGroup(srcInstance.getPlcDataGroup());
                    copyInstance.setPlcDatasourceKey(srcInstance.getPlcDatasourceKey());
                    copyInstance.setPLCInstanceType(srcInstance.getPLCInstanceType());
                    copyInstance.setPlcRawValueAggregation(srcInstance.getPlcRawValueAggregation());
                    copyInstance.setPlcSourceMU(srcInstance.getPlcSourceMU());
                }
                em.merge((Object)copyInstance);
            }
            return saveResult;
        }
        catch (Exception exc) {
            this.logger.error("Error during creating copy of object", (Throwable)exc);
            return new OperationResult(ResultType.UnexprectedDbError, exc.getMessage());
        }
    }

    public static OperationResult saveStructureObject(int trx, User user, StructureObject structureObject) {
        EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)user);
        Integer id = structureObject.getId();
        boolean isNew = id == null;
        boolean needRebuildDependencyTree = false;
        boolean plcAliasMapChanged = false;
        boolean nameChanged = false;
        boolean valuesChanged = false;
        if (!isNew) {
            StructureObject oldObject = (StructureObject)em.find(StructureObject.class, (Object)id);
            String oldKey = oldObject.getKey() != null ? oldObject.getKey() : "";
            String newKey = structureObject.getKey() != null ? structureObject.getKey() : "";
            needRebuildDependencyTree = !oldKey.equals(newKey);
            Iterator oldPlcAliasMap = oldObject.getPlcAliasMapText() != null ? oldObject.getPlcAliasMapText() : "";
            Iterator newPlcAliasMap = structureObject.getPlcAliasMapText() != null ? structureObject.getPlcAliasMapText() : "";
            plcAliasMapChanged = !((String)((Object)oldPlcAliasMap)).equals(newPlcAliasMap);
            boolean bl = nameChanged = !oldObject.getName().equals(structureObject.getName());
            if (oldObject.getInstalled() == null && structureObject.getInstalled() != null || oldObject.getInstalled() != null && !oldObject.getInstalled().equals(structureObject.getInstalled()) || oldObject.getRemoved() == null && structureObject.getRemoved() != null || oldObject.getRemoved() != null && !oldObject.getRemoved().equals(structureObject.getRemoved())) {
                valuesChanged = true;
            }
        }
        structureObject.getPropertyValues().clear();
        if (id == null) {
            em.persist((Object)structureObject);
            id = structureObject.getId();
        } else {
            em.merge((Object)structureObject);
        }
        em.flush();
        em.clear();
        StructureClass structureClass = (StructureClass)em.find(StructureClass.class, (Object)structureObject.getStructureClass().getId());
        if (!isNew) {
            structureObject = (StructureObject)em.find(StructureObject.class, (Object)id);
        }
        if (!isNew) {
            Set availableProperties = structureClass.getAllProperties();
            for (PropertyValue prop : structureObject.getPropertyValues()) {
                if (availableProperties.contains(prop.getProperty())) continue;
                em.remove((Object)prop);
                TransactionChangeset.removed((int)trx, (Object)prop);
                TransactionChangeset.addProperty((int)trx, (TransactionProperty)TransactionProperty.REBUILD_DEPENDENCY_TREE);
            }
        }
        HashSet children = new HashSet(structureObject.getChildren());
        for (StructureObject connectedObject : children) {
            if (structureObject.getConnectionIsAllowed(connectedObject)) continue;
            connectedObject.getParents().remove(structureObject);
            em.merge((Object)connectedObject);
            TransactionChangeset.addProperty((int)trx, (TransactionProperty)TransactionProperty.REBUILD_DEPENDENCY_TREE);
        }
        Set allVariables = structureClass.getAllVariables();
        for (Variable variable : allVariables) {
            VariableInstance instance = structureObject.findVariableInstance(variable);
            if (instance == null) {
                VariableInstanceType defaultType = VariableInstanceType.None;
                if (variable.getSource().getDefaultType() != null) {
                    defaultType = variable.getSource().getDefaultType();
                }
                SupplementValueStrategy defaultSupplementValueStrategy = variable.getSource().getDefaultSupplementValueStrategy();
                VariableInstance newInstance = new VariableInstance(defaultType, defaultSupplementValueStrategy, variable, structureObject);
                em.persist((Object)newInstance);
                TransactionChangeset.changedOrNew((int)trx, (Object)newInstance);
                continue;
            }
            if (!nameChanged && !plcAliasMapChanged && !valuesChanged) continue;
            TransactionChangeset.changedOrNew((int)trx, (Object)instance);
        }
        for (VariableInstance instance : structureObject.getVariableInstances()) {
            if (allVariables.contains(instance.getVariable())) continue;
            em.createQuery("DELETE FROM VariableInstanceExplicitDependency d WHERE d.dependentOn = :instance").setParameter("instance", (Object)instance).executeUpdate();
            em.remove((Object)instance);
            TransactionChangeset.removed((int)trx, (Object)instance);
        }
        Set allCharacteristics = structureClass.getAllCharacteristics2D();
        for (Characteristic2D c2d : allCharacteristics) {
            Characteristic2DInstance instance = c2d.findInstance(structureObject);
            if (instance != null) continue;
            instance = new Characteristic2DInstance(c2d, structureObject);
            em.persist((Object)instance);
            TransactionChangeset.changedOrNew((int)trx, (Object)instance);
        }
        for (Characteristic2DInstance instance : structureObject.getCharacteristic2DInstances()) {
            if (allCharacteristics.contains(instance.getCharacteristic())) continue;
            em.remove((Object)instance);
            TransactionChangeset.removed((int)trx, (Object)instance);
        }
        if (needRebuildDependencyTree) {
            TransactionChangeset.addProperty((int)trx, (TransactionProperty)TransactionProperty.REBUILD_DEPENDENCY_TREE);
        }
        TransactionChangeset.changedOrNew((int)trx, (Object)structureObject);
        return new OperationResult((Serializable)id, ResultType.Success);
    }

    @GET
    @Path(value="/delete/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public OperationResult delete(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        if (!this.getUser().isAdmin()) {
            return OperationResult.ACCESS_DENIED;
        }
        try {
            StructureObjectRestService.deleteStructureObjects(trx, this.getUser(), id);
            return new OperationResult((Serializable)Integer.valueOf(id), ResultType.Success);
        }
        catch (Exception exc) {
            return new OperationResult((Serializable)Integer.valueOf(id), ResultType.UnexprectedDbError, String.format("Cannot delete %s object with id=%d", this.clazz.getSimpleName(), id), exc.toString());
        }
    }

    public static void deleteStructureObjects(int trx, User user, int ... ids) {
        EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)user);
        ArrayList<StructureObject> persistedObjects = new ArrayList<StructureObject>();
        int[] nArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            StructureObject persistedObject = (StructureObject)em.find(StructureObject.class, (Object)id);
            if (persistedObject != null) {
                persistedObjects.add(persistedObject);
            }
            ++n2;
        }
        int[] variableInstanceIds = em.createQuery("SELECT i.id FROM VariableInstance i WHERE i.structureObject IN :objects", Integer.class).setParameter("objects", persistedObjects).getResultList().stream().mapToInt(i -> i).toArray();
        VariableInstancesRestService.deleteVariableInstances(trx, user, variableInstanceIds);
        for (Characteristic2DInstance c2di : em.createQuery("SELECT o FROM Characteristic2DInstance o WHERE o.structureObject IN :objects", Characteristic2DInstance.class).setParameter("objects", persistedObjects).getResultList()) {
            em.remove((Object)c2di);
            TransactionChangeset.removed((int)trx, (Object)c2di);
        }
        for (Object o : em.createQuery("SELECT o FROM Note o WHERE o.structureObject IN :objects").setParameter("objects", persistedObjects).getResultList()) {
            em.remove(o);
        }
        for (Object o : em.createQuery("SELECT o FROM TableViewPrefs o WHERE o.structureObject IN :objects").setParameter("objects", persistedObjects).getResultList()) {
            em.remove(o);
        }
        for (Object o : em.createQuery("SELECT o FROM Chart2DViewPrefs o WHERE o.structureObject IN :objects").setParameter("objects", persistedObjects).getResultList()) {
            em.remove(o);
        }
        for (Object o : em.createQuery("SELECT o FROM Chart3DViewPrefs o WHERE o.structureObject IN :objects").setParameter("objects", persistedObjects).getResultList()) {
            em.remove(o);
        }
        for (StructureObject persistedObject : persistedObjects) {
            em.remove((Object)persistedObject);
            TransactionChangeset.removed((int)trx, (Object)persistedObject);
        }
    }

    @GET
    @Path(value="/create_missing_variable_instances/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public OperationResult createMissingVariableInstances(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        if (!this.getUser().isAdmin()) {
            return OperationResult.ACCESS_DENIED;
        }
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            StructureObject object = (StructureObject)this.getGeneric(trx, Integer.valueOf(id));
            Set existingInstances = object.getVariableInstances();
            StructureClass structureClass = (StructureClass)em.find(StructureClass.class, (Object)object.getStructureClass().getId());
            Set allVariables = structureClass.getAllVariables();
            for (Variable variable : allVariables) {
                boolean exists = false;
                for (VariableInstance existingInstance : existingInstances) {
                    if (!existingInstance.getVariable().equals((Object)variable)) continue;
                    exists = true;
                    break;
                }
                if (exists) continue;
                VariableInstanceType defaultType = variable.getSource().getDefaultType();
                if (defaultType == null) {
                    defaultType = VariableInstanceType.None;
                }
                SupplementValueStrategy defaultSupplementValueStrategy = variable.getSource().getDefaultSupplementValueStrategy();
                VariableInstance newInstance = new VariableInstance(defaultType, defaultSupplementValueStrategy, variable, object);
                em.persist((Object)newInstance);
                TransactionChangeset.changedOrNew((int)trx, (Object)newInstance);
            }
            return OperationResult.SUCCESS;
        }
        catch (Exception exc) {
            return new OperationResult((Serializable)Integer.valueOf(id), ResultType.UnexprectedDbError, String.format("Cannot create missing instances for object with id=%s", this.clazz.getSimpleName(), id), exc.toString());
        }
    }

    @Override
    protected Serializable getId(StructureObject object) {
        return object.getId();
    }
}

