/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.tables;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.tables.Column;
import de.elpro.ewms.core.tables.ColumnGroup;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import de.elpro.ewms.server.http.rest.model.AbstractRestService;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.persistence.EntityManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="tables/columngroup")
public class ColumnGroupRestService
extends AbstractRestService<ColumnGroup> {
    private static Logger logger = Activator.getLoggerFactory().createLogger(ColumnGroupRestService.class.getName());

    public ColumnGroupRestService() {
        super(ColumnGroup.class, (Comparable[])new ColumnGroup[0]);
    }

    @GET
    @Path(value="/get/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public ColumnGroup get(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        return (ColumnGroup)this.getGeneric(trx, Integer.valueOf(id));
    }

    @GET
    @Path(value="/get_columns/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public Column[] getColumns(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            List columns = em.createQuery("SELECT o FROM Column o WHERE o.columnGroup = :cg", Column.class).setParameter("cg", (Object)new ColumnGroup(id)).getResultList();
            Collections.sort(columns);
            return columns.toArray(new Column[0]);
        }
        catch (Exception exc) {
            logger.error("error reading table columns", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/get_child_columngroups/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public ColumnGroup[] getColumnGroups(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            List columnGroups = em.createQuery("SELECT o FROM ColumnGroup o WHERE o.parentGroup = :cg", ColumnGroup.class).setParameter("cg", (Object)new ColumnGroup(id)).getResultList();
            Collections.sort(columnGroups);
            return columnGroups.toArray(new ColumnGroup[0]);
        }
        catch (Exception exc) {
            logger.error("error reading table child column groups", (Throwable)exc);
            return null;
        }
    }

    @POST
    @Path(value="/save_or_update/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult saveOrUpdate(@PathParam(value="trx") int trx, ColumnGroup columnGroup) {
        return this.saveOrUpdateGeneric(trx, columnGroup);
    }

    @GET
    @Path(value="/delete/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public OperationResult delete(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        return this.deleteGeneric(trx, Integer.valueOf(id));
    }

    @Override
    protected Serializable getId(ColumnGroup object) {
        return object.getId();
    }
}

