/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.tables;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.tables.Column;
import de.elpro.ewms.core.tables.ColumnGroup;
import de.elpro.ewms.core.tables.Table;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import de.elpro.ewms.server.http.rest.model.AbstractRestService;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="tables/table")
public class TableRestService
extends AbstractRestService<Table> {
    private static Logger logger = Activator.getLoggerFactory().createLogger(TableRestService.class.getName());

    public TableRestService() {
        super(Table.class, (Comparable[])new Table[0]);
    }

    @GET
    @Path(value="/get/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public Table get(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        return (Table)this.getGeneric(trx, Integer.valueOf(id));
    }

    @GET
    @Path(value="/get_all/trx={trx}")
    @Produces(value={"application/json"})
    public Table[] getAll(@PathParam(value="trx") int trx) {
        return (Table[])this.getAllGeneric(trx);
    }

    @GET
    @Path(value="/get_by_class/trx={trx}&class_id={class_id}")
    @Produces(value={"application/json"})
    public Table[] getByClass(@PathParam(value="trx") int trx, @PathParam(value="class_id") int structureClassId) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            StructureClass structureClass = (StructureClass)em.find(StructureClass.class, (Object)structureClassId);
            List tables = em.createQuery("SELECT o FROM Table o WHERE o.structureClass = :class", Table.class).setParameter("class", (Object)structureClass).getResultList();
            Collections.sort(tables);
            return tables.toArray(new Table[0]);
        }
        catch (Exception exc) {
            logger.error("error reading table for structure class", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/find_by_class/trx={trx}&class_id={class_id}")
    @Produces(value={"application/json"})
    public Table[] findByClass(@PathParam(value="trx") int trx, @PathParam(value="class_id") int structureClassId) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            StructureClass structureClass = (StructureClass)em.find(StructureClass.class, (Object)structureClassId);
            Set allParentClasses = structureClass.getAllParentClasses();
            List tables = em.createQuery("SELECT o FROM Table o WHERE o.structureClass IN :parent_classes", Table.class).setParameter("parent_classes", (Object)allParentClasses).getResultList();
            Collections.sort(tables);
            return tables.toArray(new Table[0]);
        }
        catch (Exception exc) {
            logger.error("error reading table for structure class", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/find_by_role/trx={trx}&role_key={role_key}")
    @Produces(value={"application/json"})
    public Table findByRole(@PathParam(value="trx") int trx, @PathParam(value="role_key") String roleKey) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            return (Table)em.createQuery("SELECT o FROM Table o Where o.roleKey = :role_key", Table.class).setParameter("role_key", (Object)roleKey).getSingleResultOrNull();
        }
        catch (Exception exc) {
            logger.error("error reading table for role", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/get_root_columns/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public Column[] getRootColumns(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            List columns = em.createQuery("SELECT o FROM Column o WHERE o.table = :table AND o.columnGroup IS NULL", Column.class).setParameter("table", (Object)new Table(id)).getResultList();
            Collections.sort(columns);
            return columns.toArray(new Column[0]);
        }
        catch (Exception exc) {
            logger.error("error reading table root columns", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/get_root_columngroups/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public ColumnGroup[] getRootColumnGroups(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            List columnGroups = em.createQuery("SELECT o FROM ColumnGroup o WHERE o.table = :table AND o.parentGroup IS NULL", ColumnGroup.class).setParameter("table", (Object)new Table(id)).getResultList();
            Collections.sort(columnGroups);
            return columnGroups.toArray(new ColumnGroup[0]);
        }
        catch (Exception exc) {
            logger.error("error reading table root column groups", (Throwable)exc);
            return null;
        }
    }

    @POST
    @Path(value="/save_or_update/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult saveOrUpdate(@PathParam(value="trx") int trx, Table table) {
        if (!this.getUser().isAdmin()) {
            return OperationResult.ACCESS_DENIED;
        }
        if (table.getRoleKey() != null) {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            for (Table roleKeyTable : em.createQuery("SELECT o FROM Table o Where o.roleKey = :role_key", Table.class).setParameter("role_key", (Object)table.getRoleKey()).getResultList()) {
                if (roleKeyTable.equals((Object)table)) continue;
                return new OperationResult(ResultType.UnexprectedError, String.format("Table '%s' already assigned to role key '%s'", roleKeyTable, table.getRoleKey()));
            }
        }
        return this.saveOrUpdateGeneric(trx, table);
    }

    @GET
    @Path(value="/delete/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public OperationResult delete(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        if (!this.getUser().isAdmin()) {
            return OperationResult.ACCESS_DENIED;
        }
        EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
        em.createQuery("DELETE FROM TableViewPrefs o WHERE o.table = :t").setParameter("t", (Object)new Table(id)).executeUpdate();
        return this.deleteGeneric(trx, Integer.valueOf(id));
    }

    @Override
    protected Serializable getId(Table object) {
        return object.getId();
    }
}

