/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.tables;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.tables.Table;
import de.elpro.ewms.core.tables.viewprefs.TableViewPrefs;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import de.elpro.ewms.server.http.rest.model.AbstractRestService;
import java.io.Serializable;
import javax.persistence.EntityManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="tables/table_view_prefs")
public class TableViewPrefsRestService
extends AbstractRestService<TableViewPrefs> {
    private static Logger logger = Activator.getLoggerFactory().createLogger(TableViewPrefsRestService.class.getName());

    public TableViewPrefsRestService() {
        super(TableViewPrefs.class, (Comparable[])new TableViewPrefs[0]);
    }

    @GET
    @Path(value="/get/trx={trx}&table_id={table_id}&object_id={object_id: [^/]*}")
    @Produces(value={"application/json"})
    public TableViewPrefs get(@PathParam(value="trx") int trx, @PathParam(value="table_id") int table_id, @PathParam(value="object_id") Integer structure_object_id) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            if (structure_object_id != null) {
                return (TableViewPrefs)em.createQuery("SELECT o FROM TableViewPrefs o WHERE o.table = :table AND o.user = :user AND o.structureObject = :object", TableViewPrefs.class).setParameter("table", (Object)new Table(table_id)).setParameter("user", (Object)this.getUser()).setParameter("object", (Object)new StructureObject(structure_object_id.intValue())).getSingleResultOrNull();
            }
            return (TableViewPrefs)em.createQuery("SELECT o FROM TableViewPrefs o WHERE o.table = :table AND o.user = :user AND o.structureObject IS NULL", TableViewPrefs.class).setParameter("table", (Object)new Table(table_id)).setParameter("user", (Object)this.getUser()).getSingleResultOrNull();
        }
        catch (Exception exc) {
            logger.error("Error reading TableViewPrefs", (Throwable)exc);
            return null;
        }
    }

    @POST
    @Path(value="/save_or_update/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult saveOrUpdate(@PathParam(value="trx") int trx, TableViewPrefs tableViewPrefs) {
        tableViewPrefs.setUser(this.getUser());
        return this.saveOrUpdateGeneric(trx, tableViewPrefs);
    }

    @GET
    @Path(value="/delete/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public OperationResult delete(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        return this.deleteGeneric(trx, Integer.valueOf(id));
    }

    @GET
    @Path(value="/delete/trx={trx}&table_id={table_id}&object_id={object_id: [^/]*}")
    @Produces(value={"application/json"})
    public OperationResult deleteByTable(@PathParam(value="trx") int trx, @PathParam(value="table_id") int table_id, @PathParam(value="object_id") Integer structure_object_id) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            if (structure_object_id != null) {
                em.createQuery("DELETE FROM TableViewPrefs o WHERE o.table = :table AND o.user = :user AND o.structureObject = :object").setParameter("table", (Object)new Table(table_id)).setParameter("user", (Object)this.getUser()).setParameter("object", (Object)new StructureObject(structure_object_id.intValue())).executeUpdate();
            } else {
                em.createQuery("DELETE FROM TableViewPrefs o WHERE o.table = :table AND o.user = :user").setParameter("table", (Object)new Table(table_id)).setParameter("user", (Object)this.getUser()).executeUpdate();
            }
            return OperationResult.SUCCESS;
        }
        catch (Exception exc) {
            logger.error("Error deleting TableViewPrefs", (Throwable)exc);
            return new OperationResult(ResultType.UnexprectedDbError, exc.getMessage());
        }
    }

    @Override
    protected Serializable getId(TableViewPrefs object) {
        return object.getId();
    }
}

