/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.time;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.time.PhaseType;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import de.elpro.ewms.server.http.rest.model.AbstractRestService;
import java.io.Serializable;
import java.util.List;
import javax.persistence.EntityManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="timeline/phase_type")
public class PhaseTypeRestService
extends AbstractRestService<PhaseType> {
    private static final Logger logger = Activator.getLoggerFactory().createLogger(PhaseTypeRestService.class.getName());

    public PhaseTypeRestService() {
        super(PhaseType.class, (Comparable[])new PhaseType[0]);
    }

    @GET
    @Path(value="/get/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public PhaseType get(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        try {
            return (PhaseType)this.getGeneric(trx, Integer.valueOf(id));
        }
        catch (Exception exc) {
            logger.error("Error at 'get_timeline'", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/get_all/trx={trx}")
    @Produces(value={"application/json"})
    public PhaseType[] getAll(@PathParam(value="trx") int trx) {
        try {
            return (PhaseType[])this.getAllGeneric(trx);
        }
        catch (Exception exc) {
            logger.error("Error at 'get_all_timelines'", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/get_all/trx={trx}&timeline_key={timeline_key}")
    @Produces(value={"application/json"})
    public PhaseType[] getAll(@PathParam(value="trx") int trx, @PathParam(value="timeline_key") String timelineKey) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            List phases = em.createQuery("SELECT o FROM PhaseType o, Timeline t WHERE o.timeline = t AND t.key = :tlk", PhaseType.class).setParameter("tlk", (Object)timelineKey).getResultList();
            return phases.toArray((PhaseType[])this.emptyArray);
        }
        catch (Exception exc) {
            logger.error("Error at 'get_all_timeline_phase_types by timeline'", (Throwable)exc);
            return null;
        }
    }

    @POST
    @Path(value="/save_or_update/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult saveOrUpdate(@PathParam(value="trx") int trx, PhaseType phaseType) {
        return this.saveOrUpdateGeneric(trx, phaseType);
    }

    @GET
    @Path(value="/delete/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public OperationResult delete(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        OperationResult result = this.deleteGeneric(trx, Integer.valueOf(id));
        return result;
    }

    @Override
    protected Serializable getId(PhaseType object) {
        return object.getId();
    }
}

