/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.time;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.time.TimeRange;
import de.elpro.ewms.core.time.TimeRangeFilterPreference;
import de.elpro.ewms.core.time.TimeRangeFilterType;
import de.elpro.ewms.core.virtualtime.VirtualZone;
import de.elpro.ewms.server.Server;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.http.rest.auth.AuthenticatedRestService;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import java.time.OffsetDateTime;
import javax.persistence.EntityManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="timerange/prefs")
public class TimeRangeFilterPreferencesService
extends AuthenticatedRestService {
    private static final Logger logger = Activator.getLoggerFactory().createLogger(TimeRangeFilterPreferencesService.class.getName());

    @GET
    @Path(value="/get/trx={trx}")
    @Produces(value={"application/json"})
    public TimeRangeFilterPreference getUserPreferences(@PathParam(value="trx") int trx) {
        try {
            User user = this.getUser();
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            TimeRangeFilterPreference pref = (TimeRangeFilterPreference)em.createQuery("SELECT o FROM TimeRangeFilterPreference o WHERE o.user = :user", TimeRangeFilterPreference.class).setParameter("user", (Object)user).getSingleResultOrNull();
            if (pref == null) {
                pref = new TimeRangeFilterPreference();
                pref.setType(TimeRangeFilterType.GlobalView_Date);
                Server.getRawValuesViews().getGlobalView();
                TimeRange range = Server.getRawValuesViews().getGlobalView().getComputationTimeRange();
                if (range != null) {
                    OffsetDateTime from = VirtualZone.INSTANCE.getOffsetDateTime(range.getFrom());
                    OffsetDateTime to = VirtualZone.INSTANCE.getOffsetDateTime(range.getTo());
                    pref.setDateFrom(from.toLocalDate());
                    pref.setYearFilterFrom(from.toLocalDate().getYear());
                    pref.setYearFilterTo(to.toLocalDate().getYear());
                }
            }
            return pref;
        }
        catch (Exception exc) {
            logger.error("Error at 'get_timeline'", (Throwable)exc);
            return null;
        }
    }

    @POST
    @Path(value="/save_or_update/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult saveOrUpdate(@PathParam(value="trx") int trx, TimeRangeFilterPreference prefs) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            prefs.setUser(this.getUser());
            TimeRangeFilterPreference oldPref = this.getUserPreferences(trx);
            if (oldPref != null && oldPref.getId() != null && !oldPref.getId().equals(prefs.getId()) && oldPref.getUser().equals((Object)this.getUser())) {
                em.remove((Object)oldPref);
                em.persist((Object)prefs);
            } else if (oldPref != null) {
                em.merge((Object)prefs);
            } else {
                em.persist((Object)prefs);
            }
            return OperationResult.SUCCESS;
        }
        catch (Exception exc) {
            return new OperationResult(ResultType.UnexprectedDbError, String.format("Cannot save %s object", TimeRangeFilterPreference.class.getSimpleName()), exc.toString());
        }
    }
}

