/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.time;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.time.TimeRangeFilterPreference;
import de.elpro.ewms.core.time.Timeline;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import de.elpro.ewms.server.http.rest.model.AbstractRestService;
import javax.persistence.EntityManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="timeline")
public class TimelineRestService
extends AbstractRestService<Timeline> {
    private static final Logger logger = Activator.getLoggerFactory().createLogger(TimelineRestService.class.getName());

    public TimelineRestService() {
        super(Timeline.class, (Comparable[])new Timeline[0]);
    }

    @GET
    @Path(value="/get/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public Timeline get(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        try {
            return (Timeline)this.getGeneric(trx, Integer.valueOf(id));
        }
        catch (Exception exc) {
            logger.error("Error at 'get_timeline'", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/get_all/trx={trx}")
    @Produces(value={"application/json"})
    public Timeline[] getAll(@PathParam(value="trx") int trx) {
        try {
            return (Timeline[])this.getAllGeneric(trx);
        }
        catch (Exception exc) {
            logger.error("Error at 'get_all_timelines'", (Throwable)exc);
            return null;
        }
    }

    @POST
    @Path(value="/save_or_update/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult saveOrUpdate(@PathParam(value="trx") int trx, Timeline timeline) {
        return this.saveOrUpdateGeneric(trx, timeline);
    }

    @GET
    @Path(value="/delete/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public OperationResult delete(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        if (!this.getUser().isAdmin()) {
            return OperationResult.ACCESS_DENIED;
        }
        EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
        Timeline timeline = (Timeline)em.find(Timeline.class, (Object)id);
        for (TimeRangeFilterPreference pref : em.createQuery("SELECT o FROM TimeRangeFilterPreference o WHERE o.timeline = :timeline OR EXISTS (SELECT tp FROM TimelinePhase tp, Timeline t WHERE tp.timeline = t AND t = :timeline AND tp = o.phaseFrom) OR EXISTS (SELECT tp FROM TimelinePhase tp, Timeline t WHERE tp.timeline = t AND t = :timeline AND tp = o.phaseTo)", TimeRangeFilterPreference.class).setParameter("timeline", (Object)timeline).getResultList()) {
            pref.setTimeline(null);
            pref.setPhaseFrom(null);
            pref.setPhaseTo(null);
            em.merge((Object)pref);
        }
        OperationResult result = this.deleteGeneric(trx, Integer.valueOf(id));
        return result;
    }

    protected Integer getId(Timeline object) {
        return object.getId();
    }
}

