/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.transaction;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.server.calculated.CircleDependencyTreeException;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.http.rest.auth.AuthenticatedRestService;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import de.elpro.ewms.server.transactions.TransactionChangeset;
import de.elpro.ui.thread.NamedThreadFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="transaction")
public class TransactionRestService
extends AuthenticatedRestService {
    private static final Logger logger;
    private static final int CORES_COUNT;
    private static final ExecutorService BEGIN_TRANSACTION_EXECUTOR;

    static {
        CORES_COUNT = Math.max(Runtime.getRuntime().availableProcessors(), 1);
        BEGIN_TRANSACTION_EXECUTOR = Executors.newFixedThreadPool(Math.max(CORES_COUNT / 2, 1), (ThreadFactory)new NamedThreadFactory("transaction-begin-thread-"));
        logger = Activator.getLoggerFactory().createLogger(TransactionRestService.class.getName());
    }

    @GET
    @Path(value="/begin")
    @Produces(value={"application/json"})
    public void beginTransaction(@Suspended AsyncResponse asyncResponse) {
        User user = this.getUser();
        BEGIN_TRANSACTION_EXECUTOR.execute(() -> {
            Transaction trx = EntityManagerPool.createTransaction((User)user);
            asyncResponse.resume((Object)trx);
        });
    }

    @GET
    @Path(value="/commit_sync/trx={trx}")
    @Produces(value={"application/json"})
    public OperationResult commitTransactionSync(@PathParam(value="trx") int trxId) {
        return TransactionRestService.commitTransactionSync(trxId, this.getUser());
    }

    public static OperationResult commitTransactionSync(int trxId, User user) {
        try {
            try {
                TransactionChangeset.prepareCommit((int)trxId, (User)user);
            }
            catch (CircleDependencyTreeException exc) {
                return new OperationResult(ResultType.ExpectedError, exc.getMessage(), exc.getInternalMessage());
            }
            catch (Exception exc) {
                logger.error("Unexpected DB Error at transaction commit", (Throwable)exc);
                if (exc.getCause() == null) {
                    return new OperationResult(ResultType.UnexprectedDbError, exc.getMessage());
                }
                return new OperationResult(ResultType.UnexprectedDbError, exc.getMessage(), exc.getCause().getMessage());
            }
            EntityManagerPool.commit((int)trxId, (User)user);
            TransactionChangeset.doPostCommitSync((int)trxId);
            return OperationResult.SUCCESS;
        }
        catch (Exception exc) {
            logger.error("Unexpected DB Error at transaction commit", (Throwable)exc);
            if (exc.getCause() != null) {
                return new OperationResult(ResultType.UnexprectedDbError, String.format("Error commiting transaction: %s", exc.getMessage()), exc.getCause().getMessage());
            }
            return new OperationResult(ResultType.UnexprectedDbError, String.format("Error commiting transaction: %s", exc.getMessage()));
        }
    }

    @GET
    @Path(value="/commit_async/trx={trx}")
    @Produces(value={"application/json"})
    public OperationResult commitTransactionAsync(@PathParam(value="trx") int trxId) {
        try {
            try {
                TransactionChangeset.prepareCommit((int)trxId, (User)this.getUser());
            }
            catch (CircleDependencyTreeException exc) {
                return new OperationResult(ResultType.ExpectedError, exc.getMessage(), exc.getInternalMessage());
            }
            catch (Exception exc) {
                logger.error("Unexpected DB Error at transaction commit", (Throwable)exc);
                if (exc.getCause() == null) {
                    return new OperationResult(ResultType.UnexprectedDbError, exc.getMessage());
                }
                return new OperationResult(ResultType.UnexprectedDbError, exc.getMessage(), exc.getCause().getMessage());
            }
            EntityManagerPool.commit((int)trxId, (User)this.getUser());
            TransactionChangeset.doPostCommitAsync((int)trxId);
            return OperationResult.SUCCESS;
        }
        catch (Exception exc) {
            logger.error("Unexpected DB Error at transaction commit", (Throwable)exc);
            if (exc.getCause() != null) {
                return new OperationResult(ResultType.UnexprectedDbError, String.format("Error commiting transaction: %s", exc.getMessage()), exc.getCause().getMessage());
            }
            return new OperationResult(ResultType.UnexprectedDbError, String.format("Error commiting transaction: %s", exc.getMessage()));
        }
    }

    @GET
    @Path(value="/rollback/trx={trx}")
    @Produces(value={"application/json"})
    public OperationResult rollbackTransaction(@PathParam(value="trx") int trxId) {
        try {
            EntityManagerPool.rollback((int)trxId, (User)this.getUser());
            TransactionChangeset.doPostRollback((int)trxId);
            return OperationResult.SUCCESS;
        }
        catch (Exception exc) {
            logger.error("Unexpected DB Error at transaction rollback", (Throwable)exc);
            return new OperationResult(ResultType.UnexprectedDbError, String.format("Error aborting transaction '%s'", trxId), exc.toString());
        }
    }

    @GET
    @Path(value="/close/trx={trx}")
    @Produces(value={"application/json"})
    public OperationResult closeTransaction(@PathParam(value="trx") int trxId) {
        return TransactionRestService.closeTransaction(trxId, this.getUser());
    }

    public static OperationResult closeTransaction(int trxId, User user) {
        try {
            EntityManagerPool.close((int)trxId, (User)user);
            return OperationResult.SUCCESS;
        }
        catch (Exception exc) {
            logger.error("Error closing transaction", (Throwable)exc);
            return new OperationResult(ResultType.UnexprectedDbError, String.format("Error closing transaction '%s'", trxId), exc.toString());
        }
    }

    @GET
    @Path(value="/close_all")
    @Produces(value={"application/json"})
    public OperationResult closeAllTransactions() {
        return TransactionRestService.closeAllTransactions(this.getUser());
    }

    public static OperationResult closeAllTransactions(User user) {
        try {
            EntityManagerPool.closeAll((User)user);
            return OperationResult.SUCCESS;
        }
        catch (Exception exc) {
            logger.error("Error closing transaction", (Throwable)exc);
            return new OperationResult(ResultType.UnexprectedDbError, String.format("Error closing all transactions for '%s'", user), exc.toString());
        }
    }
}

