/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.units;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.units.MeasuringUnitDefinition;
import de.elpro.ewms.core.units.PhysicalUnit;
import de.elpro.ewms.core.units.PhysicalUnitRegistry;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import de.elpro.ewms.server.http.rest.model.AbstractRestService;
import de.elpro.ewms.server.transactions.TransactionChangeset;
import java.util.List;
import javax.persistence.EntityManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="units/measuring_unit")
public class MeasuringUnitRestService
extends AbstractRestService<MeasuringUnitDefinition> {
    private static final Logger logger = Activator.getLoggerFactory().createLogger(MeasuringUnitRestService.class.getName());

    public MeasuringUnitRestService() {
        super(MeasuringUnitDefinition.class, (Comparable[])new MeasuringUnitDefinition[0]);
    }

    @GET
    @Path(value="/get_dynamic/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public MeasuringUnitDefinition getDynamic(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        try {
            return (MeasuringUnitDefinition)this.getGeneric(trx, Integer.valueOf(id));
        }
        catch (Exception exc) {
            logger.error("Error at 'get physical unit definition'", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/get_all_dynamic/trx={trx}&pu_key={pu_key}")
    @Produces(value={"application/json"})
    public MeasuringUnitDefinition[] getAllDynamic(@PathParam(value="trx") int trx, @PathParam(value="pu_key") String puKey) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            List defs = em.createQuery("SELECT o FROM MeasuringUnitDefinition o WHERE o.physicalUnitKey = :pu_key", MeasuringUnitDefinition.class).setParameter("pu_key", (Object)puKey).getResultList();
            return defs.toArray(new MeasuringUnitDefinition[0]);
        }
        catch (Exception exc) {
            logger.error("Error at 'get_all_generic'", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/get_all_predefined/pu_key={pu_key}")
    @Produces(value={"application/json"})
    public MeasuringUnitDefinition[] getAllPredefined(@PathParam(value="pu_key") String puKey) {
        PhysicalUnit pu = PhysicalUnit.getPhysicalUnit((String)puKey);
        if (pu == null) {
            return new MeasuringUnitDefinition[0];
        }
        return (MeasuringUnitDefinition[])pu.getPredefinedMeasuringUnits().stream().map(mu -> mu.toDefinition()).toArray(MeasuringUnitDefinition[]::new);
    }

    @POST
    @Path(value="/save_or_update/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult saveOrUpdate(@PathParam(value="trx") int trx, MeasuringUnitDefinition mu) {
        if (!this.getUser().isAdmin()) {
            return OperationResult.ACCESS_DENIED;
        }
        if (PhysicalUnitRegistry.getPredefinedPhysicalUnit((String)mu.getKey()) != null) {
            return new OperationResult(ResultType.UnexprectedError, "Cannot overwrite definition of predefined unit");
        }
        OperationResult result = this.saveOrUpdateGeneric(trx, mu);
        if (result.getType() == ResultType.Success) {
            TransactionChangeset.changedOrNew((int)trx, (Object)mu);
        }
        return result;
    }

    @GET
    @Path(value="/delete/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public OperationResult delete(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        if (!this.getUser().isAdmin()) {
            return OperationResult.ACCESS_DENIED;
        }
        OperationResult result = this.deleteGeneric(trx, Integer.valueOf(id));
        if (result.getType() == ResultType.Success) {
            TransactionChangeset.removed((int)trx, (Object)new MeasuringUnitDefinition(id));
        }
        return result;
    }

    protected Integer getId(MeasuringUnitDefinition object) {
        return object.getId();
    }
}

