/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.units;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.units.MeasuringUnitDefinition;
import de.elpro.ewms.core.units.PhysicalUnitDefinition;
import de.elpro.ewms.core.units.PhysicalUnitRegistry;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import de.elpro.ewms.server.http.rest.model.AbstractRestService;
import de.elpro.ewms.server.transactions.TransactionChangeset;
import java.io.Serializable;
import javax.persistence.EntityManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="units/physical_unit")
public class PhysicalUnitRestService
extends AbstractRestService<PhysicalUnitDefinition> {
    private static final Logger logger = Activator.getLoggerFactory().createLogger(PhysicalUnitRestService.class.getName());

    public PhysicalUnitRestService() {
        super(PhysicalUnitDefinition.class, (Comparable[])new PhysicalUnitDefinition[0]);
    }

    @GET
    @Path(value="/get_dynamic/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public PhysicalUnitDefinition getDynamic(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        try {
            return (PhysicalUnitDefinition)this.getGeneric(trx, Integer.valueOf(id));
        }
        catch (Exception exc) {
            logger.error("Error at 'get physical unit definition'", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/get_all_dynamic/trx={trx}")
    @Produces(value={"application/json"})
    public PhysicalUnitDefinition[] getAllDynamic(@PathParam(value="trx") int trx) {
        try {
            return (PhysicalUnitDefinition[])this.getAllGeneric(trx);
        }
        catch (Exception exc) {
            logger.error("Error at 'get_all_generic'", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/get_all_predefined")
    @Produces(value={"application/json"})
    public PhysicalUnitDefinition[] getAllPredefined() {
        return (PhysicalUnitDefinition[])PhysicalUnitRegistry.getPredefinedPhysicalUnits().stream().map(pu -> pu.toDefinition()).toArray(PhysicalUnitDefinition[]::new);
    }

    @POST
    @Path(value="/save_or_update/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult saveOrUpdate(@PathParam(value="trx") int trx, PhysicalUnitDefinition pu) {
        if (!this.getUser().isAdmin()) {
            return OperationResult.ACCESS_DENIED;
        }
        if (PhysicalUnitRegistry.getPredefinedPhysicalUnit((String)pu.getKey()) != null) {
            return new OperationResult(ResultType.UnexprectedError, "Cannot overwrite definition of predefined unit");
        }
        OperationResult result = this.saveOrUpdateGeneric(trx, pu);
        if (result.getType() == ResultType.Success) {
            TransactionChangeset.changedOrNew((int)trx, (Object)pu);
        }
        return result;
    }

    @GET
    @Path(value="/delete/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public OperationResult delete(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        if (!this.getUser().isAdmin()) {
            return OperationResult.ACCESS_DENIED;
        }
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            PhysicalUnitDefinition persistedObject = (PhysicalUnitDefinition)em.find(PhysicalUnitDefinition.class, (Object)id);
            if (persistedObject == null) {
                return OperationResult.SUCCESS;
            }
            for (MeasuringUnitDefinition mud : em.createQuery("SELECT o FROM MeasuringUnitDefinition o WHERE o.physicalUnitKey = :pu_key", MeasuringUnitDefinition.class).setParameter("pu_key", (Object)persistedObject.getKey()).getResultList()) {
                em.remove((Object)mud);
                TransactionChangeset.removed((int)trx, (Object)mud);
            }
            em.remove((Object)persistedObject);
            TransactionChangeset.removed((int)trx, (Object)persistedObject);
            return new OperationResult((Serializable)Integer.valueOf(id), ResultType.Success);
        }
        catch (Exception exc) {
            return new OperationResult((Serializable)Integer.valueOf(id), ResultType.UnexprectedDbError, String.format("Cannot delete %s object with id=%d", this.clazz.getSimpleName(), id), exc.toString());
        }
    }

    protected Integer getId(PhysicalUnitDefinition object) {
        return object.getId();
    }
}

