/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.variable;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.variable.Location;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.http.rest.model.AbstractRestService;
import de.elpro.ewms.server.transactions.TransactionChangeset;
import java.io.Serializable;
import javax.persistence.EntityManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Secured
@Path(value="location")
public class LocationsRestService
extends AbstractRestService<Location> {
    public LocationsRestService() {
        super(Location.class, (Comparable[])new Location[0]);
    }

    @GET
    @Path(value="/get/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public Location get(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        return (Location)this.getGeneric(trx, Integer.valueOf(id));
    }

    @GET
    @Path(value="/get_all/trx={trx}")
    @Produces(value={"application/json"})
    public Location[] getAll(@PathParam(value="trx") int trx) {
        return (Location[])this.getAllGeneric(trx);
    }

    @POST
    @Path(value="/save_or_update/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult saveOrUpdate(@PathParam(value="trx") int trx, Location location) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            if (location.getId() != null) {
                em.merge((Object)location);
            } else {
                em.persist((Object)location);
            }
            for (Variable variable : em.createQuery("SELECT o FROM Variable o WHERE o.location = :location", Variable.class).setParameter("location", (Object)location).getResultList()) {
                TransactionChangeset.changedOrNew((int)trx, (Object)variable);
            }
            return new OperationResult((Serializable)location.getId(), ResultType.Success);
        }
        catch (Exception exc) {
            return new OperationResult(ResultType.UnexprectedDbError, String.format("Cannot save %s object %s", this.clazz.getSimpleName(), location, exc.toString()));
        }
    }

    @GET
    @Path(value="/delete/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public OperationResult delete(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        return this.deleteGeneric(trx, Integer.valueOf(id));
    }

    @Override
    protected Serializable getId(Location object) {
        return object.getId();
    }
}

