/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.variable;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.variable.Specialization;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.http.rest.model.AbstractRestService;
import de.elpro.ewms.server.transactions.TransactionChangeset;
import java.io.Serializable;
import javax.persistence.EntityManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Secured
@Path(value="specialization")
public class SpecializationsRestService
extends AbstractRestService<Specialization> {
    public SpecializationsRestService() {
        super(Specialization.class, (Comparable[])new Specialization[0]);
    }

    @GET
    @Path(value="/get/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public Specialization get(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        return (Specialization)this.getGeneric(trx, Integer.valueOf(id));
    }

    @GET
    @Path(value="/get_all/trx={trx}")
    @Produces(value={"application/json"})
    public Specialization[] getRootClasses(@PathParam(value="trx") int trx) {
        return (Specialization[])this.getAllGeneric(trx);
    }

    @POST
    @Path(value="/save_or_update/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult saveOrUpdate(@PathParam(value="trx") int trx, Specialization specialization) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            if (specialization.getId() != null) {
                em.merge((Object)specialization);
            } else {
                em.persist((Object)specialization);
            }
            for (Variable variable : em.createQuery("SELECT o FROM Variable o WHERE o.specialization = :specialization", Variable.class).setParameter("specialization", (Object)specialization).getResultList()) {
                TransactionChangeset.changedOrNew((int)trx, (Object)variable);
            }
            return new OperationResult((Serializable)specialization.getId(), ResultType.Success);
        }
        catch (Exception exc) {
            return new OperationResult(ResultType.UnexprectedDbError, String.format("Cannot save %s object %s", this.clazz.getSimpleName(), specialization, exc.toString()));
        }
    }

    @GET
    @Path(value="/delete/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public OperationResult delete(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        return this.deleteGeneric(trx, Integer.valueOf(id));
    }

    @Override
    protected Serializable getId(Specialization object) {
        return object.getId();
    }
}

