/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.variable;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.variable.ValuesBounds;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.http.rest.model.AbstractRestService;
import de.elpro.ewms.server.transactions.TransactionChangeset;
import java.io.Serializable;
import java.util.LinkedList;
import javax.persistence.EntityManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Secured
@Path(value="valuesbounds")
public class ValuesBoundsRestService
extends AbstractRestService<ValuesBounds> {
    public ValuesBoundsRestService() {
        super(ValuesBounds.class, (Comparable[])new ValuesBounds[0]);
    }

    @GET
    @Path(value="/get/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public ValuesBounds get(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        return (ValuesBounds)this.getGeneric(trx, Integer.valueOf(id));
    }

    @GET
    @Path(value="/get_all/trx={trx}")
    @Produces(value={"application/json"})
    public ValuesBounds[] getAll(@PathParam(value="trx") int trx) {
        return (ValuesBounds[])this.getAllGeneric(trx);
    }

    @GET
    @Path(value="/get_all/trx={trx}&pu_id={pu_id}")
    @Produces(value={"application/json"})
    public ValuesBounds[] getAll(@PathParam(value="trx") int trx, @PathParam(value="pu_id") String physicalUnitId) {
        LinkedList<ValuesBounds> pBounds = new LinkedList<ValuesBounds>();
        ValuesBounds[] valuesBoundsArray = (ValuesBounds[])this.getAllGeneric(trx);
        int n = valuesBoundsArray.length;
        int n2 = 0;
        while (n2 < n) {
            ValuesBounds bounds = valuesBoundsArray[n2];
            if (bounds.getMeasuringUnit().getPhysicalUnit().getKey().equals(physicalUnitId)) {
                pBounds.add(bounds);
            }
            ++n2;
        }
        return pBounds.toArray(new ValuesBounds[0]);
    }

    @POST
    @Path(value="/save_or_update/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult saveOrUpdate(@PathParam(value="trx") int trx, ValuesBounds object) {
        OperationResult result = this.saveOrUpdateGeneric(trx, object);
        if (result.getType() != ResultType.Success) {
            return result;
        }
        EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
        for (Variable variable : em.createQuery("SELECT o FROM Variable o WHERE o.valuesBounds = :values_bounds", Variable.class).setParameter("values_bounds", (Object)object).getResultList()) {
            TransactionChangeset.changedOrNew((int)trx, (Object)variable);
        }
        for (VariableInstance variableInstance : em.createQuery("SELECT o FROM VariableInstance o WHERE o.valuesBounds = :values_bounds", VariableInstance.class).setParameter("values_bounds", (Object)object).getResultList()) {
            TransactionChangeset.changedOrNew((int)trx, (Object)variableInstance);
        }
        return result;
    }

    @GET
    @Path(value="/delete/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public OperationResult delete(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        return this.deleteGeneric(trx, Integer.valueOf(id));
    }

    @Override
    protected Serializable getId(ValuesBounds object) {
        return object.getId();
    }
}

