/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.variable;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.calculated.dependencies.DependencyKey;
import de.elpro.ewms.core.variable.calculated.dependencies.VariableInstanceDependency;
import de.elpro.ewms.core.variable.calculated.dependencies.VariableInstanceExplicitDependency;
import de.elpro.ewms.server.cache.ORMCache;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.http.rest.auth.AuthenticatedRestService;
import de.elpro.ewms.server.transactions.TransactionChangeset;
import java.util.ArrayList;
import java.util.HashSet;
import javax.persistence.EntityManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Secured
@Path(value="variable/instance/dependency")
public class VariableInstanceDependencyRestService
extends AuthenticatedRestService {
    @GET
    @Path(value="/get_dependencies/trx={trx}&instance_id={id}")
    @Produces(value={"application/json"})
    public VariableInstanceDependency[] getDependencies(@PathParam(value="trx") int trx, @PathParam(value="id") int instanceId) {
        VariableInstance instance = new VariableInstance(instanceId);
        ArrayList<VariableInstanceDependency> deps = new ArrayList<VariableInstanceDependency>();
        for (DependencyKey key : ORMCache.getDependenciesKeys((VariableInstance)instance)) {
            for (Object dependency : ORMCache.getDependencies((VariableInstance)instance, (DependencyKey)key)) {
                deps.add(new VariableInstanceDependency(instance, key, dependency));
            }
        }
        return deps.toArray(new VariableInstanceDependency[0]);
    }

    @POST
    @Path(value="/save_all/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult saveAll(@PathParam(value="trx") int trx, VariableInstanceExplicitDependency[] dependencies) {
        try {
            HashSet<VariableInstance> instances = new HashSet<VariableInstance>();
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            VariableInstanceExplicitDependency[] variableInstanceExplicitDependencyArray = dependencies;
            int n = dependencies.length;
            int n2 = 0;
            while (n2 < n) {
                VariableInstanceExplicitDependency dependency = variableInstanceExplicitDependencyArray[n2];
                em.persist((Object)dependency);
                instances.add(dependency.getVariableInstance());
                ++n2;
            }
            em.flush();
            em.clear();
            for (VariableInstance instance : instances) {
                TransactionChangeset.changedOrNew((int)trx, (Object)instance);
            }
            return OperationResult.SUCCESS;
        }
        catch (Exception exc) {
            return new OperationResult(ResultType.UnexprectedDbError, String.format("Cannot save dependencies", new Object[0]), exc.toString());
        }
    }

    @POST
    @Path(value="/delete_all/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult deleteAll(@PathParam(value="trx") int trx, VariableInstanceExplicitDependency[] dependencies) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            HashSet<VariableInstance> instances = new HashSet<VariableInstance>();
            VariableInstanceExplicitDependency[] variableInstanceExplicitDependencyArray = dependencies;
            int n = dependencies.length;
            int n2 = 0;
            while (n2 < n) {
                VariableInstanceExplicitDependency dependency = variableInstanceExplicitDependencyArray[n2];
                em.remove((Object)dependency);
                instances.add(dependency.getVariableInstance());
                ++n2;
            }
            em.flush();
            em.clear();
            for (VariableInstance instance : instances) {
                TransactionChangeset.changedOrNew((int)trx, (Object)instance);
            }
            return OperationResult.SUCCESS;
        }
        catch (Exception exc) {
            return new OperationResult(ResultType.UnexprectedDbError, String.format("Cannot save dependencies", new Object[0]), exc.toString());
        }
    }
}

