/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.variable;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.snapshot.CreateVariableInstancesSnapshotRequest;
import de.elpro.ewms.core.variable.snapshot.GetVariableInstanceSnapshotGroupsRequest;
import de.elpro.ewms.core.variable.snapshot.VariableInstanceSnapshot;
import de.elpro.ewms.core.variable.snapshot.VariableInstanceSnapshotGroup;
import de.elpro.ewms.core.variable.value.DValArray;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.IVarValuesCollection;
import de.elpro.ewms.core.virtualtime.ComplexRaster;
import de.elpro.ewms.server.Server;
import de.elpro.ewms.server.cache.ORMCache;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.http.rest.auth.AuthenticatedRestService;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import de.elpro.ewms.server.http.rest.variable.VariableInstancesRestService;
import de.elpro.ewms.server.rasterizedvalues.RasterizedValues;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="variable/instance/snapshot_group")
public class VariableInstanceSnapshotGroupRestService
extends AuthenticatedRestService {
    private static Logger logger = Activator.getLoggerFactory().createLogger(VariableInstancesRestService.class.getName());

    @POST
    @Path(value="/create")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult createSnapshotGroup(CreateVariableInstancesSnapshotRequest request) {
        Instant timestamp;
        IVarValuesCollection[] instanceValues;
        Instant to;
        Instant from;
        Raster minRaster;
        RasterizedValues rasterizedValues = Server.getRawValuesViews().getValuesView(request.getViewType(), request.getViewIndex());
        if (rasterizedValues == null) {
            return new OperationResult(ResultType.UnexprectedError, "RawValuesView not found");
        }
        if (request.getInstances().size() == 0) {
            return new OperationResult(ResultType.ExpectedError, "Nothing to do");
        }
        Raster raster = minRaster = rasterizedValues.getRaster();
        if (request.getRaster() != null && raster.isCompatibleAggregation(minRaster)) {
            raster = request.getRaster();
        }
        VariableInstance[] instances = ORMCache.getVariableInstances((int[])request.getInstances().stream().mapToInt(i -> i.getId()).toArray());
        try {
            long toTs;
            rasterizedValues.readLock();
            long minFromTs = rasterizedValues.getComputationBounds().getValuesStartTs();
            long maxToTs = rasterizedValues.getComputationBounds().getValuesEndTs();
            long plcNowTs = rasterizedValues.getPlcNow();
            long fromTs = request.getFrom() != null ? Math.max(minFromTs, request.getFrom().toEpochMilli()) : minFromTs;
            long l = toTs = request.getTo() != null ? Math.min(maxToTs, request.getTo().toEpochMilli()) : maxToTs;
            if (request.isForecast()) {
                fromTs = Math.max(fromTs, plcNowTs);
            }
            from = Instant.ofEpochMilli(fromTs);
            to = Instant.ofEpochMilli(toTs);
            if (fromTs >= toTs) {
                LocalDateTime fromLocal = LocalDateTime.ofInstant(from, ZoneId.systemDefault());
                LocalDateTime toLocal = LocalDateTime.ofInstant(to, ZoneId.systemDefault());
                OperationResult operationResult = new OperationResult(ResultType.ExpectedError, String.format("Illegal effective time range: %s <-> %s", fromLocal, toLocal));
                return operationResult;
            }
            if (raster == minRaster) {
                instanceValues = rasterizedValues.getValues(instances, from, to);
            } else {
                instanceValues = new IVarValuesCollection[instances.length];
                int i2 = 0;
                while (i2 < instances.length) {
                    instanceValues[i2] = rasterizedValues.getValues(instances[i2], from, to, ComplexRaster.of((Raster)raster));
                    ++i2;
                }
            }
            timestamp = Instant.now();
        }
        finally {
            rasterizedValues.readUnlock();
        }
        try {
            Throwable minFromTs = null;
            Object var11_28 = null;
            try (Transaction trx = EntityManagerPool.createServersideTransaction((User)this.getUser());){
                EntityManager em = EntityManagerPool.getEntityManager((Transaction)trx, (User)this.getUser());
                VariableInstanceSnapshotGroup snapshotGroup = new VariableInstanceSnapshotGroup();
                snapshotGroup.setName(request.getName());
                snapshotGroup.setBaseRaster(raster);
                snapshotGroup.setValuesDataFrom(from);
                snapshotGroup.setValuesDataTo(to);
                snapshotGroup.setPublic(request.isPublic());
                snapshotGroup.setOwner(this.getUser());
                snapshotGroup.setTimestamp(timestamp);
                em.persist((Object)snapshotGroup);
                ArrayList<VariableInstanceSnapshot> snapshots = new ArrayList<VariableInstanceSnapshot>();
                int i3 = 0;
                while (i3 < instanceValues.length) {
                    IVarValuesCollection vals = instanceValues[i3];
                    VariableInstance instance = instances[i3];
                    VariableInstanceSnapshot snapshot = new VariableInstanceSnapshot();
                    snapshot.setSnapshotGroup(snapshotGroup);
                    snapshot.setInstance(instance);
                    snapshot.setValuesDataStream(vals.toByteArray());
                    snapshotGroup.setSnapshotDataSize(snapshotGroup.getSnapshotDataSize() + snapshot.getValuesDataStream().length);
                    snapshots.add(snapshot);
                    ++i3;
                }
                em.persist((Object)snapshotGroup);
                for (VariableInstanceSnapshot snapshot : snapshots) {
                    em.persist((Object)snapshot);
                }
                em.getTransaction().commit();
                return new OperationResult((Serializable)snapshotGroup.getId(), ResultType.Success);
            }
            catch (Throwable throwable) {
                if (minFromTs == null) {
                    minFromTs = throwable;
                } else if (minFromTs != throwable) {
                    minFromTs.addSuppressed(throwable);
                }
                throw minFromTs;
            }
        }
        catch (Exception exc) {
            logger.error("Error creating snapshot group", (Throwable)exc);
            return new OperationResult(ResultType.UnexprectedError, exc.getMessage());
        }
    }

    @POST
    @Path(value="/get")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public VariableInstanceSnapshotGroup[] getSnapshotGroups(GetVariableInstanceSnapshotGroupsRequest request) throws Exception {
        User user = this.getUser();
        Throwable throwable = null;
        Object var4_5 = null;
        try (Transaction trx = EntityManagerPool.createServersideTransaction((User)user);){
            EntityManager em = EntityManagerPool.getEntityManager((Transaction)trx, (User)user);
            VariableInstanceSnapshotGroup[] result = this.getSnapshotGroups(user, em, request);
            Arrays.stream(result).forEach(sg -> {
                int n = sg.getSnapshots().size();
            });
            return result;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @POST
    @Path(value="/get/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public VariableInstanceSnapshotGroup[] getSnapshotGroups(@PathParam(value="trx") int trx, GetVariableInstanceSnapshotGroupsRequest request) {
        User user = this.getUser();
        EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)user);
        return this.getSnapshotGroups(user, em, request);
    }

    private VariableInstanceSnapshotGroup[] getSnapshotGroups(User user, EntityManager em, GetVariableInstanceSnapshotGroupsRequest request) {
        String query = "SELECT sg FROM VariableInstanceSnapshotGroup sg";
        String filter = "";
        if (!user.isAdmin()) {
            filter = String.valueOf(filter) + "(sg.owner = :user OR sg.isPublic = TRUE)";
        }
        if (request.getFrom() != null) {
            if (!filter.isEmpty()) {
                filter = String.valueOf(filter) + " AND";
            }
            filter = String.valueOf(filter) + " sg.valuesDataTo > :from";
        }
        if (request.getTo() != null) {
            if (!filter.isEmpty()) {
                filter = String.valueOf(filter) + " AND";
            }
            filter = String.valueOf(filter) + " sg.valuesDataFrom < :to";
        }
        if (request.getInstances() != null) {
            if (!filter.isEmpty()) {
                filter = String.valueOf(filter) + " AND";
            }
            filter = String.valueOf(filter) + " EXISTS (SELECT s.instance FROM s.snapshots s WHERE s.snapshotGroup = sg AND s.instance IN :instances)";
        }
        query = String.valueOf(query) + (!filter.isEmpty() ? " WHERE" + filter : "") + " ORDER BY sg.timestamp DESC";
        TypedQuery typedQuery = em.createQuery(query, VariableInstanceSnapshotGroup.class);
        if (!user.isAdmin()) {
            typedQuery.setParameter("user", (Object)user);
        }
        if (request.getFrom() != null) {
            typedQuery.setParameter("from", (Object)request.getFrom());
        }
        if (request.getTo() != null) {
            typedQuery.setParameter("to", (Object)request.getTo());
        }
        if (request.getInstances() != null) {
            typedQuery.setParameter("instances", Arrays.asList(request.getInstances()));
        }
        List result = typedQuery.getResultList();
        return (VariableInstanceSnapshotGroup[])result.toArray(VariableInstanceSnapshotGroup[]::new);
    }

    @GET
    @Path(value="/get_variable_instances/id={group_id}")
    @Produces(value={"application/json"})
    public VariableInstance[] getVariableInstances(@PathParam(value="group_id") int snapshotGroupId) throws Exception {
        User user = this.getUser();
        Throwable throwable = null;
        Object var4_5 = null;
        try (Transaction trx = EntityManagerPool.createServersideTransaction((User)user);){
            EntityManager em = EntityManagerPool.getEntityManager((Transaction)trx, (User)user);
            return this.getVariableInstances(user, em, snapshotGroupId);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @GET
    @Path(value="/get_variable_instances/trx={trx}&id={group_id}")
    @Produces(value={"application/json"})
    public VariableInstance[] getVariableInstances(@PathParam(value="trx") int trx, @PathParam(value="group_id") int snapshotGroupId) {
        User user = this.getUser();
        EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)user);
        return this.getVariableInstances(user, em, snapshotGroupId);
    }

    private VariableInstance[] getVariableInstances(User user, EntityManager em, int snapshotGroupId) {
        VariableInstanceSnapshotGroup sg = (VariableInstanceSnapshotGroup)em.find(VariableInstanceSnapshotGroup.class, (Object)snapshotGroupId);
        if (sg == null) {
            return null;
        }
        if (!(user.isAdmin() || sg.getOwner().equals((Object)user) || sg.isPublic())) {
            return null;
        }
        List ids = em.createQuery("SELECT i.id FROM VariableInstance i, VariableInstanceSnapshot s WHERE s.snapshotGroup = :sg AND s.instance = i", Integer.class).setParameter("sg", (Object)sg).getResultList();
        return ORMCache.getVariableInstances((int[])ids.stream().mapToInt(i -> i).toArray());
    }

    @GET
    @Path(value="/get/var_values/trx={trx}&group_id={group_id}&instance_id={instance_id}")
    @Produces(value={"application/json"})
    public IVarValuesCollection getSnapshotVarValues(@PathParam(value="trx") int trx, @PathParam(value="group_id") int snapshotGroupId, @PathParam(value="instance_id") int instanceId) {
        VariableInstanceSnapshot snapshot;
        block3: {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            try {
                snapshot = (VariableInstanceSnapshot)em.createQuery("FROM VariableInstanceSnapshot s WHERE s.snapshotGroup = :sg AND s.instance = :instance", VariableInstanceSnapshot.class).setParameter("sg", (Object)new VariableInstanceSnapshotGroup(snapshotGroupId)).setParameter("instance", (Object)new VariableInstance(instanceId)).getSingleResult();
                if (snapshot != null) break block3;
                return null;
            }
            catch (Exception exc) {
                logger.error("Error loading snapshot data", (Throwable)exc);
                return null;
            }
        }
        return IVarValuesCollection.create((byte[])snapshot.getValuesDataStream());
    }

    @GET
    @Path(value="/get/dvals/trx={trx}&group_id={group_id}&instance_id={instance_id}")
    @Produces(value={"application/json"})
    public DValArray getSnapshotDVals(@PathParam(value="trx") int trx, @PathParam(value="group_id") int snapshotGroupId, @PathParam(value="instance_id") int instanceId) {
        VariableInstanceSnapshot snapshot;
        block4: {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            snapshot = (VariableInstanceSnapshot)em.createQuery("FROM VariableInstanceSnapshot s WHERE s.snapshotGroup = :sg AND s.instance = :instance", VariableInstanceSnapshot.class).setParameter("sg", (Object)new VariableInstanceSnapshotGroup(snapshotGroupId)).setParameter("instance", (Object)new VariableInstance(instanceId)).getSingleResult();
            if (snapshot != null) break block4;
            return null;
        }
        try {
            IVarValuesCollection varValuesColl = IVarValuesCollection.create((byte[])snapshot.getValuesDataStream());
            double[] dVals = new double[varValuesColl.size()];
            int j = 0;
            for (IVarValue val : varValuesColl) {
                dVals[j++] = val.getValue();
            }
            return new DValArray(snapshot.getSnapshotGroup().getValuesDataFrom().toEpochMilli(), snapshot.getSnapshotGroup().getValuesDataTo().toEpochMilli(), dVals);
        }
        catch (Exception exc) {
            logger.error("Error loading snapshot data", (Throwable)exc);
            return null;
        }
    }

    @POST
    @Path(value="/delete")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult delete(int[] ids) {
        User user = this.getUser();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Transaction trx = EntityManagerPool.createServersideTransaction((User)user);){
                EntityManager em = EntityManagerPool.getEntityManager((Transaction)trx, (User)user);
                this.delete(user, em, ids);
                em.getTransaction().commit();
                return OperationResult.SUCCESS;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exc) {
            logger.error("Error deleting snapshot groups", (Throwable)exc);
            return new OperationResult(ResultType.UnexprectedDbError, exc.getMessage());
        }
    }

    @POST
    @Path(value="/delete/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult delete(@PathParam(value="trx") int trx, int[] ids) {
        User user = this.getUser();
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)user);
            this.delete(user, em, ids);
            return OperationResult.SUCCESS;
        }
        catch (Exception exc) {
            logger.error("Error deleting snapshot groups", (Throwable)exc);
            return new OperationResult(ResultType.UnexprectedDbError, exc.getMessage());
        }
    }

    private OperationResult delete(User user, EntityManager em, int[] ids) {
        List idsList = Arrays.stream(ids).mapToObj(i -> i).collect(Collectors.toList());
        List groups = em.createQuery("FROM VariableInstanceSnapshotGroup sg WHERE sg.id IN :ids", VariableInstanceSnapshotGroup.class).setParameter("ids", idsList).getResultList();
        if (!this.getUser().isAdmin()) {
            for (VariableInstanceSnapshotGroup sg : groups) {
                if (sg.getOwner().equals((Object)user)) continue;
                return OperationResult.ACCESS_DENIED;
            }
        }
        em.createQuery("DELETE FROM VariableInstanceSnapshot s WHERE s.snapshotGroup IN :sgs").setParameter("sgs", (Object)groups).executeUpdate();
        em.createQuery("DELETE FROM VariableInstanceSnapshotGroup sg WHERE sg.id IN :ids").setParameter("ids", idsList).executeUpdate();
        return OperationResult.SUCCESS;
    }
}

