/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.variable;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.datasource.DataGroup;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.rawvalues.RawValuesViewType;
import de.elpro.ewms.core.structure.SearchPolicy;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.time.TimeIntervalStringValue;
import de.elpro.ewms.core.time.TimeIntervalStringValueCollection;
import de.elpro.ewms.core.time.TimeIntervalValue;
import de.elpro.ewms.core.time.VariableInstanceTimeIntervalStringValues;
import de.elpro.ewms.core.units.Aggregation;
import de.elpro.ewms.core.variable.Aggregator;
import de.elpro.ewms.core.variable.SupplementValueStrategy;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.VariableInstanceType;
import de.elpro.ewms.core.variable.calculated.dependencies.VariableInstanceExplicitDependency;
import de.elpro.ewms.core.variable.value.ArchiveValue;
import de.elpro.ewms.core.variable.value.DValArray;
import de.elpro.ewms.core.variable.value.GetValuesRequest;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.IVarValuesCollection;
import de.elpro.ewms.core.variable.value.SupplementValue;
import de.elpro.ewms.core.variable.value.SupplementValueChange;
import de.elpro.ewms.core.variable.value.VarInstanceValuesCollectionMap;
import de.elpro.ewms.core.variable.value.VarValue;
import de.elpro.ewms.core.virtualtime.ComplexRaster;
import de.elpro.ewms.core.virtualtime.VirtualRaster;
import de.elpro.ewms.server.Server;
import de.elpro.ewms.server.cache.ORMCache;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.db.randomaccess.MDBXTxn;
import de.elpro.ewms.server.db.randomaccess.RADbTransaction;
import de.elpro.ewms.server.db.randomaccess.TimeIntervaTextDB;
import de.elpro.ewms.server.helpers.ObjectTreeHelper;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import de.elpro.ewms.server.http.rest.model.AbstractRestService;
import de.elpro.ewms.server.rasterizedvalues.RasterizedValues;
import de.elpro.ewms.server.rasterizedvalues.StoredValuesConverter;
import de.elpro.ewms.server.storage.ArchiveStorage;
import de.elpro.ewms.server.supplement.SupplementStorage;
import de.elpro.ewms.server.transactions.Modification;
import de.elpro.ewms.server.transactions.TransactionChangeset;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="variable/instance")
public class VariableInstancesRestService
extends AbstractRestService<VariableInstance> {
    private static Logger logger = Activator.getLoggerFactory().createLogger(VariableInstancesRestService.class.getName());

    public VariableInstancesRestService() {
        super(VariableInstance.class, (Comparable[])new VariableInstance[0]);
    }

    @GET
    @Path(value="/get/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public VariableInstance get(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        try {
            VariableInstance instance = ORMCache.getVariableInstance((int)id);
            return instance;
        }
        catch (Exception exc) {
            logger.error("Error at 'get_instance'", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/get/trx={trx}&var_id={id}&obj_id={obj_id}")
    @Produces(value={"application/json"})
    public VariableInstance get(@PathParam(value="trx") int trx, @PathParam(value="id") int variableid, @PathParam(value="obj_id") int objectId) {
        try {
            VariableInstance[] variableInstanceArray = this.getAllByVariable(trx, variableid);
            int n = variableInstanceArray.length;
            int n2 = 0;
            while (n2 < n) {
                VariableInstance inst = variableInstanceArray[n2];
                if (inst.getStructureObject().getId() == objectId) {
                    return inst;
                }
                ++n2;
            }
            return null;
        }
        catch (Exception exc) {
            logger.error("Error at 'get_instance'", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/get_all/trx={trx}")
    @Produces(value={"application/json"})
    public VariableInstance[] getAll(@PathParam(value="trx") int trx) {
        return (VariableInstance[])this.getAllGeneric(trx);
    }

    @GET
    @Path(value="/get_all/trx={trx}&var_id={var_id}")
    @Produces(value={"application/json"})
    public VariableInstance[] getAllByVariable(@PathParam(value="trx") int trx, @PathParam(value="var_id") int varId) {
        try {
            ArrayList<VariableInstance> instances = new ArrayList<VariableInstance>();
            for (VariableInstance inst : ORMCache.getVariable((int)varId).getInstances()) {
                instances.add(ORMCache.getVariableInstance((int)inst.getId()));
            }
            return instances.toArray(new VariableInstance[0]);
        }
        catch (Exception exc) {
            logger.error("Error at 'get_all_instances_by_variable'", (Throwable)exc);
            return null;
        }
    }

    @POST
    @Path(value="/get_all/trx={trx}&var_id={var_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public VariableInstance[] getAllByVarAndObjects(int[] objectIds, @PathParam(value="trx") int trx, @PathParam(value="var_id") int varId) {
        try {
            ArrayList<VariableInstance> instances = new ArrayList<VariableInstance>();
            List variableInstances = ORMCache.getVariable((int)varId).getInstances().stream().map(i -> ORMCache.getVariableInstance((int)i.getId())).collect(Collectors.toList());
            int[] nArray = objectIds;
            int n = objectIds.length;
            int n2 = 0;
            while (n2 < n) {
                int objectId = nArray[n2];
                Optional<VariableInstance> oi = variableInstances.stream().filter(i -> i.getStructureObject().getId() == objectId).findAny();
                if (!oi.isPresent()) {
                    throw new Exception("Instance not found");
                }
                instances.add(oi.get());
                ++n2;
            }
            return instances.toArray(new VariableInstance[0]);
        }
        catch (Exception exc) {
            logger.error("Error at 'get_all_instances_by_variable'", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/get_all/trx={trx}&object_id={object_id}")
    @Produces(value={"application/json"})
    public VariableInstance[] getAllByObject(@PathParam(value="trx") int trx, @PathParam(value="object_id") int objectId) {
        EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
        try {
            StructureObject object = (StructureObject)em.find(StructureObject.class, (Object)objectId);
            return object.getVariableInstances().toArray(new VariableInstance[0]);
        }
        catch (Exception exc) {
            logger.error("Error at 'get_all_instances_by_object'", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/find_by_var_reference/trx={trx}&object_id={object_id}&search_policy={search_policy}&var_name={var_name: .*}")
    @Produces(value={"application/json"})
    public VariableInstance[] findByVariableReference(@PathParam(value="trx") int trx, @PathParam(value="object_id") int objectId, @PathParam(value="var_name") String varName, @PathParam(value="search_policy") String policyName) {
        EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
        try {
            SearchPolicy searchPolicy = policyName != null && !policyName.isEmpty() ? SearchPolicy.valueOf((String)policyName) : SearchPolicy.Auto;
            StructureObject object = (StructureObject)em.find(StructureObject.class, (Object)objectId);
            Variable variable = ORMCache.getVariable((String)varName);
            if (variable == null) {
                return new VariableInstance[0];
            }
            SortedSet sortedObjects = ObjectTreeHelper.findOverObjectTree((EntityManager)em, (StructureObject)object, (StructureClass)variable.getStructureClass(), (SearchPolicy)searchPolicy);
            return (VariableInstance[])variable.getInstances().stream().filter(i -> sortedObjects.contains(i.getStructureObject())).toArray(VariableInstance[]::new);
        }
        catch (Exception exc) {
            logger.error("Error at 'get_all_instances_by_object'", (Throwable)exc);
            return null;
        }
    }

    @POST
    @Path(value="/save_or_update/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult saveOrUpdate(@PathParam(value="trx") int trx, VariableInstance variableInstance) {
        if (!this.getUser().isAdmin()) {
            return OperationResult.ACCESS_DENIED;
        }
        EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
        boolean isNew = this.getId(variableInstance) == null;
        LinkedList dependencies = null;
        if (variableInstance.getType().isDependentType() && !isNew) {
            dependencies = new LinkedList(variableInstance.getDependencies());
            for (VariableInstanceExplicitDependency dep : dependencies) {
                VariableInstanceExplicitDependency id = new VariableInstanceExplicitDependency(variableInstance, dep.getDependentOn());
                if (em.find(VariableInstanceExplicitDependency.class, (Object)id) != null) {
                    em.merge((Object)dep);
                    continue;
                }
                em.persist((Object)dep);
            }
        }
        if (!variableInstance.getType().isDependentType()) {
            variableInstance.getDependencies().clear();
        }
        if (variableInstance.getWriteValuesSource() != null && variableInstance.getWriteValuesSource().equals((Object)variableInstance)) {
            return new OperationResult(ResultType.ExpectedError, "Write Variable Instance cannot be the same");
        }
        OperationResult result = this.saveOrUpdateGeneric(trx, variableInstance);
        if (isNew && dependencies != null) {
            for (VariableInstanceExplicitDependency dep : dependencies) {
                dep.setVariableInstance(variableInstance);
                em.persist((Object)dep);
            }
        }
        TransactionChangeset.changedOrNew((int)trx, (Object)variableInstance);
        return result;
    }

    @GET
    @Path(value="/set_datasource/trx={trx}&id={var_id}&data_group_id={group_id}&datasource_key={key: .*}")
    @Produces(value={"application/json"})
    public OperationResult setDatasource(@PathParam(value="trx") int trx, @PathParam(value="id") int id, @PathParam(value="group_id") int groupId, @PathParam(value="key") String datasourceKey) {
        try {
            VariableInstance instance = this.get(trx, id);
            if (instance == null) {
                return new OperationResult(ResultType.UnexprectedError, "Variable Instance not found");
            }
            instance.setPlcDatasourceKey(datasourceKey);
            instance.setPlcDataGroup(new DataGroup(groupId));
            OperationResult saveResult = this.saveOrUpdateGeneric(trx, instance);
            if (saveResult != OperationResult.SUCCESS) {
                return saveResult;
            }
            ORMCache.setInstanceDatasource((int)id, (DataGroup)new DataGroup(groupId), (String)datasourceKey);
            return OperationResult.SUCCESS;
        }
        catch (Exception exc) {
            return new OperationResult(ResultType.UnexprectedError, exc.getMessage());
        }
    }

    @POST
    @Path(value="/change_type/trx={trx}&type={type}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult changeInstancesType(@PathParam(value="trx") int trx, @PathParam(value="type") String typeName, Integer[] ids) {
        if (!this.getUser().isAdmin()) {
            return OperationResult.ACCESS_DENIED;
        }
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            VariableInstanceType type = VariableInstanceType.valueOf((String)typeName);
            for (VariableInstance instance : em.createQuery("SELECT o FROM VariableInstance o WHERE o.id IN :ids", VariableInstance.class).setParameter("ids", Arrays.asList(ids)).getResultList()) {
                instance.setType(type);
                if (type == VariableInstanceType.None || type == VariableInstanceType.PLC) {
                    instance.getDependencies().clear();
                }
                em.merge((Object)instance);
                TransactionChangeset.changedOrNew((int)trx, (Object)instance);
            }
            return OperationResult.SUCCESS;
        }
        catch (Exception exc) {
            return new OperationResult(ResultType.UnexprectedDbError, "Cannot change variable instances type. Error: " + exc.getMessage());
        }
    }

    @POST
    @Path(value="/change_supplement_strategy/trx={trx}&strategy={strategy: [^/]*}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult changeInstancesSupplementStrategy(@PathParam(value="trx") int trx, @PathParam(value="strategy") String supplStrName, Integer[] ids) {
        if (!this.getUser().isAdmin()) {
            return OperationResult.ACCESS_DENIED;
        }
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            SupplementValueStrategy type = null;
            if (supplStrName != null && !supplStrName.isEmpty()) {
                type = SupplementValueStrategy.valueOf((String)supplStrName);
            }
            for (VariableInstance instance : em.createQuery("SELECT o FROM VariableInstance o WHERE o.id IN :ids", VariableInstance.class).setParameter("ids", Arrays.asList(ids)).getResultList()) {
                instance.setSupplementValueStrategy(type);
                em.merge((Object)instance);
                TransactionChangeset.changedOrNew((int)trx, (Object)instance);
            }
            return OperationResult.SUCCESS;
        }
        catch (Exception exc) {
            return new OperationResult(ResultType.UnexprectedDbError, "Cannot change variable instances suppl. str. type. Error: " + exc.getMessage());
        }
    }

    @GET
    @Path(value="/delete/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public OperationResult delete(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        if (!this.getUser().isAdmin()) {
            return OperationResult.ACCESS_DENIED;
        }
        try {
            VariableInstancesRestService.deleteVariableInstances(trx, this.getUser(), id);
            return new OperationResult((Serializable)Integer.valueOf(id), ResultType.Success);
        }
        catch (Exception exc) {
            return new OperationResult((Serializable)Integer.valueOf(id), ResultType.UnexprectedDbError, String.format("Cannot delete %s object with id=%s", this.clazz.getSimpleName(), id), exc.toString());
        }
    }

    public static void deleteVariableInstances(int trx, User user, int ... ids) {
        EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)user);
        ArrayList<VariableInstance> instances = new ArrayList<VariableInstance>();
        int[] nArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            VariableInstance instance = (VariableInstance)em.find(VariableInstance.class, (Object)id);
            if (instance != null) {
                instances.add(instance);
            }
            ++n2;
        }
        em.createQuery("DELETE FROM Series2DViewPrefs o WHERE o.variableInstance IN :vi").setParameter("vi", instances).executeUpdate();
        em.createQuery("UPDATE VarSeries2D o SET o.variableInstance = NULL WHERE o.variableInstance IN :vi").setParameter("vi", instances).executeUpdate();
        em.createQuery("UPDATE VarSeries3D o SET o.XAxisVariableInstance = NULL WHERE o.XAxisVariableInstance IN :vi").setParameter("vi", instances).executeUpdate();
        em.createQuery("UPDATE VarSeries3D o SET o.YAxisVariableInstance = NULL WHERE o.YAxisVariableInstance IN :vi").setParameter("vi", instances).executeUpdate();
        em.createQuery("UPDATE VarSeries3D o SET o.ZAxisVariableInstance = NULL WHERE o.ZAxisVariableInstance IN :vi").setParameter("vi", instances).executeUpdate();
        em.createQuery("UPDATE VarSeries3D o SET o.WAxisVariableInstance = NULL WHERE o.WAxisVariableInstance IN :vi").setParameter("vi", instances).executeUpdate();
        em.createQuery("UPDATE Column o SET o.variableInstance = NULL WHERE o.variableInstance IN :vi").setParameter("vi", instances).executeUpdate();
        for (VariableInstance writeValuesSource : em.createQuery("SELECT o FROM VariableInstance o WHERE o.writeValuesSource IN :instance", VariableInstance.class).setParameter("instance", instances).getResultList()) {
            writeValuesSource.setWriteValuesSource(null);
            em.merge((Object)writeValuesSource);
            TransactionChangeset.changedOrNew((int)trx, (Object)writeValuesSource);
        }
        for (VariableInstanceExplicitDependency dep : em.createQuery("SELECT o FROM VariableInstanceExplicitDependency o WHERE o.dependentOn IN :instance", VariableInstanceExplicitDependency.class).setParameter("instance", instances).getResultList()) {
            em.remove((Object)dep);
            TransactionChangeset.changedOrRemoved((int)trx, (Modification)new Modification((Object)dep.getVariableInstance()));
        }
        for (VariableInstance instance : instances) {
            em.remove((Object)instance);
            logger.debugf("Variable instance '%s' removed", new Object[]{instance.getFullName()});
            TransactionChangeset.removed((int)trx, (Object)instance);
        }
    }

    @POST
    @Path(value="/convert_plc_values/pu_key={pu_key}&from_mu_key={from_mu_key}&to_mu_key={to_mu_key}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult convertPLCValues(int[] ids, @PathParam(value="pu_key") String puKey, @PathParam(value="from_mu_key") String fromMUKey, @PathParam(value="to_mu_key") String toMUKey) {
        throw new UnsupportedOperationException("Convert PLC Method need to be applyed on all views AND raw values");
    }

    @GET
    @Path(value="/archivevalues/get/view_type={view_type}&view_index={view_index: [^/]*}&id={id}&from={from: [^/]*}&to={to: [^/]*}")
    @Produces(value={"application/json"})
    public ArchiveValue[] getArchiveValues(@PathParam(value="view_type") RawValuesViewType viewType, @PathParam(value="view_index") Integer viewIndex, @PathParam(value="id") int id, @PathParam(value="from") Long from, @PathParam(value="to") Long to) {
        try {
            VariableInstance instance = ORMCache.getVariableInstance((int)id);
            RasterizedValues view = Server.getRawValuesViews().getValuesView(viewType, viewIndex);
            if (from == null) {
                from = view.getComputationBounds().getValuesStartTs();
            }
            if (to == null) {
                to = view.getComputationBounds().getValuesEndTs();
            }
            ArchiveStorage archiveStorage = view.getArchiveStorage();
            return archiveStorage.loadValues((Object)instance, null, from.longValue(), to.longValue()).toArray(new ArchiveValue[0]);
        }
        catch (Exception exc) {
            logger.error("Error at 'get_values'", (Throwable)exc);
            return null;
        }
    }

    @POST
    @Path(value="/archivevalues/import/view_type={view_type}&view_index={view_index: [^/]*}&id={id}")
    @Consumes(value={"application/json"})
    public void importArchiveValues(@PathParam(value="view_type") RawValuesViewType viewType, @PathParam(value="view_index") Integer viewIndex, @PathParam(value="id") int id, ArchiveValue[] values) {
        if (!this.getUser().isAdmin()) {
            return;
        }
        try {
            VariableInstance instance = ORMCache.getVariableInstance((int)id);
            RasterizedValues view = Server.getRawValuesViews().getValuesView(viewType, viewIndex);
            RADbTransaction trx = null;
            ArchiveStorage archiveStorage = view.getArchiveStorage();
            try {
                try {
                    view.writeLock();
                    trx = archiveStorage.beginTransaction();
                    archiveStorage.saveValues(trx, (Object)instance, Arrays.asList(values));
                    archiveStorage.commitTransaction(trx);
                }
                catch (Exception exception) {
                    if (trx != null) {
                        archiveStorage.abortTransaction(trx);
                    }
                    view.writeUnlock();
                }
            }
            finally {
                view.writeUnlock();
            }
        }
        catch (Exception exc) {
            logger.error("Error at 'write_supplementvalue'", (Throwable)exc);
        }
    }

    @GET
    @Path(value="/varvalue/get/view_type={view_type}&view_index={view_index: [^/]*}&id={id}&to={to: [^/]*}")
    @Produces(value={"application/json"})
    public IVarValuesCollection getVarValue(@PathParam(value="view_type") RawValuesViewType viewType, @PathParam(value="view_index") Integer viewIndex, @PathParam(value="id") int id, @PathParam(value="to") Long toTs) {
        try {
            RasterizedValues view = Server.getRawValuesViews().getValuesView(viewType, viewIndex);
            VariableInstance instance = ORMCache.getVariableInstance((int)id);
            if (toTs == null && view.getComputationBounds() != null) {
                toTs = view.getComputationBounds().getValuesEndTs();
            }
            Instant to = Instant.ofEpochMilli(view.getRaster().getRasterEnd(toTs.longValue()));
            Instant from = to.minusMillis(view.getRaster().toMilli());
            return view.getValuesSync(instance, from, to);
        }
        catch (Exception exc) {
            logger.error("Error at 'get_values'", (Throwable)exc);
            return null;
        }
    }

    @POST
    @Path(value="/varvalue/get/view_type={view_type}&view_index={view_index: [^/]*}&to={to: [^/]*}")
    @Produces(value={"application/json"})
    public VarInstanceValuesCollectionMap getVarValue(@PathParam(value="view_type") RawValuesViewType viewType, @PathParam(value="view_index") Integer viewIndex, @PathParam(value="to") Long toTs, int[] ids) {
        try {
            RasterizedValues view = Server.getRawValuesViews().getValuesView(viewType, viewIndex);
            VariableInstance[] instances = new VariableInstance[ids.length];
            int i = 0;
            while (i < ids.length) {
                instances[i] = ORMCache.getVariableInstance((int)ids[i]);
                ++i;
            }
            if (toTs == null && view.getComputationBounds() != null) {
                toTs = view.getComputationBounds().getValuesEndTs();
            }
            Instant to = Instant.ofEpochMilli(view.getRaster().getRasterEnd(toTs.longValue()));
            Instant from = to.minusMillis(view.getRaster().toMilli());
            VarInstanceValuesCollectionMap collectionMap = new VarInstanceValuesCollectionMap();
            IVarValuesCollection[] values = view.getValuesSync(instances, from, to);
            int i2 = 0;
            while (i2 < ids.length) {
                collectionMap.put(instances[i2], values[i2]);
                ++i2;
            }
            return collectionMap;
        }
        catch (Exception exc) {
            logger.error("Error at 'get_values'", (Throwable)exc);
            return null;
        }
    }

    private IVarValuesCollection[] getVarValues(RasterizedValues view, long from, long to, ComplexRaster raster, Collection<GetValuesRequest.VarValuesRequestInstance> instanceRequests) {
        VariableInstance[] instances = new VariableInstance[instanceRequests.size()];
        Aggregation[] aggrs = new Aggregation[instances.length];
        int i = 0;
        for (GetValuesRequest.VarValuesRequestInstance requestInstance : instanceRequests) {
            instances[i] = ORMCache.getVariableInstance((int)requestInstance.getId());
            aggrs[i++] = requestInstance.getAggregation();
        }
        return this.getVarValues(view, from, to, raster, instances, aggrs);
    }

    private IVarValuesCollection[] getVarValues(RasterizedValues view, long from, long to, ComplexRaster raster, VariableInstance[] instances, Aggregation[] aggrs) {
        try {
            if (instances.length != aggrs.length) {
                throw new IllegalArgumentException();
            }
            int i = 0;
            while (i < instances.length) {
                instances[i] = ORMCache.getVariableInstance((int)instances[i].getId());
                ++i;
            }
            IVarValuesCollection[] values = view.getValuesSync(instances, Instant.ofEpochMilli(from), Instant.ofEpochMilli(to));
            if (raster != null && raster.ordinal() > view.getRaster().ordinal()) {
                int j = 0;
                while (j < values.length) {
                    IVarValue[] instanceValues = values[j].toArray();
                    VariableInstance instance = instances[j];
                    Aggregation aggr = aggrs[j] != null ? aggrs[j] : instance.getVariable().getResultAggregation();
                    values[j] = IVarValuesCollection.create((IVarValue[])Aggregator.aggregate((IVarValue[])instanceValues, (Raster)view.getRaster(), (ComplexRaster)raster, (Aggregation)aggr));
                    ++j;
                }
            }
            return values;
        }
        catch (Exception exc) {
            logger.error("Error at 'varvalues/get'", (Throwable)exc);
            return null;
        }
    }

    @POST
    @Path(value="/varvalues/get")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public IVarValuesCollection[] getVarValues(GetValuesRequest request) {
        RasterizedValues view = Server.getRawValuesViews().getValuesView(request.getViewType(), request.getViewIndex());
        long from = request.getFrom() != null ? request.getFrom().longValue() : view.getComputationBounds().getValuesStartTs();
        long to = request.getTo() != null ? request.getTo().longValue() : view.getComputationBounds().getValuesEndTs();
        return this.getVarValues(view, from, to, request.getRaster(), request.getInstances());
    }

    @GET
    @Path(value="/varvalues/get/view_type={view_type}&view_index={view_index: [^/]*}&id={id}&from={from: [^/]*}&to={to: [^/]*}&raster={raster_str: [^/]*}&aggr={aggr_str: [^/]*}")
    @Produces(value={"application/json"})
    public IVarValuesCollection getVarValues(@PathParam(value="view_type") RawValuesViewType viewType, @PathParam(value="view_index") Integer viewIndex, @PathParam(value="id") int id, @PathParam(value="from") Long from, @PathParam(value="to") Long to, @PathParam(value="raster_str") String rasterStr, @PathParam(value="aggr_str") String aggrStr) {
        try {
            ComplexRaster raster = rasterStr != null && !rasterStr.isEmpty() ? ComplexRaster.valueOf((String)rasterStr) : null;
            Aggregation aggr = aggrStr != null && !aggrStr.isEmpty() ? Aggregation.valueOf((String)aggrStr) : null;
            GetValuesRequest request = new GetValuesRequest(viewType, viewIndex, from, to, raster);
            request.addInstance(id, aggr);
            return this.getVarValues(request)[0];
        }
        catch (Exception exc) {
            logger.error("Error at 'get_values'", (Throwable)exc);
            return null;
        }
    }

    @POST
    @Path(value="/varvalues/get/raster2={raster2_str: [^/]*}&aggr2={aggr2_str: [^/]*}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public IVarValuesCollection[] getVarValuesTwoStepAggregation(GetValuesRequest request, @PathParam(value="raster2_str") String raster2Str, @PathParam(value="aggr2_str") String aggr2Str) {
        try {
            ComplexRaster dataRaster;
            Raster raster2 = Raster.valueOf((String)raster2Str);
            Aggregation aggr2 = Aggregation.valueOf((String)aggr2Str);
            RasterizedValues view = Server.getRawValuesViews().getValuesView(request.getViewType(), request.getViewIndex());
            ComplexRaster complexRaster = dataRaster = request.getRaster() != null ? request.getRaster() : ComplexRaster.of((Raster)view.getRaster());
            if (raster2.ordinal() >= dataRaster.ordinal()) {
                return this.getVarValues(request);
            }
            long from = request.getFrom() != null ? request.getFrom().longValue() : view.getComputationBounds().getValuesStartTs();
            long to = request.getTo() != null ? request.getTo().longValue() : view.getComputationBounds().getValuesEndTs();
            IVarValuesCollection[] raster1Values = this.getVarValues(view, from, to, ComplexRaster.of((Raster)raster2), request.getInstances());
            IVarValuesCollection[] raster2Values = new IVarValuesCollection[raster1Values.length];
            int i = 0;
            while (i < raster1Values.length) {
                raster2Values[i] = IVarValuesCollection.create((IVarValue[])Aggregator.aggregate((IVarValue[])raster1Values[i].toArray(), (Raster)raster2, (ComplexRaster)dataRaster, (Aggregation)aggr2));
                ++i;
            }
            return raster2Values;
        }
        catch (Exception exc) {
            logger.error("Error at 'get_values_thow_step_aggregation'", (Throwable)exc);
            return null;
        }
    }

    @POST
    @Path(value="/dvals/get")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public DValArray[] getDVals(GetValuesRequest request) {
        if (request.getRaster() != null && request.getRaster().getVirtualRaster() != null && request.getRaster().getVirtualRaster() != VirtualRaster.Hour) {
            return null;
        }
        RasterizedValues view = Server.getRawValuesViews().getValuesView(request.getViewType(), request.getViewIndex());
        long from = request.getFrom() != null ? request.getFrom().longValue() : view.getComputationBounds().getValuesStartTs();
        long to = request.getTo() != null ? request.getTo().longValue() : view.getComputationBounds().getValuesEndTs();
        try {
            Raster raster = request.getRaster() != null && request.getRaster().getVirtualRaster() == VirtualRaster.Hour ? Raster.Hour : (request.getRaster() != null ? request.getRaster().getRaster() : view.getRaster());
            IVarValuesCollection[] varValues = this.getVarValues(view, from, to, request.getRaster(), request.getInstances());
            DValArray[] result = new DValArray[varValues.length];
            from = raster.getRasterBegin(from);
            to = raster.getRasterEnd(to);
            int i = 0;
            while (i < result.length) {
                IVarValuesCollection varValsColl = varValues[i];
                double[] dVals = new double[varValsColl.size()];
                int j = 0;
                for (IVarValue val : varValsColl) {
                    dVals[j++] = val.getValue();
                }
                result[i] = new DValArray(from, to, dVals);
                ++i;
            }
            return result;
        }
        catch (Exception exc) {
            logger.error("Error at 'dvals/get'", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/dvals/get/view_type={view_type}&view_index={view_index: [^/]*}&id={id}&from={from: [^/]*}&to={to: [^/]*}&raster={raster_str: [^/]*}&aggr={aggr_str: [^/]*}")
    @Produces(value={"application/json"})
    public DValArray getDVals(@PathParam(value="view_type") RawValuesViewType viewType, @PathParam(value="view_index") Integer viewIndex, @PathParam(value="id") int id, @PathParam(value="from") Long from, @PathParam(value="to") Long to, @PathParam(value="raster_str") String rasterStr, @PathParam(value="aggr_str") String aggrStr) {
        try {
            ComplexRaster raster = rasterStr != null && !rasterStr.isEmpty() ? ComplexRaster.valueOf((String)rasterStr) : null;
            Aggregation aggr = aggrStr != null && !aggrStr.isEmpty() ? Aggregation.valueOf((String)aggrStr) : null;
            GetValuesRequest request = new GetValuesRequest(viewType, viewIndex, from, to, raster);
            request.addInstance(id, aggr);
            return this.getDVals(request)[0];
        }
        catch (Exception exc) {
            logger.error("Error at 'get_values'", (Throwable)exc);
            return null;
        }
    }

    @POST
    @Path(value="/dvals/get/raster2={raster2_str: [^/]*}&aggr2={aggr2_str: [^/]*}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public DValArray[] getDValsTwoStepAggregation(GetValuesRequest request, @PathParam(value="raster2_str") String raster2Str, @PathParam(value="aggr2_str") String aggr2Str) {
        try {
            RasterizedValues view = Server.getRawValuesViews().getValuesView(request.getViewType(), request.getViewIndex());
            long from = request.getFrom() != null ? request.getFrom().longValue() : view.getComputationBounds().getValuesStartTs();
            long to = request.getTo() != null ? request.getTo().longValue() : view.getComputationBounds().getValuesEndTs();
            IVarValuesCollection[] varValues = this.getVarValuesTwoStepAggregation(request, raster2Str, aggr2Str);
            DValArray[] result = new DValArray[varValues.length];
            int i = 0;
            while (i < result.length) {
                IVarValuesCollection varValsColl = varValues[i];
                double[] dVals = new double[varValsColl.size()];
                int j = 0;
                for (IVarValue val : varValsColl) {
                    dVals[j++] = val.getValue();
                }
                result[i] = new DValArray(from, to, dVals);
                ++i;
            }
            return result;
        }
        catch (Exception exc) {
            logger.error("Error at 'dvals/get'", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/supplementvalues/get/id={id}&from={from}&to={to}&raster={raster}&selector={selector: [^/]*}")
    @Produces(value={"application/json"})
    public IVarValuesCollection getSupplementValues(@PathParam(value="id") int id, @PathParam(value="from") long from, @PathParam(value="to") long to, @PathParam(value="raster") String rasterStr, @PathParam(value="selector") Integer selector) {
        try {
            VariableInstance instance = ORMCache.getVariableInstance((int)id);
            Aggregation aggr = instance.getVariable().getResultAggregation();
            Raster raster = Raster.valueOf((String)rasterStr);
            ArrayList supplementValues = SupplementStorage.getInstance().loadValues((Object)instance, (Object)selector, from, to);
            if (instance.getSupplementValueStrategy() == SupplementValueStrategy.Rasterized) {
                return IVarValuesCollection.create((IVarValue[])StoredValuesConverter.convertStoredNoParameterValues((List)supplementValues, (long)from, (long)to, (Raster)raster, (Aggregation)aggr, (boolean)true));
            }
            return IVarValuesCollection.create((IVarValue[])StoredValuesConverter.convertStoredParameterValues((ArrayList)supplementValues, (long)from, (long)to, (Raster)raster));
        }
        catch (Exception exc) {
            logger.error("Error at 'get_supplement'", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/supplementvalues/get_original/id={id}")
    @Produces(value={"application/json"})
    public SupplementValue[] getOriginalSupplementValues(@PathParam(value="id") int id) {
        try {
            VariableInstance instance = ORMCache.getVariableInstance((int)id);
            ArrayList originalValues = SupplementStorage.getInstance().loadValues((Object)instance, null);
            return originalValues.toArray(new SupplementValue[0]);
        }
        catch (Exception exc) {
            logger.error("Error at 'get_supplement'", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/supplementvalues/get_original/id={id}&from={from}&to={to}&selector={selector: [^/]*}")
    @Produces(value={"application/json"})
    public SupplementValue[] getOriginalSupplementValues(@PathParam(value="id") int id, @PathParam(value="from") long from, @PathParam(value="to") long to, @PathParam(value="selector") Integer selector) {
        try {
            VariableInstance instance = ORMCache.getVariableInstance((int)id);
            ArrayList originalValues = SupplementStorage.getInstance().loadValues((Object)instance, (Object)selector, from, to);
            LinkedList<SupplementValue> vals = new LinkedList<SupplementValue>();
            for (SupplementValue storageValue : originalValues) {
                if (storageValue.getIsParameterValue()) {
                    if (storageValue.getStartTimestamp() < from && !vals.isEmpty()) {
                        vals.clear();
                    }
                    vals.add(storageValue);
                    continue;
                }
                if (storageValue.getIntersectInterval(from, to) <= 0L) continue;
                vals.add(storageValue);
            }
            return vals.toArray(new SupplementValue[0]);
        }
        catch (Exception exc) {
            logger.error("Error at 'get_supplement'", (Throwable)exc);
            return null;
        }
    }

    @POST
    @Path(value="/supplementvalue/get_original/ts={ts}&selector={selector: [^/]*}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public SupplementValue[] getOriginalSupplementValues(int[] ids, @PathParam(value="ts") long ts, @PathParam(value="selector") Integer selector) {
        try {
            SupplementValue[] values = new SupplementValue[ids.length];
            long from = ts - 1L;
            long to = ts;
            int i = 0;
            while (i < ids.length) {
                VariableInstance instance = ORMCache.getVariableInstance((int)ids[i]);
                ArrayList originalValues = SupplementStorage.getInstance().loadValues((Object)instance, (Object)selector, from, ts);
                for (SupplementValue storageValue : originalValues) {
                    if (storageValue.getIsParameterValue()) {
                        values[i] = storageValue;
                        continue;
                    }
                    if (storageValue.getIntersectInterval(from, to) <= 0L) continue;
                    values[i] = storageValue;
                }
                ++i;
            }
            return values;
        }
        catch (Exception exc) {
            logger.error("Error at 'get_lastsupplementvalue'", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/currentvalue/get/id={id}")
    @Produces(value={"application/json"})
    public IVarValuesCollection getCurrentValue(@PathParam(value="id") int id) {
        try {
            VariableInstance instance = ORMCache.getVariableInstance((int)id);
            return IVarValuesCollection.create((IVarValue[])new IVarValue[]{Server.getRawValuesViews().getRealtimeView().getCurrentValueSync(instance)});
        }
        catch (Exception exc) {
            logger.error("Error at 'get_currentvalue'", (Throwable)exc);
            return null;
        }
    }

    @POST
    @Path(value="/currentvalues/get/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public IVarValuesCollection getCurrentValues(int[] ids) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (IVarValuesCollection values = new IVarValuesCollection();){
                int i = 0;
                while (i < ids.length) {
                    int id = ids[i];
                    VariableInstance instance = ORMCache.getVariableInstance((int)id);
                    values.add(Server.getRawValuesViews().getRealtimeView().getCurrentValueSync(instance));
                    ++i;
                }
                return values;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exc) {
            logger.error("Error at 'get_currentvalues'", (Throwable)exc);
            return null;
        }
    }

    @POST
    @Path(value="/currentvalues/get/view_type={view_type}&view_index={view_index: [^/]*}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public IVarValuesCollection getCurrentValues(@PathParam(value="view_type") RawValuesViewType viewType, @PathParam(value="view_index") Integer viewIndex, int[] ids) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (IVarValuesCollection values = new IVarValuesCollection();){
                int i = 0;
                while (i < ids.length) {
                    int id = ids[i];
                    VariableInstance instance = ORMCache.getVariableInstance((int)id);
                    values.add(Server.getRawValuesViews().getValuesView(viewType, viewIndex).getCurrentValueSync(instance));
                    ++i;
                }
                return values;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exc) {
            logger.error("Error at 'get_currentvalues'", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/current_varvalue/get/id={id}")
    @Produces(value={"application/json"})
    public VarValue getCurrentVarValue(@PathParam(value="id") int id) {
        try {
            VariableInstance instance = ORMCache.getVariableInstance((int)id);
            IVarValue value = Server.getRawValuesViews().getRealtimeView().getCurrentValueSync(instance);
            return new VarValue(value.getEndTimestamp(), value.getValue(), value.getQuality(), value.getValueSource());
        }
        catch (Exception exc) {
            logger.error("Error at 'get_currentvalue'", (Throwable)exc);
            return null;
        }
    }

    @POST
    @Path(value="/current_varvalues/get/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public VarValue[] getCurrentVarValues(int[] ids) {
        try {
            VarValue[] values = new VarValue[ids.length];
            int i = 0;
            while (i < ids.length) {
                int id = ids[i];
                VariableInstance instance = ORMCache.getVariableInstance((int)id);
                IVarValue value = Server.getRawValuesViews().getRealtimeView().getCurrentValueSync(instance);
                values[i] = new VarValue(value.getEndTimestamp(), value.getValue(), value.getQuality(), value.getValueSource());
                ++i;
            }
            return values;
        }
        catch (Exception exc) {
            logger.error("Error at 'get_currentvalue'", (Throwable)exc);
            return null;
        }
    }

    @POST
    @Path(value="/last_valid_varvalues/get/view_type={view_type}&view_index={view_index: [^/]*}&max_age={max_age}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public VarValue[] getLastValidVarValues(@PathParam(value="view_type") RawValuesViewType viewType, @PathParam(value="view_index") Integer viewIndex, @PathParam(value="max_age") long maxAge, int[] ids) {
        try {
            RasterizedValues view = Server.getRawValuesViews().getValuesView(viewType, viewIndex);
            VariableInstance[] instances = new VariableInstance[ids.length];
            int i = 0;
            while (i < ids.length) {
                instances[i] = ORMCache.getVariableInstance((int)ids[i]);
                ++i;
            }
            IVarValue[] iVarVals = view.getLastValidValueSync(instances, maxAge);
            VarValue[] values = new VarValue[ids.length];
            int i2 = 0;
            while (i2 < ids.length) {
                IVarValue value = iVarVals[i2];
                values[i2] = new VarValue(value.getEndTimestamp(), value.getValue(), value.getQuality(), value.getValueSource());
                ++i2;
            }
            return values;
        }
        catch (Exception exc) {
            logger.error("Error at 'get_last_valid_varvalues'", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/lastsupplementvalue/get_original/id={id}&selector={selector: [^/]*}")
    @Produces(value={"application/json"})
    public SupplementValue getLastOriginalSupplementValue(@PathParam(value="id") int id, @PathParam(value="selector") Integer selector) {
        ArrayList supplementValues;
        block3: {
            try {
                VariableInstance instance = ORMCache.getVariableInstance((int)id);
                long to = Server.getRawValuesViews().getRealtimeView().getComputationBounds().getValuesEndTs();
                supplementValues = SupplementStorage.getInstance().loadValues((Object)instance, (Object)selector, to - 1L, to);
                if (supplementValues.size() != 0) break block3;
                return null;
            }
            catch (Exception exc) {
                logger.error("Error at 'get_lastsupplementvalue'", (Throwable)exc);
                return null;
            }
        }
        return (SupplementValue)supplementValues.get(supplementValues.size() - 1);
    }

    @POST
    @Path(value="/lastsupplementvalue/get_original/selector={selector: [^/]*}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public SupplementValue[] getLastOriginalSupplementValues(int[] ids, @PathParam(value="selector") Integer selector) {
        try {
            SupplementValue[] values = new SupplementValue[ids.length];
            int i = 0;
            while (i < ids.length) {
                values[i] = this.getLastOriginalSupplementValue(ids[i], selector);
                ++i;
            }
            return values;
        }
        catch (Exception exc) {
            logger.error("Error at 'get_lastsupplementvalue'", (Throwable)exc);
            return null;
        }
    }

    @POST
    @Path(value="/supplementvalues/import/id={id}")
    @Consumes(value={"application/json"})
    public void importSupplementValues(@PathParam(value="id") int id, SupplementValue[] values) {
        if (!this.getUser().isAdmin()) {
            return;
        }
        try {
            VariableInstance instance = ORMCache.getVariableInstance((int)id);
            Server.getGlobalValuesWriter().importSupplementValues(instance, values);
        }
        catch (Exception exc) {
            logger.error("Error at 'import_supplementvalues'", (Throwable)exc);
        }
    }

    @GET
    @Path(value="/supplementvalues/delete/id={id}&from={from}&to={to}&selector={selector: [^/]*}")
    @Produces(value={"application/json"})
    public OperationResult deleteSupplementValues(@PathParam(value="id") int id, @PathParam(value="selector") Integer selector, @PathParam(value="from") long from, @PathParam(value="to") long to) {
        try {
            VariableInstance instance = ORMCache.getVariableInstance((int)id);
            Server.getCompoundValuesWriter().deleteSupplementValue(instance, selector, from, to, this.getUser());
            return OperationResult.SUCCESS;
        }
        catch (Exception exc) {
            logger.error("Error at 'delete supplement values'", (Throwable)exc);
            return new OperationResult(ResultType.UnexprectedError, exc.getMessage());
        }
    }

    @POST
    @Path(value="/supplementvalues/apply_changes/overwrite_later_unrasterized_values={overwrite_values}")
    @Produces(value={"application/json"})
    public OperationResult applySupplementValuesChanges(SupplementValueChange[] changes, @PathParam(value="overwrite_values") boolean overwriteLaterUnrasterizedValues) {
        try {
            if (Server.getCompoundValuesWriter().applySupplementValuesChanges(changes, overwriteLaterUnrasterizedValues, this.getUser())) {
                return OperationResult.SUCCESS;
            }
            return new OperationResult(ResultType.UnexprectedDbError, "error occured during writing supplement values changes");
        }
        catch (Exception exc) {
            logger.error("Error at 'apply supplement values changes'", (Throwable)exc);
            return new OperationResult(ResultType.UnexprectedError, exc.getMessage());
        }
    }

    @POST
    @Path(value="/time_interval_string_value/get/from={from: [^/]*}&to={to: [^/]*}")
    @Produces(value={"application/json"})
    public TimeIntervalStringValueCollection[] getTimeIntervalStringValues(@PathParam(value="from") Long fromTs, @PathParam(value="to") Long toTs, int[] ids) {
        try {
            TimeIntervalStringValueCollection[] result = new TimeIntervalStringValueCollection[ids.length];
            fromTs = fromTs != null ? fromTs : Long.MIN_VALUE;
            toTs = toTs != null ? toTs : Long.MAX_VALUE;
            int i = 0;
            int[] nArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                int id = nArray[n2];
                TimeIntervalStringValueCollection collection = new TimeIntervalStringValueCollection();
                ArrayList values = Server.getRawValuesViews().getGenericDB().loadValues((Object)new VariableInstance(id), fromTs.longValue(), toTs.longValue());
                for (TimeIntervalValue value : values) {
                    collection.add((TimeIntervalStringValue)value);
                }
                result[i++] = collection;
                ++n2;
            }
            return result;
        }
        catch (Exception exc) {
            logger.error("Error loading time interval string values collection", (Throwable)exc);
            return null;
        }
    }

    @POST
    @Path(value="/time_interval_string_value/apply_changes")
    @Produces(value={"application/json"})
    public OperationResult getTimeIntervalStringValuesApplyChanges(VariableInstanceTimeIntervalStringValues[] changes) {
        TimeIntervaTextDB db = Server.getRawValuesViews().getGenericDB();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (MDBXTxn txn = db.beginTransaction();){
                VariableInstanceTimeIntervalStringValues[] variableInstanceTimeIntervalStringValuesArray = changes;
                int n = changes.length;
                int n2 = 0;
                while (n2 < n) {
                    VariableInstanceTimeIntervalStringValues c = variableInstanceTimeIntervalStringValuesArray[n2];
                    VariableInstance instance = c.getInstance();
                    TimeIntervalStringValueCollection coll = c.getValues();
                    db.saveValues(txn, instance, coll.toArray());
                    ++n2;
                }
                txn.commit();
                return OperationResult.SUCCESS;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exc) {
            return new OperationResult(ResultType.UnexprectedError, exc.getMessage());
        }
    }

    @Override
    protected Serializable getId(VariableInstance object) {
        return object.getId();
    }
}

