/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.variable;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.structure.SearchPolicy;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.units.PhysicalUnit;
import de.elpro.ewms.core.variable.SupplementValueStrategy;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.VariableInstanceType;
import de.elpro.ewms.core.variable.VariableProperty;
import de.elpro.ewms.server.cache.ORMCache;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.helpers.ObjectTreeHelper;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import de.elpro.ewms.server.http.rest.model.AbstractRestService;
import de.elpro.ewms.server.http.rest.variable.VariableInstancesRestService;
import de.elpro.ewms.server.transactions.TransactionChangeset;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.SortedSet;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="variable")
public class VariableRestService
extends AbstractRestService<Variable> {
    private static final Logger logger = Activator.getLoggerFactory().createLogger(VariableRestService.class.getName());
    public static final VariableRestService INSTANCE = new VariableRestService();

    public VariableRestService() {
        super(Variable.class, (Comparable[])new Variable[0]);
    }

    @GET
    @Path(value="/get/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public Variable get(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        try {
            return ORMCache.getVariable((int)id);
        }
        catch (Exception exc) {
            logger.error("Error at 'get_variable'", (Throwable)exc);
            return null;
        }
    }

    @POST
    @Path(value="/get/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Variable[] get(@PathParam(value="trx") int trx, int[] ids) {
        try {
            return ORMCache.getVariables((int[])ids);
        }
        catch (Exception exc) {
            logger.error("Error at 'get_variable'", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/get_all/trx={trx}")
    @Produces(value={"application/json"})
    public Variable[] getAll(@PathParam(value="trx") int trx) {
        try {
            return ORMCache.getVariables();
        }
        catch (Exception exc) {
            logger.error("Error at 'get_all_variables'", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/get_all/trx={trx}&physical_unit_id={unit_id}")
    @Produces(value={"application/json"})
    public Variable[] getAll(@PathParam(value="trx") int trx, @PathParam(value="unit_id") String physicalUnitId) {
        try {
            LinkedList<Variable> vars = new LinkedList<Variable>();
            Variable[] variableArray = ORMCache.getVariables();
            int n = variableArray.length;
            int n2 = 0;
            while (n2 < n) {
                Variable var = variableArray[n2];
                if (PhysicalUnit.CONVERTER.toString((Object)var.getPhysicalUnit()).equals(physicalUnitId)) {
                    vars.add(var);
                }
                ++n2;
            }
            Collections.sort(vars);
            return vars.toArray(new Variable[0]);
        }
        catch (Exception exc) {
            logger.error("Error at 'get_all_variables'", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/get_by_class/trx={trx}&class_id={class_id}")
    @Produces(value={"application/json"})
    public Variable[] getByClass(@PathParam(value="trx") int trx, @PathParam(value="class_id") int classId) {
        try {
            LinkedList<Variable> vars = new LinkedList<Variable>();
            Variable[] variableArray = ORMCache.getVariables();
            int n = variableArray.length;
            int n2 = 0;
            while (n2 < n) {
                Variable var = variableArray[n2];
                if (var.getStructureClass().getId().equals(classId)) {
                    vars.add(var);
                }
                ++n2;
            }
            Collections.sort(vars);
            return vars.toArray(new Variable[0]);
        }
        catch (Exception exc) {
            logger.error("Error at 'get_all_variables'", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/get_by_name/trx={trx}&var_name={var_name: .*}")
    @Produces(value={"application/json"})
    public Variable getByName(@PathParam(value="trx") int trx, @PathParam(value="var_name") String varName) {
        try {
            Variable var = ORMCache.getVariable((String)varName);
            return var;
        }
        catch (Exception exc) {
            logger.error("Error at 'get_variable_by_name'", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/find_over_object_tree/trx={trx}&var_id={var_id}&object_id={object_id}&policy={policy: [^/]*}")
    @Produces(value={"application/json"})
    public VariableInstance[] findOverObjectTree(@PathParam(value="trx") int trx, @PathParam(value="var_id") int varId, @PathParam(value="object_id") int objectId, @PathParam(value="policy") String policyName) {
        try {
            SearchPolicy searchPolicy = policyName != null && !policyName.isEmpty() ? SearchPolicy.valueOf((String)policyName) : SearchPolicy.Auto;
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            Variable var = (Variable)em.find(Variable.class, (Object)varId);
            if (searchPolicy == SearchPolicy.All) {
                return var.getInstances().toArray(new VariableInstance[0]);
            }
            StructureObject structureObject = (StructureObject)em.find(StructureObject.class, (Object)objectId);
            StructureClass structureClass = var.getStructureClass();
            SortedSet objects = ObjectTreeHelper.findOverObjectTree((EntityManager)em, (StructureObject)structureObject, (StructureClass)structureClass, (SearchPolicy)searchPolicy);
            return (VariableInstance[])var.getInstances().stream().filter(i -> objects.contains(i.getStructureObject())).toArray(VariableInstance[]::new);
        }
        catch (Exception exc) {
            logger.error("Error at 'find_over_object_tree'", (Throwable)exc);
            return null;
        }
    }

    @POST
    @Path(value="/save_or_update/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult saveOrUpdate(@PathParam(value="trx") int trx, Variable variable) {
        boolean isNew;
        if (!this.getUser().isAdmin()) {
            return OperationResult.ACCESS_DENIED;
        }
        EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
        boolean bl = isNew = this.getId(variable) == null;
        if (!variable.getRoleIds().isEmpty()) {
            TypedQuery rolesQuery;
            if (isNew) {
                rolesQuery = em.createQuery("SELECT v FROM Variable v WHERE EXISTS (SELECT role FROM v.roleIds role WHERE role IN :role_ids)", Variable.class);
            } else {
                rolesQuery = em.createQuery("SELECT v FROM Variable v WHERE v.id != :v_id AND EXISTS (SELECT role FROM v.roleIds role WHERE role IN :role_ids)", Variable.class);
                rolesQuery.setParameter("v_id", (Object)variable.getId());
            }
            rolesQuery.setParameter("role_ids", (Object)variable.getRoleIds());
            Iterator iterator = rolesQuery.getResultList().iterator();
            if (iterator.hasNext()) {
                Variable v = (Variable)iterator.next();
                return new OperationResult(ResultType.UnexprectedError, String.format("One of used roles is already assignet to '%s' variable", v.toString()));
            }
        }
        HashSet defaultProperties = new HashSet(variable.getDefaultProperties());
        if (!isNew) {
            for (VariableProperty prop : defaultProperties) {
                VariableProperty id = new VariableProperty(variable, prop.getKey());
                if (em.find(VariableProperty.class, (Object)id) != null) {
                    em.merge((Object)prop);
                    continue;
                }
                em.persist((Object)prop);
            }
        }
        if (isNew) {
            em.persist((Object)variable);
            for (VariableProperty vp : defaultProperties) {
                vp.setVariable(variable);
                em.merge((Object)vp);
            }
        } else {
            variable = (Variable)em.merge((Object)variable);
        }
        TransactionChangeset.changedOrNew((int)trx, (Object)variable);
        return new OperationResult((Serializable)variable.getId(), ResultType.Success);
    }

    @GET
    @Path(value="/delete/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public OperationResult delete(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        if (!this.getUser().isAdmin()) {
            return OperationResult.ACCESS_DENIED;
        }
        try {
            VariableRestService.deleteVariable(trx, this.getUser(), id);
            return new OperationResult((Serializable)Integer.valueOf(id), ResultType.Success);
        }
        catch (Exception exc) {
            logger.error(String.format("Error deleting variable with id %d", id), (Throwable)exc);
            return new OperationResult((Serializable)Integer.valueOf(id), ResultType.UnexprectedDbError, String.format("Cannot delete %s object with id=%s", this.clazz.getSimpleName(), id), exc.toString());
        }
    }

    public static void deleteVariable(int trx, User user, int id) {
        EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)user);
        Variable variable = (Variable)em.find(Variable.class, (Object)id);
        VariableInstancesRestService.deleteVariableInstances(trx, user, variable.getInstances().stream().mapToInt(i -> i.getId()).toArray());
        em.createQuery("DELETE FROM VarSeries2D o WHERE o.variable = :var").setParameter("var", (Object)variable).executeUpdate();
        em.createQuery("DELETE FROM VarSeries3D o WHERE o.XAxisVariable = :var OR o.YAxisVariable = :var OR o.ZAxisVariable = :var OR o.WAxisVariable = :var ").setParameter("var", (Object)variable).executeUpdate();
        em.createQuery("DELETE FROM Column o WHERE o.variable = :var").setParameter("var", (Object)variable).executeUpdate();
        em.remove((Object)variable);
        TransactionChangeset.removed((int)trx, (Object)variable);
    }

    @GET
    @Path(value="/update_variable_instances/trx={trx}&id={id}&type={type}&supplement_value_strategy={strategy: [^/]*}")
    @Produces(value={"application/json"})
    public OperationResult updateVariableInstances(@PathParam(value="trx") int trx, @PathParam(value="id") int id, @PathParam(value="type") String typeStr, @PathParam(value="strategy") String strategyStr) {
        if (!this.getUser().isAdmin()) {
            return OperationResult.ACCESS_DENIED;
        }
        try {
            VariableInstanceType type = VariableInstanceType.valueOf((String)typeStr);
            SupplementValueStrategy strategy = null;
            if (strategyStr != null && !strategyStr.isEmpty()) {
                strategy = SupplementValueStrategy.valueOf((String)strategyStr);
            }
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            em.flush();
            em.clear();
            Variable variable = (Variable)this.getGeneric(trx, Integer.valueOf(id));
            Set existingInstances = variable.getInstances();
            StructureClass structureClass = (StructureClass)em.find(StructureClass.class, (Object)variable.getStructureClass().getId());
            Set allObjects = structureClass.getAllObjects();
            for (StructureObject object : allObjects) {
                boolean exists = false;
                for (VariableInstance existingInstance : existingInstances) {
                    if (!existingInstance.getStructureObject().equals((Object)object)) continue;
                    exists = true;
                    break;
                }
                if (exists) continue;
                VariableInstance newInstance = new VariableInstance(type, strategy, variable, object);
                em.persist((Object)newInstance);
                TransactionChangeset.changedOrNew((int)trx, (Object)newInstance);
            }
            for (VariableInstance existingInstance : existingInstances) {
                if (allObjects.contains(existingInstance.getStructureObject())) continue;
                em.createQuery("DELETE FROM VariableInstanceExplicitDependency d WHERE d.dependentOn = :instance").setParameter("instance", (Object)existingInstance).executeUpdate();
                em.remove((Object)existingInstance);
                TransactionChangeset.removed((int)trx, (Object)existingInstance);
            }
            return OperationResult.SUCCESS;
        }
        catch (Exception exc) {
            return new OperationResult((Serializable)Integer.valueOf(id), ResultType.UnexprectedDbError, String.format("Cannot create missing instances for object with id=%s", this.clazz.getSimpleName(), id), exc.toString());
        }
    }

    protected Integer getId(Variable object) {
        return object.getId();
    }
}

