/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.variable;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.structure.IStructureClassRole;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.variable.IVariableRole;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.VariableRole;
import de.elpro.ewms.server.cache.ORMCache;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.helpers.VariableRoleHelper;
import de.elpro.ewms.server.http.rest.auth.AuthenticatedRestService;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import de.elpro.ewms.server.roles.Roles;
import java.util.Collections;
import java.util.LinkedList;
import javax.persistence.EntityManager;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="variable/role")
public class VariableRolesRestService
extends AuthenticatedRestService {
    public static final Logger logger = Activator.getLoggerFactory().createLogger(VariableRolesRestService.class.getName());

    @GET
    @Path(value="/get/id={id}")
    @Produces(value={"application/json"})
    public VariableRole get(@PathParam(value="id") String id) {
        return VariableRole.of((IVariableRole)Roles.getVariableRole((String)id));
    }

    @GET
    @Path(value="/get_all/trx={trx}")
    @Produces(value={"application/json"})
    public VariableRole[] getAll(@PathParam(value="trx") int trx) {
        return (VariableRole[])Roles.getAllVariableRoles().stream().map(r -> VariableRole.of((IVariableRole)r)).toArray(VariableRole[]::new);
    }

    @GET
    @Path(value="/get_all/trx={trx}&class_id={class_id}")
    @Produces(value={"application/json"})
    public VariableRole[] getAll(@PathParam(value="trx") int trx, @PathParam(value="class_id") int id) {
        EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
        StructureClass structureClass = (StructureClass)em.find(StructureClass.class, (Object)id);
        LinkedList roles = new LinkedList();
        for (StructureClass pClass : structureClass.getAllParentClasses()) {
            for (String classRoleId : pClass.getRoleIds()) {
                IStructureClassRole classRole = Roles.getClassRole((String)classRoleId);
                if (classRole == null) continue;
                roles.addAll(Roles.getVariableRoles((String)classRole.getId()));
            }
        }
        Collections.sort(roles, (r1, r2) -> r1.getName().compareTo(r2.getName()));
        return (VariableRole[])roles.stream().map(r -> VariableRole.of((IVariableRole)r)).toArray(VariableRole[]::new);
    }

    @GET
    @Path(value="/get_all/trx={trx}&class_id={class_id}&pu_key={pu_key}")
    @Produces(value={"application/json"})
    public VariableRole[] getAll(@PathParam(value="trx") int trx, @PathParam(value="class_id") int id, @PathParam(value="pu_key") String physicalUnitKey) {
        EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
        StructureClass structureClass = (StructureClass)em.find(StructureClass.class, (Object)id);
        LinkedList<IVariableRole> roles = new LinkedList<IVariableRole>();
        for (StructureClass pClass : structureClass.getAllParentClasses()) {
            for (String classRoleId : pClass.getRoleIds()) {
                IStructureClassRole classRole = Roles.getClassRole((String)classRoleId);
                if (classRole == null) continue;
                for (IVariableRole variableRole : Roles.getVariableRoles((String)classRole.getId())) {
                    if (!variableRole.getPhysicalUnit().getKey().equals(physicalUnitKey)) continue;
                    roles.add(variableRole);
                }
            }
        }
        Collections.sort(roles, (r1, r2) -> r1.getName().compareTo(r2.getName()));
        return (VariableRole[])roles.stream().map(r -> VariableRole.of((IVariableRole)r)).toArray(VariableRole[]::new);
    }

    @GET
    @Path(value="/get_variables/trx={trx}&role_id={role_id}")
    @Produces(value={"application/json"})
    public Variable[] getVariablesByRole(@PathParam(value="trx") int trx, @PathParam(value="role_id") String roleId) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            return VariableRoleHelper.getVariablesByRole((EntityManager)em, (String)roleId);
        }
        catch (Exception exc) {
            logger.error("Error at get_all_variables", (Throwable)exc);
            return new Variable[0];
        }
    }

    @GET
    @Path(value="/get_variable/trx={trx}&role_id={role_id}")
    @Produces(value={"application/json"})
    public Variable getUniqieVariableByRole(@PathParam(value="trx") int trx, @PathParam(value="role_id") String roleId) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            return VariableRoleHelper.getUniqueVariableByRole((EntityManager)em, (String)roleId);
        }
        catch (Exception exc) {
            logger.error("Error at get_all_variables", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/get_variable_instance/trx={trx}&role_id={role_id}&obj_id={obj_id}")
    @Produces(value={"application/json"})
    public VariableInstance getVariableInstanceByRole(@PathParam(value="trx") int trx, @PathParam(value="role_id") String roleId, @PathParam(value="obj_id") int objId) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            return VariableRoleHelper.getVariableInstance((EntityManager)em, (String)roleId, (StructureObject)new StructureObject(objId));
        }
        catch (Exception exc) {
            logger.error("Error at get_variable_instance", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/get_variable_instance/trx={trx}&role_id={role_id}&obj_key={obj_key}")
    @Produces(value={"application/json"})
    public VariableInstance getVariableInstanceByRoleAndObjectKey(@PathParam(value="trx") int trx, @PathParam(value="role_id") String roleId, @PathParam(value="obj_key") String objKey) {
        StructureObject object;
        EntityManager em;
        block3: {
            try {
                em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
                object = ORMCache.getStructureObject((String)objKey);
                if (object != null) break block3;
                return null;
            }
            catch (Exception exc) {
                logger.error("Error at get_variable_instance", (Throwable)exc);
                return null;
            }
        }
        return VariableRoleHelper.getVariableInstance((EntityManager)em, (String)roleId, (StructureObject)object);
    }
}

